/**********************************************************************
 
	Copyright (C) 2005- Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"machine/include.h"
#include	"memory_debug.h"
#include	"pri_level.h"
#include	"lock_level.h"
#include	"utils.h"
#include	"task.h"
#include	"matrix.h"
#include	"xl.h"
#include	"xlerror.h"

XL_SEXP *
xl_mxSet(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf);

void
init_mxSet(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"mxSet"),
		get_func_prim(xl_mxSet,FO_APPLICATIVE,0,4,4));
}


XL_SEXP *
xl_mxSet(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
int _ch;
XL_SEXP * ch;
int ret;
MATRIX_TOKEN * t;
	t = get_env_work(env);
	if ( t == 0 )
		return 0;
	ch = get_el(s,1);
	if ( get_type(ch) != XLT_INTEGER )
		goto type_missmatch;
	_ch = ch->integer.data;
	ret = set_channel_sexp(t->process_node,_ch,get_el(s,2));
	if ( ret < 0 )
		goto inv_param;
	return get_integer(ret,0);
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"mxSet"),
		0);
inv_param:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"mxSet"),
		n_get_string("invalid parameter in mxSet"));
no_obj:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_OBJECT,
		l_string(std_cm,"mxSet"),
		n_get_string("invalid object in channel of NODE"));
matrix_err:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_OBJECT,
		l_string(std_cm,"mxSet"),
		n_get_string("invalid matrix loading"));
}





