/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#define STREAM_LIB

#include	"stream.h"
#include	"task.h"
#include	"utils.h"
#include	"pri_level.h"

int flush_cnt;

extern SEM stream_lock;

int
s_flush(STREAM * s)
{
S_TABLE * tbl;
S_FILE_THREAD t;
int ret;
int pri;
	pri = push_pri(PRI_NETWORK);

	lock_task(stream_lock);
	if ( s == 0 ) {
		unlock_task(stream_lock,"s_flush");
		change_pri(0,pri);
		return -1;
	}
	if ( s->h.tbl == 0 ) {
		unlock_task(stream_lock,"s_flush");
		change_pri(0,pri);
		return -1;
	}
	tbl = s->h.tbl;
	_s_insert_thread(s,&t);
	unlock_task(stream_lock,"s_flush");
	change_pri(0,pri);

	ret = (*tbl->flush)(s);


	s_delete_thread(s,&t);


	return ret;
}
