/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"xl.h"
#include	"associate.h"

XL_SEXP * xl_ConvertCode();
L_CHAR *cc_string(L_CHAR * str,LCZ_SET * set);
XL_SEXP * convert_code(XL_SEXP * st,LCZ_SET * set);

void
init_ConvertCode(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"ConvertCode"),
		get_func_prim(xl_ConvertCode,FO_NORMAL,0,2,2));
}


L_CHAR *
cc_string(L_CHAR * str,LCZ_SET * set)
{
L_CHAR * ret;
	if ( str == 0 )
		return 0;
	ret = code_convert_with_combine(str,l_strlen(str),
			set,CBF_SRC_PLANE|CBF_DST_PLANE|CBF_ERR_KEEP);
	set_buffer(ret);
	return ret;
}

XL_SEXP *
convert_code(XL_SEXP * st,LCZ_SET * set)
{
XL_SEXP * ret, * _ret;
XL_SYM_FIELD * sf;

	switch ( get_type(st) ) {
	case XLT_NULL:
		return 0;
	case XLT_ERROR:
		return get_error(
			st->h.file,
			st->h.line,
			st->err.code,
			cc_string(st->err.func,set),
			convert_code(st->err.data,set));
	case XLT_PAIR:
		ret = 0;
		for ( ; get_type(st) == XLT_PAIR ; st = cdr(st) )
			ret = cons(convert_code(car(st),set),ret);
		_ret = convert_code(st,set);
		for ( ; get_type(ret) == XLT_PAIR ; ret = cdr(ret) )
			_ret = cons(car(ret),_ret);
		return _ret;
	case XLT_SYMBOL:
		ret = get_symbol(cc_string(st->symbol.data,set));
		for ( sf = st->symbol.field ; sf ; sf = sf->next )
			set_attribute(ret,
				cc_string(sf->name,set),
				cc_string(sf->data,set));
		return ret;
	case XLT_STRING:
		return get_string(cc_string(st->string.data,set));
	case XLT_INTEGER:
		return get_integer(st->integer.data,
				cc_string(st->integer.unit,set));
	case XLT_FLOAT:
		return get_floating(st->floating.data,
				cc_string(st->floating.unit,set));
	case XLT_FUNC:
	case XLT_PTR:
	case XLT_RAW:
	case XLT_ENV:
		return st;
	default:
		er_panic("ConvertCode");
	}
	return st;
}

XL_SEXP *
xl_ConvertCode(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,XL_SYM_FIELD * sf)
{
L_CHAR * type;
XL_SEXP * st;
CODE_METHOD * cm;
L_CHAR * _cm;
	_cm = get_sf_attribute(sf,l_string(std_cm,"code"));
	if ( _cm == 0 )
		cm = std_cm;
	else {
		cm = search_cm(n_string(std_cm,_cm));
		if ( cm == 0 )
			goto inv_param;
	}
	type = get_sf_attribute(sf,l_string(std_cm,"type"));
	st = gb_quote_trace(env,get_el(s,1),type);
	return convert_code(st,cm->main_code);
/*
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"ConvertCode"),
		n_get_string("type missmatch"));
*/
inv_param:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"ConvertCode"),
		n_get_string("invalid code name"));
}

