/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef ___V_PANGO_H___
#define ___V_PANGO_H___

#include	"machine/v_m.h"

#ifdef __cplusplus
extern "C" {
#endif

#include	"long_char.h"

#define BLOCK_SIZE		256
#define TOTAL_BLOCKS		0x10000

typedef struct v_p_cov {
	unsigned char *		blocks[TOTAL_BLOCKS];
} V_P_COV;

#define VPC_GET_ENTRY(ch)	((ch)/BLOCK_SIZE)
#define VPC_GET_BLOCK(ch)	((ch)%BLOCK_SIZE)
#define VPC_GET_BLOCK_BIT_CHAR(ch)	(VPC_GET_BLOCK(ch)/8)
#define VPC_GET_BLOCK_BIT_SHIFT(ch)	(VPC_GET_BLOCK(ch)%8)


typedef struct v_p_coverage_cache {
	struct v_p_coverage_cache *	next;
	int				size;
	PangoFontDescription *		fd;
	PangoFont *			font;
	PangoCoverage *			cov;
	PangoContext *			context;
	V_P_COV				dt_cov;
} V_P_COVERAGE_CACHE;

typedef struct v_pango_font {
	char *				fontname;
	struct v_p_coverage_cache *	coverage;
} V_PANGO_FONT;


extern LC_FONT_ENGINE_TYPE pango_font_engine_type;

void v_init_pango();

#ifdef __cplusplus
}
#endif

#endif



