/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<stdlib.h>
#include	<stdio.h>
#include	"machine/v_x11.h"
#include	"memory_debug.h"

int
v_get_text_minrect_8(
	VRECT * r,
	VOBJECT * obj,
	VPOINT * st,
	XFontStruct * fs,
	char * str,
	int len)
{
int dir,ascent,descent;
XCharStruct cs;
int width;

	XSetFont(obj->header.win->d->d,
		obj->header.win->gc,
		fs->fid);
	XTextExtents(fs,
		str,
		len,
		&dir,
		&ascent,
		&descent,
		&cs);
	switch ( dir ) {
	case FontRightToLeft:
		r->br.x = obj->vtext.in.st_x-cs.lbearing;
		r->tl.x = obj->vtext.in.st_x-cs.rbearing;
		break;
	case FontLeftToRight:
		r->tl.x = obj->vtext.in.st_x+cs.lbearing;
		r->br.x = obj->vtext.in.st_x+cs.rbearing;
		break;
	}
	r->tl.y = st->y-ascent;
	r->br.y = st->y+descent;
	width = XTextWidth(fs,str,len);
	st->x += width;
	return 0;
}

void
v_draw_text_one_font_8(
	VRECT * r,
	VOBJECT * obj,
	VPOINT * st,
	char * str,
	int len,
	XFontStruct * fs)
{

	XSetFont(obj->header.win->d->d,
		obj->header.win->gc,
		fs->fid);
	if ( obj->vtext.in.background & C_NULL ) {
		XSetForeground(
			obj->header.win->d->d,
			obj->header.win->gc,
			GB2MCOLOR_D(obj->header.win->d,
				obj->vtext.in.color));
		XDrawString(
			obj->header.win->d->d,
			obj->header.win->w,
			obj->header.win->gc,
			st->x,
			st->y,
			str,
			len);
	}
	else {
		XSetForeground(
			obj->header.win->d->d,
			obj->header.win->gc,
			GB2MCOLOR_D(obj->header.win->d,
				obj->vtext.in.color));
		XSetBackground(
			obj->header.win->d->d,
			obj->header.win->gc,
			GB2MCOLOR_D(obj->header.win->d,
				obj->vtext.in.background));

		XDrawImageString(
			obj->header.win->d->d,
			obj->header.win->w,
			obj->header.win->gc,
			st->x,
			st->y,
			str,
			len);
	}
	v_get_text_minrect_8(r,obj,st,fs,str,len);
}

int
v_get_text_minrect_16(
	VRECT * r,
	VOBJECT * obj,
	VPOINT * st,
	XFontStruct * fs,
	XChar2b * str,
	int len)
{
int dir,ascent,descent;
XCharStruct cs;
int width;

	XSetFont(obj->header.win->d->d,
		obj->header.win->gc,
		fs->fid);
	XTextExtents16(fs,
		str,
		len,
		&dir,
		&ascent,
		&descent,
		&cs);
	switch ( dir ) {
	case FontRightToLeft:
		r->br.x = obj->vtext.in.st_x-cs.lbearing;
		r->tl.x = obj->vtext.in.st_x-cs.rbearing;
		break;
	case FontLeftToRight:
		r->tl.x = obj->vtext.in.st_x+cs.lbearing;
		r->br.x = obj->vtext.in.st_x+cs.rbearing;
		break;
	}
	r->tl.y = st->y-ascent;
	r->br.y = st->y+descent;
	width = XTextWidth16(fs,str,len);
	st->x += width;
	return 0;
}

void
v_draw_text_one_font_16(
	VRECT * r,
	VOBJECT * obj,
	VPOINT * st,
	XChar2b * str,
	int len,
	XFontStruct * fs)
{
	XSetFont(obj->header.win->d->d,
		obj->header.win->gc,
		fs->fid);
	if ( obj->vtext.in.background & C_NULL ) {
		XSetForeground(
			obj->header.win->d->d,
			obj->header.win->gc,
			GB2MCOLOR_D(obj->header.win->d,
				obj->vtext.in.color));
		XDrawString16(
			obj->header.win->d->d,
			obj->header.win->w,
			obj->header.win->gc,
			st->x,
			st->y,
			str,
			len);
	}
	else {
		XSetForeground(
			obj->header.win->d->d,
			obj->header.win->gc,
			GB2MCOLOR_D(obj->header.win->d,
				obj->vtext.in.color));
		XSetBackground(
			obj->header.win->d->d,
			obj->header.win->gc,
			GB2MCOLOR_D(obj->header.win->d,
				obj->vtext.in.background));

		XDrawImageString16(
			obj->header.win->d->d,
			obj->header.win->w,
			obj->header.win->gc,
			st->x,
			st->y,
			str,
			len);
	}
	v_get_text_minrect_16(r,obj,st,fs,str,len);
}


char *
convert_8(LCF_SET * str,int len)
{
char * ret;
int i;
	ret = d_alloc(len);
	for ( i = 0; i < len ; i ++ )
		ret[i] = str[i].ch;
	return ret;
}

char *
convert_7(LCF_SET * str,int len)
{
char * ret;
int i;
	ret = d_alloc(len);
	for ( i = 0; i < len ; i ++ )
		ret[i] = str[i].ch&0x7f;
	return ret;
}

XChar2b *
convert_16(LCF_SET * str,int len)
{
XChar2b * ret;
int i;
	ret = d_alloc(len*sizeof(XChar2b));
	for ( i = 0 ; i < len ; i ++ ) {
		ret[i].byte1 = (str[i].ch>>8)&0xff;
		ret[i].byte2 = str[i].ch&0xff;
	}
	return ret;
}


void
v_draw_text_one_font(
	VRECT * r,
	VOBJECT * obj,
	VPOINT * st,
	LCF_SET * str,
	int len,
	VFONT * vf,
	int size,
	L_CHAR mask)
{
char * str8;
XChar2b * str16;
XFontStruct * fs;
int i;
	for ( i = 0 ; i < vf->vlist_len ; i ++ )
		if ( vf->vlist[i].size == size )
			break;
	if ( i == vf->vlist_len )
		er_panic("v_draw_text_one_font");
	fs = vf->vlist[i].fs;

	if ( fs->min_byte1 == 0 && fs->max_byte1 == 0 ) {
		if ( mask == LCZM_7b_TYPE ) {
			str8 = convert_7(str,len);
			v_draw_text_one_font_8(r,obj,st,str8,len,fs);
			d_f_ree(str8);
		}
		else {
			str8 = convert_8(str,len);
			v_draw_text_one_font_8(r,obj,st,str8,len,fs);
			d_f_ree(str8);
		}
	}
	else {
		str16 = convert_16(str,len);
		v_draw_text_one_font_16(r,obj,st,str16,len,fs);
		d_f_ree(str16);
	}
}

void
v_after_handling(VOBJECT * obj)
{
	XFlush(obj->header.win->d->d);
}

