/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<stdlib.h>
#include	"memory_debug.h"
#include	"task.h"
#include	"lock_level.h"
#include	"utils.h"
#include	"pri_level.h"

#define SW_HASH_SIZE	100
/*
typedef struct sw_hash {
	struct sw_hash *	next;
	unsigned int		key;
	int			cnt;
	sem_t			sem;
} SW_HASH;
*/
D_SEM sw_lock;


SW_HASH * sw_hash_table[SW_HASH_SIZE];

void
sw_init()
{
	sw_lock = xx_new_lock(LL_SLEEP_WAKEUP,__FILE__,__LINE__);
}

void
_sleep_task(unsigned int key,D_SEM s, char *file,int line)
{
unsigned int kk;
SW_HASH * h;
int pri;
	kk = key%SW_HASH_SIZE;
	pri = push_pri(PRI_SLEEP_WAIT);
	_lock_task(sw_lock,__FILE__,__LINE__);
	for ( h = sw_hash_table[kk]; h ; h = h->next )
		if ( h->key == key ) {
			h->cnt ++;
			_unlock_task(sw_lock,"sleep_task(1)",__FILE__,__LINE__);
			goto last;
		}
//	_unlock_task(sw_lock,"sleep_task(2)",__FILE__,__LINE__);

	h = malloc(sizeof(*h));
	h->key = key;
	h->cnt = 1;
	sem_init(&h->sem,0,1);
	sem_trywait(&h->sem);

//	_lock_task(sw_lock,__FILE__,__LINE__);
	h->next = sw_hash_table[kk];
	sw_hash_table[kk] = h;
	_unlock_task(sw_lock,"sleep_task(3)",__FILE__,__LINE__);
last:
	if ( s )
		_unlock_task(s,"sleep_task(4)",__FILE__,__LINE__);

	sem_wait(&h->sem);

	_lock_task(sw_lock,__FILE__,__LINE__);

	h->cnt --;
	if ( h->cnt == 0 ) {
		sem_destroy(&h->sem);
		free(h);
	}
	_unlock_task(sw_lock,"sleep_task(5)",__FILE__,__LINE__);
	change_pri(0,pri);
	return;
}

void
_wakeup_task(unsigned int key, char *file, int line)
{
unsigned int kk;
int i;
SW_HASH * h, ** hp;
int pri;
	kk = key%SW_HASH_SIZE;
	pri = push_pri(PRI_SLEEP_WAIT);
	_lock_task(sw_lock,__FILE__,__LINE__);
	for ( hp = &sw_hash_table[kk] ; *hp ; hp = &(*hp)->next )
		if ( (*hp)->key == key )
			goto next;
	_unlock_task(sw_lock,"wakeup_task(1)",__FILE__,__LINE__);
	return;
next:
	h = *hp;
	*hp = h->next;
	for ( i = h->cnt ; i ; i -- )
		sem_post(&h->sem);
	_unlock_task(sw_lock,"wakeup_task(2)",__FILE__,__LINE__);
	change_pri(0,pri);
}

#ifdef WIN32

int sleep(int n)
{
	Sleep(n*1000);
	return 0;
}

int usleep(int n)
{
	Sleep(n);
	return 0;
}

#endif
