/**********************************************************************

	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomohito Nakajima <nakajima@zeta.co.jp>
	Tomoki Sekiyama <sekiyama@yahoo.co.jp>

	This program is free software; you can redistribute it
	and/or modify it under the terms of the GLOBALBASE
	Library General Public License (G-LGPL) as published by

	http://www.globalbase.org/

	This program is distributed in the hope that it will be
	useful, but WITHOUT ANY WARRANTY; without even the
	implied warranty of MERCHANTABILITY or FITNESS FOR A
	PARTICULAR PURPOSE.

**********************************************************************/


#include "machine/gb_windows.h"
#include "vwin_control.h"
#include "v/VTableView.h"
#include "v/VLayout.h"
#include "VApplication.h"
#include "vwin_error.h"

extern VInfo* make_AlignView(
	const VObjectStatus *s, VObject* obj, VContainerInfo *parent_info, int id, DWORD st);


VExError
VTableView::create_do(const VObjectStatus* s, int flags, VObject *parent, void * arg)
{
	table_set *set = (table_set *)arg;
	rows = set->rows > 0 ? set->rows : 1;
	cols = set->cols > 0 ? set->cols : 1;

	info = make_AlignView(s,this,VInfo::get_container_info(parent),s->id, 0);

	for ( int key = 0 ; key < v_table_child_hash_size ; key++ )
		child_hash[key] = 0;

	return parent->add_child_do(this);
}

void
VTableView::destroy_do(VObject *parent)
{
	parent->remove_child_do(this);
	if(info){
		v_serialized_exec_sub(::DestroyWindow, info->get_hwnd());
		delete info;
		info = NULL;
	}
}

VTableView::~VTableView()
{
}

VExError
VTableView::get_status(VObjectStatus *s, int flags) const
{
	V_OP_START_EX
	VExError err = VObject::get_status(s,flags);
	win_control_default_get_status(info->get_hwnd(), s, flags, &err);
	V_OP_END
	return err;
};

VExError
VTableView::set_status(const VObjectStatus *s, int flags)
{
	V_OP_START_EX

	VExError err = VObject::set_status(s,flags);
	HWND hwnd = info->get_hwnd();
	win_control_default_set_status(hwnd, s, flags, &err);

	if ( flags & VSF_CALC_MIN ) {
		for ( VObjectList *list = sts.children ; list ; list = list->next )
			list->object->set_status(0, VSF_CALC_MIN);
		VLayout layout;
		layout.layout_in_table_view(this, true);
		sts.min_size = layout.parent_min_size();
		err.subcode1 &= ~VSF_CALC_MIN;
	}
	if ( flags & VSF_LAYOUT ) {
		VLayout layout;
		layout.layout_in_table_view(this);
		layout.do_layout(this);
		err.subcode1 &= ~VSF_LAYOUT;
	}

	if ( flags & VSF_VISIBLE ) {
		if ( s->visible != (::IsWindowVisible(hwnd)!=FALSE) ){
			v_serialized_exec_sub(ShowWindow, hwnd, s->visible ? SW_SHOW : SW_HIDE);
		}
		err.subcode1 &= ~VSF_VISIBLE;
	}

	V_OP_END

	if ( flags & ( VSF_HOMOGEN | VSF_SPACING | VSF_ALIGN | VSF_PADDING ) )
		VLayout::mark(this);
	
	return err;
}

VExError VTableView::add_child_do(VObject* child)
{
	add_child_hash(child, 0, 0, rows, cols);	// assume attached all over the table
	return initial_VExError(V_ER_NO_ERR,0,0);
}

void
VTableView::remove_child_do(VObject* child)
{
	remove_child_hash(child);
	int debug = 1;
}

VExError
VTableView::resize_table(short rows, short cols)
{
	VExError err = initial_VExError(V_ER_NO_ERR, 0, 0);
	if ( rows <= 0 || cols <= 0 )
		err.code = V_ER_PARAM;
	else {
		V_OP_START_EX
		this->rows = rows;
		this->cols = cols;
		V_OP_END
	}
	return err;
}

VExError
VTableView::attach_child(VObject* child,
			short row, short col, short row_span, short col_span)
{
	VObject * nmc;

	VExError err = initial_VExError(V_ER_NO_ERR, 0, 0);
	V_OP_START_EX

	if ( row < 0 || col < 0 || row_span <= 0 || col_span <= 0 ||
			row + row_span > rows || col + col_span > cols ) {
		err.code = V_ER_PARAM;
		goto end;
	}

	nmc = child->get_nmc(0);
	if ( nmc == 0 ) {
		err.code = V_ER_NOT_READY;
		goto end;
	}

	// check child is in the children list
	if ( search_child_hash(nmc) == 0 ) {
		err.code = V_ER_NOT_FOUND;
		goto end;
	}

	add_child_hash(nmc, row, col, row_span, col_span);
end:
	V_OP_END
	if ( err.code == V_ER_NO_ERR )
		VLayout::mark(this);
	return err;
}

bool
VTableView::get_child_place(VObject *child,
			short *row, short *col, short *row_span, short *col_span)
{
	_V_OP_START(false)
	table_child_set *c = search_child_hash(child);
	if ( c == 0 ) {
		V_OP_END
		return false;
	}
	if ( row )
		*row = c->row;
	if ( col )
		*col = c->col;
	if ( row )
		*row_span = c->row_span;
	if ( col )
		*col_span = c->col_span;
	V_OP_END
	return true;
}

void
VTableView::child_status_changed(VObject* child, VInfo* info)
{
	// do nothing - object is marked when status is changed
}

void
VTableView::redraw(VRect* rect) const
{
	if ( ! info )
		return;
	_V_OP_START_VOID
	win_redraw(info->get_hwnd(), rect);
	V_OP_END
}

VTableView::table_child_set *
VTableView::add_child_hash(VObject *child, 
			short row, short col, short row_span, short col_span)
{
	table_child_set *c;
	unsigned int key = hash_key(child);
	
	for ( c = child_hash[key] ; c ; c = c->next )
		if ( c->child == child )
			break;
	if ( c == 0 ) {
		c = new table_child_set;
		c->child = child;
		c->row = c->col = 0;
		c->row_span = c->col_span = 1;
		c->next = child_hash[key];
		child_hash[key] = c;
	}
	if ( row >= 0 && col >= 0 ) {
		c->row = row;
		c->col = col;
		c->row_span = row_span;
		c->col_span = col_span;
	}
	return c;
}

void
VTableView::remove_child_hash(VObject *child)
{
	table_child_set *c, *p = 0;
	unsigned int key = ((unsigned)(child) >> 2) % v_table_child_hash_size;
	for ( c = child_hash[key] ; c ; p = c, c = c->next )
		if ( c->child == child )
			break;
	if ( c ) {
		if ( p )
			p->next = c->next;
		else
			child_hash[key] = c->next;
		delete c;
	}
}

VTableView::table_child_set *
VTableView::search_child_hash(VObject *child)
{
	table_child_set *c;
	unsigned int key = hash_key(child);
	
	for ( c = child_hash[key] ; c ; c = c->next )
		if ( c->child == child )
			return c;
	return 0;
}
