/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
                  2004 Tomohito Nakajima <nakajima@zeta.co.jp>

	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifndef ___ENDIAN_H___
#define ___ENDIAN_H___

#include "gbgraph.h"

extern char endian_flag;

#define force_change_endian(data) \
{\
    char tmp___;\
    int i___;\
    char *ptr___;\
    ptr___ = (char*)&(data);\
    for(i___=0 ;i___<sizeof(data)/2; ++i___){\
        tmp___ = *(ptr___+i___);\
        *(ptr___+i___) = *(ptr___+sizeof(data)-i___-1);\
        *(ptr___+sizeof(data)-i___-1) = tmp___;\
    }\
}

#define change_endian_if_big(data) \
	if( endian_flag );else{\
		force_change_endian(data);\
	}

#define change_endian(data) \
    if ( !endian_flag );else{\
		force_change_endian(data);\
	}

/*
#define change_endian(data) \
    if ( !endian_flag );else{\
        char tmp___;\
        int i___;\
        char *ptr___;\
        ptr___ = (char*)&(data);\
        for(i___=0 ;i___<sizeof(data)/2; ++i___){\
            tmp___ = *(ptr___+i___);\
            *(ptr___+i___) = *(ptr___+sizeof(data)-i___-1);\
            *(ptr___+sizeof(data)-i___-1) = tmp___;\
        }\
    }
*/

#define change_endian_f change_endian
#define change_endian_d change_endian
#define change_endian_s change_endian
#define change_endian_i change_endian

void check_endian();

void change_endian_gb_point(GB_POINT * p);
void change_endian_gb_rect(GB_RECT * r);
void change_endian_gb_color(GB_COLOR * c);
void change_endian_l_char(L_CHAR * str);
void change_endian_gb_time(GB_TIME * t);
void change_endian_affen2d(AFFEN2D * a);





#endif
