/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifndef ___WIN_FLAME_H___
#define ___WIN_FLAME_H___

#include	"gbview.h"
#include	"v/v_graph.h"

#define BACKGROUND_COLOR	COL(0x3ff,0x3ff,0x3ff)
#define BACKGROUND_COLOR_MID	COL(0x200,0x200,0x200)


/* win_flame flags */
#define WFF_FREE		0x00000001
#define WFF_FREE_OUTLIST	0x00000002
#define WFF_SHORT_MH		0x00000004
#define WFF_RUN			0x00000008
#define WFF_ACTIVE		0x00000010
#define WFF_WAIT_BEND		0x00000020
#define WFF_RESIZE		0x00000040
#define WFF_HIDE		0x00000080
#define WFF_BASE		0x00000300
#define WFF_BASE_CURRENT	0x00000100
#define WFF_BASE_LOCK		0x00000200

#define WFF_BASE_OFFSET		8
#define WFF_HIDE_OFFSET		7

#define WFF_DRAW_REQUEST	0x00000400

#define WFF_DIRTY		0x00003800
#define WFF_LUSTER_DIRTY	0x00000800
#define WFF_POLY_DIRTY		0x00001000
#define WFF_PLOT_DIRTY		0x00002000


#define WFF_LUSTER		0x00004000
#define WFF_POLY		0x00008000
#define WFF_PLOT		0x00010000

#define WFF_LS_DIRTY		0x00020000

#define WFF_TO_SMALL		0x00100000
#define WFF_TO_STD		0x00200000

#define WFF_HIDE_TIME_DISABLE	0x00400000

#define WFF_COPY_FLAGS		(WFF_HIDE|WFF_BASE_LOCK)


/* for drawing */

#define WFF_DRAW		0x10000000



/* win_flame modes */
/*
#define RDM_IDLE		0
#define RDM_SPIRAL		1
#define RDM_SPIRAL_COMPLETE	2
#define RDM_RESIZE		3
*/

#define W_E2D_LUSTER		1
#define W_E2D_POLY		0.3
#define W_E2D_PLOT		0.01

#define W_GLOBE_LUSTER		1.2
#define W_GLOBE_POLY		0.3
#define W_GLOBE_PLOT		0.01

typedef struct win_flame_table {
/*
	int			type;
#define WF_E2D			1
#define WF_E2D_PLOT		2

#define WF_GLOBE		4
#define WF_GLOBE_PLOT		5
*/
	short			geo_type;
		/* equal to GT_T_XX in resource.h */
	short			wf_type;
#define WFT_STD			1
#define WFT_PLOT		2
#define WFT_SMALL		3
#define WFT_MAX			4


	int (*f_new)

		(	struct win_flame_table * tbl,
			GBVIEW_FLAME *	gf,
			WF_ID *		ret_wfid,
			REAL1		v_reso,
			RESOURCE * 	draw,
			MAP_HISTORY * 	mh,
			GB_POINT	center,
			REAL1		rotate,
			REAL1		resolution);

	int (*f_move)

		(	GBVIEW_FLAME * gf,
			struct win_flame * wf,
			VPOINT from,
			VPOINT to,
			void * ix);
	int (*f_exit)

		(	GBVIEW_FLAME * gf,
			struct win_flame * wf);

	int (*f_change)

		(	struct win_flame_table * tbl,
			GBVIEW_FLAME * gf,
			struct win_flame * wf);

	int (*f_flame_redraw)

		(	GBVIEW_FLAME * gf,
			struct win_flame * 	wf);

	int (*f_dirty)

		(	GBVIEW_FLAME * gf,
			struct win_flame *	wf,
			GB_RECT *		r,
			int			flags,
			int			mode);

	int (*f_overlay)

		(	GBVIEW_FLAME * 		gf,
			struct win_flame *	wf,
			OV_ARG *		a);

	int (*f_zoom)

		(	GBVIEW_FLAME * gf,
			struct win_flame * 	wf,
			int			w,
			int			h,
			int *			index_x,
			int *			index_y);

	int (*f_resize)

		(	GBVIEW_FLAME * gf,
			struct win_flame *	wf,
			int old_width,
			int old_height);

	int (*f_rotate)

		(	GBVIEW_FLAME * gf,
			struct win_flame *	wf,
			VPOINT *		ix);
	void (*f_get_weight)
		(	GBVIEW_FLAME * gf,
			struct win_flame *	wf);
	void (*f_wf_setup_drawrect)
		(	GBVIEW_FLAME * gf,
			struct win_flame *	wf,
			GB_RECT			r,
			float			rate);
} WIN_FLAME_TABLE;

typedef int (*f_zoom_type)

		(	GBVIEW_FLAME * gf,
			struct win_flame * 	wf,
			int			w,
			int			h,
			int *			index_x,
			int *			index_y);
typedef	int (*f_resize_type)

		(	GBVIEW_FLAME * gf,
			struct win_flame *	wf,
			int,int);

typedef	int (*f_rotate_type)

		(	GBVIEW_FLAME * gf,
			struct win_flame *	wf,
			VPOINT *		ix);



typedef struct wf_lock_list {
	struct wf_lock_list *	next;
	int			tid;
} WF_LOCK_LIST;

typedef struct win_flame {
	struct win_flame *	next;
	WF_ID			id;
	WIN_FLAME_TABLE *	tbl;
	unsigned int		insert_time;

	int			lock;
	WF_LOCK_LIST *		lock_list;
	int			browse;
	int			aboat_count;
	int			flags;
	/* win_flame flags */
	REAL1			v_reso;
	MAP_HISTORY *		mh;
	RESOURCE *		draw;
	unsigned long *		pixels;
	I_RECT			small_rct;
	
	unsigned		small_resize:1;

	/* set_current parameter */

	unsigned int		in_base_time;
	unsigned int		out_base_time;

	/* movement during redraw */
	int			mov_flag;
	int			mov_x;
	int			mov_y;

	/* win_flame modes */

	int			rd_task;
	SYMBOL_INDICATE *	sym_i;

	int			data_request;
	int			dr_interval;
	INTEGER64		dr_time;
#define DR_INTERVAL_MIN 3
	int			pri_adj;
	
	/* button handling */
	
	INTEGER64		hide_time;
} WIN_FLAME;

typedef struct globe_move_t {
	VPOINT *		ix;
	MATRIX3D		rm;
	MATRIX3D		rev_rm;
	double			radius;
} GLOBE_MOVE_T;

int
new_win_flame(
	WF_ID *		ret_wfid,
	GBVIEW_FLAME *	gf,
	REAL1		v_reso,
	RESOURCE * 	draw,
	MAP_HISTORY * 	mh,
	GB_POINT	center,
	REAL1		rotate,
	REAL1		resolution);
int exit_win_flame(GBVIEW_FLAME * gf,WIN_FLAME * wf);
int win_flame_move(GBVIEW_FLAME * Gf,WIN_FLAME * wf,VPOINT from,VPOINT to,void * ix);
int change_win_flame(GBVIEW_FLAME * Gf,WIN_FLAME * wf,int geo_type,int wf_type);
int _change_win_flame(GBVIEW_FLAME * Gf,WIN_FLAME * wf,int geo_type,int wf_type);
int win_flame_redraw(GBVIEW_FLAME * gf,WIN_FLAME * wf);
int _win_flame_dirty(GBVIEW_FLAME * gf,WIN_FLAME * wf,GB_RECT * r,int flags,int mode);
int win_flame_dirty(GBVIEW_FLAME * gf,WF_ID wfid,GB_RECT * r,int flags,int mode);
int win_flame_overlay(GBVIEW_FLAME * gf,WIN_FLAME * wf,OV_ARG * a);
int win_flame_zoom(GBVIEW_FLAME * gf,WIN_FLAME * wf,int w,int h,int * ix_x,int * ix_y);
int win_flame_resize(GBVIEW_FLAME * gf,WIN_FLAME * wf,int old_width,int old_height);
int win_flame_rotate(GBVIEW_FLAME * gf,WIN_FLAME * wf,VPOINT * ix);

WIN_FLAME * _get_wf_ptr(GBVIEW_FLAME * gf,WF_ID id);

/*
extern WIN_FLAME_TABLE * wf_type_list[];
*/
extern WIN_FLAME_TABLE * wf_geo_type_list[GT_T_MAX][WFT_MAX];

RESOURCE * wf_get_mh(GBVIEW_FLAME * gf,WF_ID id,MAP_HISTORY ** mhp);
RESOURCE * _wf_get_mh(GBVIEW_FLAME * gf,WIN_FLAME * wf,MAP_HISTORY ** mhp);

GBVIEW_FLAME * wf_next_gf(GBVIEW_FLAME*,int);
void
_wf_redraw_si(
	GBVIEW_FLAME * gf,
	WIN_FLAME * wf,int ow,int oh,
	int tl_x,int tl_y,int br_x,int br_y);
int wf_set_current(GBVIEW_FLAME * gf);
int wf_set_current_now(GBVIEW_FLAME * gf,WF_ID);
int wf_set_current_target(GBVIEW_FLAME * gf,WF_ID id);

WF_ID wf_get_current(GBVIEW_FLAME * gf);
int wf_check_last(GBVIEW_FLAME * gf,WF_ID id);
void wf_wait_stable(GBVIEW_FLAME * gf);
GBVIEW_FLAME * wf_new_gf();
GBVIEW_FLAME * wf_open();
void wf_close(GBVIEW_FLAME * gf);
int get_next_wfid(GBVIEW_FLAME * gf,int id);
int _get_next_wfid(GBVIEW_FLAME * gf,int id);
int _get_new_wfid(GBVIEW_FLAME *);
void _xx_wakeup_wf(GBVIEW_FLAME * gf,WIN_FLAME * wf,char*,int);
#define _wakeup_wf(gf,wf)	_xx_wakeup_wf(gf,wf,__FILE__,__LINE__)
WIN_FLAME * touch_wf(GBVIEW_FLAME * gf);
int _check_exit_flame(GBVIEW_FLAME * gf);
GBVIEW_FLAME * get_gf_from_sf(XL_SYM_FIELD *);
WIN_FLAME * _get_wf_ptr(GBVIEW_FLAME *,WF_ID);
int _win_lock(GBVIEW_FLAME * gf,WIN_FLAME * wf);
int _win_wlock(GBVIEW_FLAME * gf,WIN_FLAME * wf);
void _win_unlock(GBVIEW_FLAME * gf,WIN_FLAME * wf);
int win_lock(GBVIEW_FLAME * gf,WIN_FLAME * wf);
int win_wlock(GBVIEW_FLAME * gf,WIN_FLAME * wf);
void win_unlock(GBVIEW_FLAME * gf,WIN_FLAME * wf);
void _ex_lock(GBVIEW_FLAME * gf);
void _ex_unlock(GBVIEW_FLAME * gf);
void ex_lock(GBVIEW_FLAME * gf);
void ex_unlock(GBVIEW_FLAME * gf);
unsigned int _wf_insert_time(WIN_FLAME * wf);
unsigned int wf_insert_time(GBVIEW_FLAME * gf,int wfid);
int get_wf_priadj(GBVIEW_FLAME * gf,WF_ID id);
int _get_wf_pri(GBVIEW_FLAME * gf,WIN_FLAME * wf);
void _set_pri_adj(GBVIEW_FLAME * gf,WIN_FLAME * wf,int adj);
void set_pri_adj(GBVIEW_FLAME * gf,int wfid,int adj);
void wf_check_resource(GBVIEW_FLAME * gf);
void xx_wf_wakeup(GBVIEW_FLAME * gf,char*,int);
#define wf_wakeup(gf)	xx_wf_wakeup(gf,__FILE__,__LINE__)
void _wf_flame_redraw(GBVIEW_FLAME * gf);
int _wf_set_current(GBVIEW_FLAME * gf,WIN_FLAME * now,WIN_FLAME * target);
void _wf_set_redraw(GBVIEW_FLAME * gf);
void clear_info(GBVIEW_FLAME * gf);
void insert_redraw_gbr(GBVIEW_FLAME * gf,GB_RECT * r);
int wf_move(GBVIEW_FLAME * gf,VPOINT from,VPOINT to);
int new_rotate_and_center(
	GBVIEW_FLAME * gf,
	GB_POINT from,
	GB_POINT to);
int _wf_purge_select(GBVIEW_FLAME * gf);
unsigned long *
_rotate_plane(
	GBVIEW_FLAME * gf,
	unsigned long * plane,
	VPOINT * index);
void indicate_info_card(GBVIEW_FLAME * gf,RESOURCE * r,OBJ * o);
int wf_purge_select(GBVIEW_FLAME * gf);
void wf_get_coordinate_info(GBVIEW_FLAME * gf,L_CHAR ** name,int * rid,GB_POINT * ptr,int ptr_len);
void _free_to_outlist(GBVIEW_FLAME * gf);

/* table drawing functions */

int
e2d_new(
	WIN_FLAME_TABLE * tbl,
	GBVIEW_FLAME * gf,
	WF_ID *		ret_wfid,
	REAL1		v_reso,
	RESOURCE * 	draw,
	MAP_HISTORY * 	mh,
	GB_POINT	center,
	REAL1		rotate,
	REAL1		resolution);
int e2d_move(	GBVIEW_FLAME * gf,
		struct win_flame * wf,
		VPOINT from,
		VPOINT to,
		void * ix);
int e2d_exit(	GBVIEW_FLAME * gf,
		struct win_flame * wf);
int e2d_change(	struct win_flame_table * tbl,
		GBVIEW_FLAME * gf,
		struct win_flame * wf);
int e2d_redraw(	GBVIEW_FLAME * gf,
		struct win_flame * 	wf);
int e2d_dirty(	GBVIEW_FLAME * gf,
		struct win_flame *	wf,
		GB_RECT *		r,
		int			flags,
		int			mode);
int e2d_overlay(GBVIEW_FLAME * 		gf,
		struct win_flame *	wf,
		OV_ARG *		a);
int e2d_zoom(	GBVIEW_FLAME * gf,
		struct win_flame * 	wf,
		int			w,
		int			h,
		int *			index_x,
		int *			index_y);
int e2d_resize(	GBVIEW_FLAME * gf,
		struct win_flame *	wf,
		int,int);
int e2d_rotate(	GBVIEW_FLAME * gf,
		struct win_flame *	wf,
		VPOINT *		ix);
void
e2d_setup_drawrect(GBVIEW_FLAME * gf,WIN_FLAME * wf,GB_RECT,float rate);

int e2d_p_move(	GBVIEW_FLAME * gf,
		struct win_flame * wf,
		VPOINT from,
		VPOINT to,
		void * ix);
int e2d_p_exit(	GBVIEW_FLAME * gf,
		struct win_flame * wf);
int e2d_p_change(struct win_flame_table * tbl,
		GBVIEW_FLAME * gf,
		struct win_flame * wf);
int e2d_p_redraw(GBVIEW_FLAME * gf,
		struct win_flame * 	wf);
int e2d_p_dirty(GBVIEW_FLAME * gf,
		struct win_flame *	wf,
		GB_RECT *		r,
		int			flags,
		int			mode);

int e2ds_move(	GBVIEW_FLAME * gf,
		struct win_flame * wf,
		VPOINT from,
		VPOINT to,
		void * ix);
int e2ds_exit(	GBVIEW_FLAME * gf,
		struct win_flame * wf);
int e2ds_change(	struct win_flame_table * tbl,
		GBVIEW_FLAME * gf,
		struct win_flame * wf);
int e2ds_redraw(	GBVIEW_FLAME * gf,
		struct win_flame * 	wf);
int e2ds_dirty(	GBVIEW_FLAME * gf,
		struct win_flame *	wf,
		GB_RECT *		r,
		int			flags,
		int			mode);
int e2ds_overlay(GBVIEW_FLAME * 		gf,
		struct win_flame *	wf,
		OV_ARG *		a);
int e2ds_zoom(	GBVIEW_FLAME * gf,
		struct win_flame * 	wf,
		int			w,
		int			h,
		int *			index_x,
		int *			index_y);
int e2ds_resize(	GBVIEW_FLAME * gf,
		struct win_flame *	wf,
		int,int);
int e2ds_rotate(	GBVIEW_FLAME * gf,
		struct win_flame *	wf,
		VPOINT *		ix);
void
e2ds_get_weight(GBVIEW_FLAME * gf,WIN_FLAME * wf);
void
e2ds_setup_drawrect(GBVIEW_FLAME * gf,WIN_FLAME * wf,GB_RECT,float rate);

int e2d_p_move(	GBVIEW_FLAME * gf,
		struct win_flame * wf,
		VPOINT from,
		VPOINT to,
		void * ix);
int e2d_p_exit(	GBVIEW_FLAME * gf,
		struct win_flame * wf);
int e2d_p_change(struct win_flame_table * tbl,
		GBVIEW_FLAME * gf,
		struct win_flame * wf);
int e2d_p_redraw(GBVIEW_FLAME * gf,
		struct win_flame * 	wf);
int e2d_p_dirty(GBVIEW_FLAME * gf,
		struct win_flame *	wf,
		GB_RECT *		r,
		int			flags,
		int			mode);


int globe_move(	GBVIEW_FLAME * gf,
		struct win_flame * wf,
		VPOINT from,
		VPOINT to,
		void * ix);
int
globe_small_move(GBVIEW_FLAME * gf,WIN_FLAME * wf,VPOINT from,VPOINT to,
	void * _t);
int globe_move_plot(GBVIEW_FLAME * gf,
		struct win_flame * wf,
		VPOINT from,
		VPOINT to,
		void * ix);

int _e2d_p_redraw(GBVIEW_FLAME * gf,WIN_FLAME * wf);

void _xx_free_win_flame(GBVIEW_FLAME * gf,WIN_FLAME*wf,char * __file,int __line);
#define _free_win_flame(gf,wf)	_xx_free_win_flame((gf),(wf),__FILE__,__LINE__)
void calc_pitch_ln(GBVIEW_FLAME * gf,int flag);
void calc_pitch_pp(GBVIEW_FLAME * gf,int flag);
void _change_table(GBVIEW_FLAME * gf,int geo_type);
void center_check(GBVIEW_FLAME * gf);
void ch_lock_init(LOCK_D * d);
void _ch_lock(LOCK_D *lock_bit,char * file,int line);
void _ch_unlock(LOCK_D * lock_bit);


void init_load_structure();
void xx_lock_ls_lock(GBVIEW_FLAME * gf,char * file,int line);
#define lock_ls_lock(gf)	xx_lock_ls_lock(gf,__FILE__,__LINE__)
void unlock_ls_lock(GBVIEW_FLAME * gf);
void sleep_ls_lock(GBVIEW_FLAME * gf,int key);
int check_assert(GBVIEW_FLAME * gf,int flags);
int _assert_ls(GBVIEW_FLAME * gf,int * flags_p);
int _load_structure_tick(GBVIEW_FLAME * gf);

void set_test_crd(L_CHAR * res);
int test_crd();
void load_task(TKEY d);
void change_task_gf(GBVIEW_FLAME * gf);
void change_task();

void _insert_ri(GBVIEW_FLAME * gf,WF_ID req,L_CHAR * path,void * data,int w,int h);
void delete_ri(L_CHAR * path);
void * _search_ri_org(int * len,L_CHAR * path);
void * get_data(int * size,XL_SEXP * data);
void * get_from_network(XL_SEXP ** err,int ses,int * size,L_CHAR * path);
void * decompress(XL_SEXP ** err,int * w,int * h,
	void * data,int src_size,
	L_CHAR * path);
int fetch_pri();
void init_win_flame();

void set_weight(GBVIEW_FLAME *,WIN_FLAME * wf);
void wf_free_si(WIN_FLAME * wf);
void wf_free_lock_list(WIN_FLAME * wf);
void wf_move_x(GBVIEW_FLAME * gf,WIN_FLAME * wf,int dx,GB_RECT * r);
void wf_move_y(GBVIEW_FLAME * gf,WIN_FLAME * wf,int dy,GB_RECT * r);
int move_redraw_rect(GBVIEW_FLAME * gf,WIN_FLAME * wf,GB_RECT *r);
void wf_move_si(GBVIEW_FLAME * gf,WIN_FLAME * wf,int dx,int dy);
void copy_pixels(
	GBVIEW_FLAME * gf,
	WIN_FLAME * wf,unsigned long * buf,REAL1 * reso,GB_RECT * r);
int e2d_redraw_rect(
	GBVIEW_FLAME * gf,
	WIN_FLAME * wf,GB_RECT *r,int * pri_cnt);
void regulate_si(WIN_FLAME * wf);
int inc_xy(int * x,int * y);
int _e2d_redraw(GBVIEW_FLAME * gf,WIN_FLAME * wf);
void wf_im_zoom_proc(
	unsigned long *target,
	int w,int h,
	int *index_x,
	int *index_y);

int e2d_p_zoom_etc(
	GBVIEW_FLAME * gf,
	WIN_FLAME * wf,...);

void wf_move_si_globe(GBVIEW_FLAME * gf,WIN_FLAME * wf,GLOBE_MOVE_T *t);

int nwf_assert();

void see_lock_d(char * msg,GBVIEW_FLAME * gf,LOCK_D * d,int * ind);
void _indicate_flame_lock(int * ind);
int _get_new_gfid();
GBVIEW_FLAME * _wf_new_gf();
int _get_env_seq(GBVIEW_FLAME * gf);
void _reset_task_nos(GBVIEW_FLAME * gf);
void insert_redraw_r(GBVIEW_FLAME * gf,VRECT * r);
void insert_vrect(VRECT * v,int x,int y);
void xx_set_redraw_rect(GBVIEW_FLAME * gf,GB_RECT *r,char*__f,int __l);
#define set_redraw_rect(gf,r) xx_set_redraw_rect(gf,r,__FILE__,__LINE__)
void wf_redraw_si(GBVIEW_FLAME * gf,int x,int y,int w,int h);
void wf_reset_active(GBVIEW_FLAME * gf);
void wf_free_nonactive(GBVIEW_FLAME * gf);
WIN_FLAME *_wf_get_current(GBVIEW_FLAME * gf);
void wf_move_redraw_x(GBVIEW_FLAME * gf,int dx);
void wf_move_redraw_y(GBVIEW_FLAME * gf,int dy);
void set_map_xy(GBVIEW_FLAME * gf,int dx,int dy);
int wf_move_xy(GBVIEW_FLAME * gf,VPOINT from,VPOINT to);
int wf_move_globe(GBVIEW_FLAME * gf,VPOINT from,VPOINT to);
void _change_redraw(GBVIEW_FLAME * gf,int ,int);
void _wf_change_size(GBVIEW_FLAME * gf,int old_width,int old_height);
unsigned long select_color(GBVIEW_FLAME * gf,unsigned long a,int x,int y);
int __wf_redraw(GBVIEW_FLAME * gf,GBVIEW_PLANE * p,int x,int y,int w,int h);
void copy_plane(GBVIEW_FLAME * gf,GBVIEW_PLANE * p,unsigned long * plane);
void wf_lock_test(GBVIEW_FLAME * gf,char * str);
void _all_dirty_out(GBVIEW_FLAME * gf);
void all_dirty_out(GBVIEW_FLAME * gf);
REAL1 get_rad(GB_POINT p);
void _wf_select(GBVIEW_FLAME * gf,GBVIEW_PLANE * p,OBJ * obj);
REAL1 get_radian(
	GBVIEW_FLAME * gf,
	GB_POINT from,
	GB_POINT to);
void _ind_pri(GBVIEW_FLAME * gf);
int change_status_rule(int * old_st,int new_st);
void gf_zonbie_tick();
void _wf_st_change(GBVIEW_FLAME * gf,int old_status);
void _wf_click_func(GBVIEW_FLAME * gf);
void wf_click_func(GBVIEW_FLAME * gf);
void wf_free_layer_status(GBVIEW_LAYER_STATUS * ls);
void wf_free_layer_status(GBVIEW_LAYER_STATUS * ls);


void _backup_wf_flags(GBVIEW_FLAME * gf,WIN_FLAME * wf);
void _free_wf_flags(GBVIEW_FLAME * gf);
void _wf_check_resource_wf(GBVIEW_FLAME * gf,WIN_FLAME * wf);
int get_mov_flag(GBVIEW_FLAME * gf,WF_ID wfid);

int wf_get_dirty_mask(int);
int _wf_active_check(WIN_FLAME * wf);
int wf_active_check_1(GBVIEW_FLAME * ,WIN_FLAME * wf);
int wf_active_check_2(GBVIEW_FLAME * ,WF_ID id);
void wf_setup_drawrect(GBVIEW_FLAME* ,WIN_FLAME * wf,GB_RECT r,float rate);
int
copy_small_rect(unsigned long * dest,I_RECT dest_rct,unsigned long * src,I_RECT src_rct);
I_RECT
get_drawrect(GBVIEW_FLAME * gf,GB_RECT r,float rate);
void
wf_check_small(GBVIEW_FLAME * gf,WIN_FLAME * wf);
int wf_get_flags(GBVIEW_FLAME * gf,WF_ID wfid);
unsigned long *
wf_get_resize_data(unsigned long * src,int old_w,int old_h,int w,int h,unsigned long dirty);
GV_RESOURCE_LIST *
search_resource_list(GBVIEW_FLAME * gf,RESOURCE *r,L_CHAR *,int create_flag);
GV_RESOURCE_LIST *
_search_resource_list(GBVIEW_FLAME * gf,RESOURCE *r,L_CHAR * ,int create_flag);

#endif
