/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include "vpf_std.h"
#include "vpf_file.h"
#include "vpf_table.h"
#include "data_quality_table.h"

void data_quality_record_delete(DATA_QUALITY_RECORD *r){
	if(r==NULL)
		return;
	if(r->feature_complete)
		free(r->feature_complete);
	if(r->attrib_complete)
		free(r->attrib_complete);
	if(r->logical_consist)
		free(r->logical_consist);
	if(r->spec_name)
		free(r->spec_name);
	if(r->quant_att_acc)
		free(r->quant_att_acc);
	if(r->qual_att_acc)
		free(r->qual_att_acc);
	if(r->collection_spec)
		free(r->collection_spec);
	if(r->abs_horiz_acc)
		free(r->abs_horiz_acc);
	if(r->abs_vert_acc)
		free(r->abs_vert_acc);
	if(r->rel_horiz_acc)
		free(r->rel_horiz_acc);
	if(r->rel_vert_acc)
		free(r->rel_vert_acc);
	if(r->comments)
		free(r->comments);
	free(r);
}


VPF_RECORD_READER_BEGIN(
	data_quality_record_read, 
	DATA_QUALITY_RECORD)

	VPF_READ_FIELD(id)
	VPF_READ_FIELD(vpf_level)
	VPF_READ_FIELD(vpf_level_name)
	VPF_READ_VARIABLE_TEXT_FIELD(feature_complete)
	VPF_READ_VARIABLE_TEXT_FIELD(attrib_complete)
	VPF_READ_VARIABLE_TEXT_FIELD(logical_consist)
	VPF_READ_FIELD(edition_num)
	VPF_READ_FIELD(creation_date)
	VPF_READ_FIELD(revision_date)
	VPF_READ_FIELD(spec_name)
	VPF_READ_FIELD(spec_date)
	VPF_READ_FIELD(earliest_source)
	VPF_READ_FIELD(latest_source)
	VPF_READ_VARIABLE_TEXT_FIELD(quant_att_acc)
	VPF_READ_VARIABLE_TEXT_FIELD(qual_att_acc)
	VPF_READ_VARIABLE_TEXT_FIELD(collection_spec)
	VPF_READ_FIELD(source_file_name)
	VPF_READ_VARIABLE_TEXT_FIELD(abs_horiz_acc)
	VPF_READ_FIELD(abs_horiz_units)
	VPF_READ_VARIABLE_TEXT_FIELD(abs_vert_acc)
	VPF_READ_FIELD(abs_vert_units)
	VPF_READ_VARIABLE_TEXT_FIELD(rel_horiz_acc)
	VPF_READ_FIELD(rel_horiz_units)
	VPF_READ_VARIABLE_TEXT_FIELD(rel_vert_acc)
	VPF_READ_FIELD(rel_vert_units)
	VPF_READ_VARIABLE_TEXT_FIELD(comments)
VPF_RECORD_READER_END()
