/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include "vpf_std.h"
#include "gm_convert_env.h"

GM_CONVERT_ENV *gm_convert_env_new(const char *library_directory, const char *configure_file)
{
char path[MAX_PATH+1];
	GM_CONVERT_ENV *env;
	
	env = (GM_CONVERT_ENV *)calloc(sizeof(GM_CONVERT_ENV),1);
	
	strcpy(env->library_directory, library_directory);
	
	env->data_quality_table = vpf_table_new(VTT_DATA_QUALITY);
	sprintf(path, "%sdqt", env->library_directory);
	vpf_table_load(env->data_quality_table, path);
	
	env->geographic_reference_table = vpf_table_new(VTT_GEOGRAPHIC_REFERENCE);
	sprintf(path, "%sgrt", env->library_directory);
	vpf_table_load(env->geographic_reference_table, path);
	
	env->coverage_attribute_table = vpf_table_new(VTT_COVERAGE_ATTRIBUTE);
	sprintf(path, "%scat", env->library_directory);
	vpf_table_load(env->coverage_attribute_table, path);
	
	env->tileref_table = vpf_table_new(GMTT_TILEREF_AFT);
	sprintf(path, "%stileref/tileref.aft", env->library_directory);
	vpf_table_load(env->tileref_table, path);
	
	{
		FILE *fp;
		fp = fopen(configure_file, "r");
		if(!fp){
			printf("error; can not load configure file. %s\n", configure_file);
			gm_convert_env_delete(env);
			return NULL;
		}
		else{
			env->color_table = gm_svg_color_table_new(fp);
			fclose(fp);
		}
	}
	
	return env;
}


void gm_convert_env_delete(GM_CONVERT_ENV *env)
{
	vpf_table_delete(env->data_quality_table);
	vpf_table_delete(env->geographic_reference_table);
	vpf_table_delete(env->coverage_attribute_table);
	vpf_table_delete(env->tileref_table);
	gm_svg_color_table_delete(env->color_table);
	free(env);	
}

GM_TILEREF_AFT_RECORD *gm_env_get_tile(GM_CONVERT_ENV *env, LONG tileid)
{
	return vpf_tilelef_get_tile(env->tileref_table, tileid);
}
