/**********************************************************************
 
	Copyright (C) 2005- Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"machine/include.h"
#include	"memory_debug.h"
#include	"pri_level.h"
#include	"lock_level.h"
#include	"utils.h"
#include	"task.h"
#include	"matrix.h"
#include	"xl.h"
#include	"xlerror.h"


XL_SEXP *
xl_mxFinish(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf);
int
get_access(L_CHAR * acc);
int
get_jump_status(L_CHAR * acc);

void
init_mxFinish(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"mxFinish"),
		get_func_prim(xl_mxFinish,FO_APPLICATIVE,0,1,3));
}

int
get_access(L_CHAR * acc)
{
int access;
	if ( acc == 0 )
		return -1;
	if ( l_strcmp(acc,l_string(std_cm,"MI_DEF")) == 0 )
		access = MI_DEF_TP;
	else if ( l_strcmp(acc,l_string(std_cm,"MI_FETCH_1")) == 0 )
		access = MI_FETCH_1_TP;
	else if ( l_strcmp(acc,l_string(std_cm,"MI_FETCH_2")) == 0 )
		access = MI_FETCH_2_TP;
	else if ( l_strcmp(acc,l_string(std_cm,"MI_EDIT_1")) == 0 )
		access = MI_EDIT_1_TP;
	else if ( l_strcmp(acc,l_string(std_cm,"MI_EDIT_2")) == 0 )
		access = MI_EDIT_2_TP;
	else if ( l_strcmp(acc,l_string(std_cm,"MI_VISU_1")) == 0 )
		access = MI_VISU_1_TP;
	else if ( l_strcmp(acc,l_string(std_cm,"MI_VISU_2")) == 0 )
		access = MI_VISU_2_TP;
	else	return -2;
	return access;
}

int
get_jump_status(L_CHAR * acc)
{
int access;
	if ( acc == 0 )
		return -1;
	if ( l_strcmp(acc,l_string(std_cm,"MS_OK")) == 0 )
		access = MS_OK;
	else if ( l_strcmp(acc,l_string(std_cm,"MS_LOADING_ERR_1")) == 0 )
		access = MS_LOADING_ERR_1;
	else if ( l_strcmp(acc,l_string(std_cm,"MS_PROCESS_ERR_1")) == 0 )
		access = MS_PROCESS_ERR_1;
	else if ( l_strcmp(acc,l_string(std_cm,"MS_EDIT_ERR_1")) == 0 )
		access = MS_EDIT_ERR_1;
	else if ( l_strcmp(acc,l_string(std_cm,"MS_EDIT_ERR_2")) == 0 )
		access = MS_EDIT_ERR_2;
	else	return -2;
	return access;
}


XL_SEXP *
xl_mxFinish(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
MATRIX_TOKEN * t;
int err_jump,err_jump_status,normal_jump,normal_jump_status;
L_CHAR * field;
L_CHAR * fdata;

	t = get_env_work(env);
	if ( t == 0 )
		return 0;
	err_jump = get_access(fdata = get_sf_attribute(sf,field = l_string(std_cm,"err-jump")));
	if ( err_jump == -2 )
		goto inv_param;
	normal_jump = get_access(fdata = get_sf_attribute(sf,field = l_string(std_cm,"normal-jump")));
	if ( normal_jump == -2 )
		goto inv_param;
	err_jump_status = get_jump_status(fdata = get_sf_attribute(sf,
				field = l_string(std_cm,"err-jump-status")));
	if ( err_jump_status == -2 )
		goto inv_param;
	normal_jump_status = get_jump_status(fdata = get_sf_attribute(sf,
				field = l_string(std_cm,"normal-jump-status")));
	if ( err_jump_status == -2 )
		goto inv_param;
	set_access_jump(t,err_jump,normal_jump,err_jump_status,normal_jump_status);
	return 0;
/*	
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"mxFinish"),
		0);
*/
inv_param:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"mxFinish"),
		List(n_get_string("invalid parameter in mxFinish"),
			get_string(field),
			get_string(fdata),
			-1));
	/*
matrix_err:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_OBJECT,
		l_string(std_cm,"mxFinish"),
		n_get_string("invalid matrix loading"));
	*/
}





