/**********************************************************************
 
	Copyright (C) 2005- Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef ___MXMAP_H___
#define ___MXMAP_H___

#include	"matrix.h"

typedef struct mxmap_work {
	int			src_dim;
	int			dest_dim;
	INTEGER64 *		pixel_size;
} MXMAP_WORK;

typedef struct mxmap_list {
	AVT_NODE *		tree;
	int			count;
	int			max_dist;
	MATRIX * 		m;
	int			pol;
	int			infinite;
	int			div;
} MXMAP_LIST;

typedef struct mxmap_node {
	struct mxmap_node *	next;
	INTEGER64 *		target;
	double			weight;
} MXMAP_NODE;

void open_mxmap(MATRIX_TOKEN * t);

#define DC_PARAM	(-1)

#define CH_PARAM_DOUBLE	0
#define CH_PARAM_STRING	1
#define CH_SENDBLOCK	8
#define CH_BITMASK	9
#define CH_DELTA	10
#define CH_RESO_RATE	11
#define CH_DATA		12

#endif


