/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef SVG2GB_HASH__
#define SVG2GB_HASH__


typedef int BOOL;

typedef struct gb_hash_element{
	void *value;
	void *key;
}GB_HASH_ELEMENT;

typedef struct gb_hash_chain{
	struct gb_hash_chain *next;
	GB_HASH_ELEMENT data;
}GB_HASH_CHAIN;

typedef struct gb_hash_chain_pool{
	struct gb_hash_chain_pool *next;
	GB_HASH_CHAIN *avail;
	GB_HASH_CHAIN *buff;
}GB_HASH_CHAIN_POOL;

typedef struct gb_hash_table{
	GB_HASH_CHAIN **data;
	int table_size;
	GB_HASH_CHAIN_POOL *pool;
	int pool_block_size;
	int (*hash_func)(void *key);
	BOOL (*key_equals)(void *key_lhs, void *key_rhs);
	BOOL (*value_equals)(void *value_lhs, void *value_rhs);
}GB_HASH_TABLE;


typedef struct gb_multi_result{
	int count;
	int data_buff_count;
	void **data;
}GB_MULTI_RESULT;

GB_HASH_TABLE *gb_make_hash_table(
	int table_size,
	int pool_block_size,
	int (*hash_func)(void *key),
	BOOL (*key_equals)(void *key_lhs, void *key_rhs),
	BOOL (*value_equals)(void *value_lhs, void *value_rhs));

typedef	int (*hash_func_type)(void *key);
typedef	BOOL (*key_equals_type)(void *key_lhs, void *key_rhs);
typedef	BOOL (*value_equals_type)(void *value_lhs, void *value_rhs);


void gb_free_hash_table(GB_HASH_TABLE *tbl);

/* erase data from hash table. if noneed for value mutching, set value NULL*/
void gb_hash_erase(GB_HASH_TABLE *tbl, void *key, void *value);
void gb_hash_insert(GB_HASH_TABLE *tbl, void *key, void *value);
void gb_hash_insert_multi(GB_HASH_TABLE *tbl, void *key, void *value);
void gb_hash_find_multi(GB_MULTI_RESULT *ret, GB_HASH_TABLE *tbl, void *key);
void *gb_hash_find(GB_HASH_TABLE *tbl, void *key);

GB_MULTI_RESULT *gb_make_multi_result();
void gb_free_multi_result(GB_MULTI_RESULT *result);
void gb_reset_multi_result(GB_MULTI_RESULT *result);



#endif

