/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"memory_debug.h"
#include	"xl.h"
#include	"xlerror.h"
#include	"utils.h"

XL_SEXP * xl_SetLocalHostName();

void
init_SetLocalHostName(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"SetLocalHostName"),
		get_func_prim(xl_SetLocalHostName,FO_APPLICATIVE,0,2,2));
}



XL_SEXP *
xl_SetLocalHostName(XLISP_ENV * env,XL_SEXP * s)
{
int ret;
XL_SEXP * n;
	n = get_el(s,1);
	if ( get_type(n) != XLT_STRING )
		goto type_missmatch;
	ret = set_xllisp_site(n->string.data);
	if ( ret < 0 )
		goto data_error;
	return 0;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"SetLocalHostName"),
		n_get_string("type missmatch"));
data_error:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"SetLocalHostName"),
		n_get_string("cannot set"));
}

