/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"xl.h"

XL_SEXP *
car(XL_SEXP * s)
{
	switch ( get_type(s) ) {
	case XLT_ERROR:
		return s;
	case XLT_PAIR:
		return s->pair.car;
	default:
		if ( s == 0 )
			return get_error(
				0,
				0,
				XLE_SEMANTICS_TYPE_MISSMATCH,
				l_string(std_cm,"car"),
				list(	get_string(
					 l_string(std_cm,
						  "type missmatch in parameter")),
					0));
		else	return get_error(
				s->h.file,
				s->h.line,
				XLE_SEMANTICS_TYPE_MISSMATCH,
				l_string(std_cm,"car"),
				list(	get_string(
					 l_string(std_cm,
						  "type missmatch in parameter")),
					0));
	}
}

XL_SEXP *
gb_car(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * ret;
	ret = get_el(s,1);
	switch ( get_type(ret) ) {
	case XLT_ERROR:
		return ret;
	case XLT_PAIR:
		return ret->pair.car;
	default:
		return get_error(
			s->h.file,
			s->h.line,
			XLE_SEMANTICS_TYPE_MISSMATCH,
			l_string(std_cm,"car"),
			list(	get_string(
				 l_string(std_cm,
					  "type missmatch in parameter")),
				0));
	}
}

