/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"Carbon/Carbon.h"
#include	"utils.h"
#include	"memory_debug.h"

#if __MACH__

OSErr GetApplicationFSSpec(FSSpec *spec);
char * get_path_from_mac_fs(FSSpec inMacFSSpec, Boolean isFolder);


OSErr
GetApplicationFSSpec(FSSpec *spec)
{
	OSErr				err;
	Str255				pstr;
	ProcessSerialNumber psn;
	ProcessInfoRec		info;
	
	info.processInfoLength = sizeof( ProcessInfoRec );
	info.processName = pstr;
	info.processAppSpec = spec;
	
	if( (err = MacGetCurrentProcess( &psn )) == noErr ) {
		err = GetProcessInformation( &psn, &info );
	}
	
	return err;
}

char *
get_path_from_mac_fs(FSSpec inMacFSSpec, Boolean isFolder)
{
char	*ret = 0;
FSRef	ref;
int		len;

	if( FSpMakeFSRef(&inMacFSSpec, &ref) == noErr ) {
		ret = (char*)d_alloc(1025);
		if ( FSRefMakePath(&ref, ret, 1024) == noErr ) {
			len = strlen(ret);
			if ( isFolder && ret[len-1] != '/' ) {
				ret[len++] = '/';
				ret[len] = 0;
			}
		}
	}
	return ret;
}

char *
get_path_from_mac_fs_alloc(FSSpec inMacFSSpec, Boolean isFolder)
{
char	*ret = 0;
FSRef	ref;
int		len;

	if( FSpMakeFSRef(&inMacFSSpec, &ref) == noErr ) {
		ret = (char*)malloc(1025);
		if ( FSRefMakePath(&ref, ret, 1024) == noErr ) {
			len = strlen(ret);
			if ( isFolder && ret[len-1] != '/' ) {
				ret[len++] = '/';
				ret[len] = 0;
			}
		}
	}
	return ret;
}


char *
get_peripheral_path()
{
static char * peripheral_path;
char * buf;
FSSpec spec;
	
	if ( peripheral_path )
		return peripheral_path;
	
	if ( noErr != GetApplicationFSSpec(&spec) )
		er_panic("get_peripheral_path");

	if ( noErr != FSMakeFSSpec(spec.vRefNum, 
					spec.parID, "\pperipheral", &spec) ) 
		er_panic("peripheral folder not found");

	buf = get_path_from_mac_fs(spec,true);
	peripheral_path = normalize_delim_str(buf);
	if ( buf != peripheral_path )
		d_f_ree(buf);
	return peripheral_path;
}


#else

char *
get_path_from_mac_fs(FSSpec inMacFSSpec, Boolean isFolder)
{
char *ret, buf[1024], *ptr;
unsigned char * name;

	ptr = buf+sizeof(buf)-1;
	*ptr = 0;
	if ( isFolder ) {
		ptr--;
		*ptr = ':';
	}
	for ( ; ; ) {
		name = inMacFSSpec.name;
		ptr -= name[0]+1;
		if ( ptr < buf )
			er_panic("get_path_from_mac_fs buffer under error");
		memcpy(ptr+1, name+1, name[0]);
		if ( inMacFSSpec.parID != fsRtParID ) {
			*ptr = ':';
		} else {
			ret = d_alloc(buf+sizeof(buf)-ptr-1);
			strcpy(ret,ptr+1);
			return ret;
		}
		if ( noErr != FSMakeFSSpec(inMacFSSpec.vRefNum, 
					inMacFSSpec.parID, "\p", &inMacFSSpec) ) 
			er_panic("get_path_from_mac_fs");
	}
}

char *
get_path_from_mac_fs_alloc(FSSpec inMacFSSpec, Boolean isFolder)
{
char *ret, buf[1024], *ptr;
unsigned char * name;

	ptr = buf+sizeof(buf)-1;
	*ptr = 0;
	if ( isFolder ) {
		ptr--;
		*ptr = ':';
	}
	for ( ; ; ) {
		name = inMacFSSpec.name;
		ptr -= name[0]+1;
		if ( ptr < buf )
			er_panic("get_path_from_mac_fs buffer under error");
		memcpy(ptr+1, name+1, name[0]);
		if ( inMacFSSpec.parID != fsRtParID ) {
			*ptr = ':';
		} else {
			ret = malloc(buf+sizeof(buf)-ptr-1);
			strcpy(ret,ptr+1);
			return ret;
		}
		if ( noErr != FSMakeFSSpec(inMacFSSpec.vRefNum, 
					inMacFSSpec.parID, "\p", &inMacFSSpec) ) 
			er_panic("get_path_from_mac_fs");
	}
}



char *
get_peripheral_path()
{
	return "peripheral/";
}

int
m_mkdir(char *path,...)
{
	char * p;
	for ( p = path ; *p && *p != ':' ; p++ ) {}
	if ( *p == 0 ) // directory delimtier not found
		return -1;
	return mkdir(path,0);
}


#endif /* __MACH__ */



char *
get_preference_path()
{
short vref;
long dirID;
FSSpec spec;
OSErr err;
static char * pref_dir_path;
char * buf;
	if ( pref_dir_path )
		return pref_dir_path;
	if ( err = FindFolder(kUserDomain, kPreferencesFolderType, 
				kCreateFolder, &vref, &dirID) ) {
		if ( err = FindFolder(kOnAppropriateDisk, kPreferencesFolderType, 
					kCreateFolder, &vref, &dirID) ) {
	 		printf("get_preference_path : cannot find the preferences folder [id = %d]\n", err);
			goto error;
		}
	}
	err = FSMakeFSSpec(vref, dirID, "\ppxlconf", &spec);

	switch ( err ) {
	case noErr :
		break;
	case fnfErr :
		if ( err = FSpDirCreate(&spec, smSystemScript, &dirID) ) {
			printf("get_preference_path : cannot create pxlconf folder in the preferences folder [id = %d]\n", err);
			goto error;
		}
		break;
	default : 
		printf("get_preferences_path : unknown error [id = %d]\n", err);
		goto error;
	}
		
	buf = get_path_from_mac_fs(spec,true);
	pref_dir_path = normalize_delim_str(buf);
	if ( buf != pref_dir_path )
		d_f_ree(buf);
	return pref_dir_path;
	
error:
#if __MACH__
	mkdir("pxlconf",0666);
#else
	mkdir(":pxlconf",0666);
#endif
	return pref_dir_path = "pxlconf/";
}



char *
get_homepath()
{
	return u_getenv("HOME");
}

char *
get_root_preference_path()
{
	return "/.pxlconf";
}

char *
get_tmp_dir()
{
char * pf;
static char tmp_dir[200];
	pf = get_preference_path();
	sprintf(tmp_dir,"%stmp",pf);
	return tmp_dir;
}


