/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include "v/VAlignView.h"
#include "machine/v_object.h"

void
VAlignView::destroy_do(VObject * nmp)
{
	nmp->remove_child_do(this);
	v_serialized_exec_sub(gtk_widget_destroy, info);
	v_serialized_exec_sub(g_object_unref, info);
}

VAlignView::~VAlignView()
{
}

VExError
VAlignView::get_status(VObjectStatus *s, int flags) const
{
	V_OP_START_EX
	VExError err = v_get_status_standard(s, &flags, info);
	
	if ( flags & VSF_HOMOGEN ) {
		s->homogeneous = v_serialized_exec_func(gtk_box_get_homogeneous, GTK_BOX(info));
		flags &= ~VSF_HOMOGEN;
	}

	VExError err2 = VObject::get_status(s,flags);
	if ( err2.code )
		err = merge_VExError_vstatus_type(err,err2);
	
	V_OP_END
	return err;
};

VExError
VAlignView::set_status(const VObjectStatus *s, int flags)
{
	V_OP_START_EX
	VExError err = v_set_status_standard(s, flags, info);
	err = VObject::set_status(s,flags);
	if ( err.code ) {
		V_OP_END
		return err;
	}
	
	if ( flags & VSF_HOMOGEN ) {
		v_serialized_exec_sub(gtk_box_set_homogeneous, GTK_BOX(info), s->homogeneous);
		err.subcode1 &= ~VSF_HOMOGEN;
	}
	if ( flags & VSF_SPACING ) {
		bool vert = get_type() == VVAlignView::object_type;
		v_serialized_exec_sub(gtk_box_set_spacing, GTK_BOX(info), !vert ? s->spacing.w : s->spacing.h);
		err.subcode1 &= ~VSF_SPACING;
	}
	
	V_OP_END
		
	if ( flags & (VSF_ALIGN | VSF_PADDING ) ) {
		if ( sts.parent )
			sts.parent->child_status_changed(this, info);
		err.subcode1 &= ~(VSF_ALIGN | VSF_PADDING );
	}
	return err;
}

VExError
VAlignView::add_child_do(VObject* child)
{
	VObjectStatus s;
	VInfo * cinfo = child->get_info_this();
	child->get_status(&s, VSF_ALIGN | VSF_PADDING);
	bool vert = get_type() == VVAlignView::object_type;
	char align = !vert ? s.alignh : s.alignv;
	v_serialized_exec_sub(gtk_box_pack_start,
		GTK_BOX(info), cinfo, 
		align == VALIGN_EXPAND || align == VALIGN_FILL,
		align == VALIGN_FILL, !vert ? s.padding.w : s.padding.h);
	return initial_VExError(V_ER_NO_ERR,0,0);
}

void
VAlignView::remove_child_do(VObject* child)
{
	v_serialized_exec_sub(gtk_container_remove, GTK_CONTAINER(info),
			child->get_info_this());
}

struct v_children_align_list
{
	VInfo *			info;
	unsigned	align : 2;
	short			padding;
	v_children_align_list *	next;
};

void
v_align_view_realign_children(VInfo *info, v_children_align_list *list, int n)
{
	int m = 0;
	while ( list ) {
		gtk_box_set_child_packing(
			GTK_BOX(info), list->info,
			list->align == VALIGN_EXPAND || list->align==VALIGN_FILL,
			list->align == VALIGN_FILL,
			list->padding,
			list->align != VALIGN_RIGHT ? GTK_PACK_START : GTK_PACK_END);
		gtk_box_reorder_child(
			GTK_BOX(info), list->info,
			list->align != VALIGN_RIGHT ? m++ : --n );
		v_children_align_list *next = list->next;
		delete list;
		list = next;
	}
}

VExError
VAlignView::reorder_child(VObject* child, int order)
{
	VObjectList *c, *p = 0, *k;
	int i = 0;
	VExError err = initial_VExError(V_ER_NO_ERR, 0, 0);
	VObject * nmc;
	V_OP_START_EX
		
	for ( c = sts.children ; c && c->object != child ; p = c, c = c->next ) { i++; }
	if ( c == 0 ) {
		err = initial_VExError(V_ER_NOT_FOUND, 0, 0);
		goto end;
	}
	if ( i == order ) {
		goto end;
	}
	p->next = c->next;
	k = c;
	
	i = 0;
	p = 0;
	c = sts.children;
	while ( i++ != order && c ) {
			p = c;
			c = c->next;
	}
	if ( p ) {
		k->next = p->next;
		p->next = k;
	}
	else {
		k->next = sts.children;
		sts.children = k;
	}
	nmc = child->get_nmc(0);
	if ( nmc )
		child_status_changed(child, nmc->get_info_this());
  end:
	V_OP_END
	return err;
}

void
VAlignView::child_status_changed(VObject *child, VInfo* cinfo)
{
	VObjectStatus s;
	VObject * nmc;
	v_children_align_list *t, *list = 0, *last = 0;
	int m = 0;
	for ( VObjectList *child = sts.children ; 
				child ; child = child->next ) {
		nmc = child->object->get_nmc(0);
		if ( nmc == 0 )
			continue;
		child->object->get_status(&s, VSF_ALIGN | VSF_PADDING);
		bool vert = get_type() == VVAlignView::object_type;
		t = new v_children_align_list;
		t->info = nmc->get_info_this();
		t->align = !vert ? s.alignh : s.alignv;
		t->padding = !vert ? s.padding.w : s.padding.h;
		t->next = 0;
		if ( list == 0 )
			list = t;
		if ( last )
			last->next = t;
		last = t;
		m++;
	}
	v_serialized_exec_sub(v_align_view_realign_children, info, list, m);
}

void
VAlignView::redraw(VRect *rect) const
{
	// do nothing
}



VExError
VHAlignView::create_do(const VObjectStatus* s, int flags,
		VObject * nmp, void * arg)
{
	info = v_serialized_exec_func(gtk_hbox_new, 0,V_DEFAULT_SPACING);
	v_serialized_exec_sub(g_object_ref, info);

	return return_create_do(this,nmp,&sts,s,flags);
}


VExError
VVAlignView::create_do(const VObjectStatus* s, int flags,
		VObject * nmp, void * arg)
{
	info = v_serialized_exec_func(gtk_vbox_new,0,V_DEFAULT_SPACING);
	v_serialized_exec_sub(g_object_ref, info);

	return return_create_do(this,nmp,&sts,s,flags);
}
