
/**********************************************************************
 
	Copyright (C) 2007- Hirohisa MORI <joshua@globalbase.org>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	<math.h>
#include	"memory_debug.h"
#include	"utils.h"
#include	"xlerror.h"
#include	"xl.h"
#include	"mx_format.h"
#include	"geo.h"
#include	"progressive.h"

/*
([gmxImportUTM id="mtx-id" utmid="utm-id" ch="mtx-channel" utmch="utm-channel"]
	offset-x offset-y x-reso y-reso 
	UTM-no
	utm-offset
	UTM-minrect
	UTM-reso
	eripsold-a
	eripsoid-b
	)
id : integer : destination bl mtx file id
utmid : integer : source utm mtx file id
ch : integer : destination bl mtx data channel id
utmch : integer : source utm mtx data channel id
	if not described, utmch = ch
zwidth : floating/integer : define zone width
	default zwidth=6;

offset-x : floating/integer : ido minimum point
offset-y : floating/integer : keido minimum point
x-reso : floating/integer : ido resolution
y-reso : floating/integer : keido resolution
UTM-no : integer/string : Zone No.
		plus integer North Zone
		minus integer South Zone
		string "xxN" North Zone
		string "xxS" South Zone
utm-offset : GB point format : zone offset point
UTM-minrect : GB minrect format : .crd file minrect 
UTM-reso : GB point format : .lst scan resolution
eripsoid-a/b : floating : eripsoid radius

*/


typedef struct utm_data {
	double		offset_x;
	double		offset_y;
	double		reso_x;
	double		reso_y;
	int		UTMno;

	ELIPSOID	ep;

	double utm_end_north;
	double utm_st_south;
	double utm_st_west[2];
	double utm_end_east[2];
	MX_ENTRY *	m_bl;
	int		bl_channel;
	
	MX_ENTRY *	m_utm;
	int		utm_channel;
	double		zone_offset_x;
	double		zone_offset_y;
	GB_RECT		zone_minrect;
	double		zone_reso_x;
	double		zone_reso_y;
	double		zone_width;

	unsigned	XY_dir:1;
} UTM_DATA;

XL_SEXP * gb_gmxImportUTM();

void
init_gmxImportUTM(XLISP_ENV * env0,XLISP_ENV * env1)
{
	set_env(env1,l_string(std_cm,"gmxImportUTM"),
		get_func_prim(gb_gmxImportUTM,FO_APPLICATIVE,0,11,11));
}

void
boundary_setup(INTEGER64 * tile,MATRIX * m,int dim)
{
INTEGER64 mask;
	if ( tile[dim+1] < 0 )
		tile[dim+1] = 0;
	else if ( tile[dim+1] >= m->pixel_size[dim] ) {
		mask = (((INTEGER64)1)<<(m->block_size[dim]));
		if ( m->pixel_size[dim] & (mask-1) ) {
			tile[dim+1] = m->pixel_size[dim] & (-mask);
			tile[dim+1] += mask;
		}
		else tile[dim+1] = m->pixel_size[dim];
	}
	tile[0] = 0;
}

double
zone_lambda_adjust(double lambda,double center)
{
double d;
	d = lambda - center;
	if ( d < 0 )
		d = -d;
	if ( d < 90 )
		return lambda;
	return lambda - 360;
}

int
check_in_zone(INTEGER64 * ix,int bx,int by,UTM_DATA * ud,int zone)
{
#define TOP_LEFT	0
#define TOP_RIGHT	1
#define BOT_LEFT	2
#define BOT_RIGHT	3
#define BOT_CENTER	4
#define TOP_CENTER	5

INTEGER64 point[6][2];
int i,target;
double X[6];
double Y[6];

double phi[6],lambda[6];
GB_RECT target_rect;
GB_POINT ptr;

	point[TOP_LEFT][0] = ix[1];
	point[TOP_LEFT][1] = ix[2]+by;
	point[TOP_RIGHT][0] = ix[1]+bx;
	point[TOP_RIGHT][1] = ix[2]+by;
	point[BOT_LEFT][0] = ix[1];
	point[BOT_LEFT][1] = ix[2];
	point[BOT_RIGHT][0] = ix[1]+bx;
	point[BOT_RIGHT][1] = ix[2];
	target = 4;

	for ( i = 0 ; i < 4 ; i ++ ) {
		phi[i] = point[i][1] / ud->reso_y + ud->offset_y;
		lambda[i] = point[i][0] / ud->reso_x + ud->offset_x;
		lambda[i] = zone_lambda_adjust(lambda[i],ud->utm_st_west[zone]+ud->zone_width/2);
	}
	if ( lambda[TOP_LEFT] < ud->utm_st_west[zone]+ud->zone_width/2 &&
		ud->utm_st_west[zone]+ud->zone_width/2 < lambda[TOP_RIGHT] ) {
		
		lambda[BOT_CENTER] = lambda[TOP_CENTER] = ud->utm_st_west[zone]+ud->zone_width/2;
		phi[BOT_CENTER] = phi[BOT_LEFT];
		phi[TOP_CENTER] = phi[TOP_LEFT];
		target = 6;
	}
	
	target_rect.tl.x = target_rect.tl.y = 0;
	target_rect.br.x = target_rect.br.y = 0;
	for ( i = 0 ; i < target ; i ++ ) {
		utm2bl(&X[i],&Y[i],lambda[i]*2*M_PI/360,phi[i]*2*M_PI/360,&ud->ep);
		ptr.x = X[i];
		ptr.y = Y[i];
		insert_rect(&target_rect,ptr);
	}
	if ( cross_rect_rect(&target_rect,&ud->zone_minrect) )
		return 0;
	return -1;
}

XL_SEXP *
load_zone(INTEGER64 * start,INTEGER64 * end,UTM_DATA * ud,int zone,XL_SEXP * s,char * part_msg)
{
char * flags;
double _phi;
double _lambda;
double _X_,_Y;
INTEGER64 *XY;
int * pixels;
int * pixels_target;
int * pixels_src;
int bx,by;
int x,y;
int i,j;
INTEGER64 ix[3];
INTEGER64 mask[2];
int ofs_x,ofs_y;
INTEGER64 masked[2];
MX_CACHE_PARAM p_utm;
int ds_pos,ds_from;
int target_x,target_y;
int index_src,index_dest;
/*
int	m_utm_gn_tree_node,
	m_utm_gn_create,
	m_utm_gn_wait,
	m_bl_gn_tree_node,
	m_bl_gn_create,
	m_bl_gn_wait;
*/
INTEGER64 tim;
int index_l,index_x,index_y;
char * flags_p;
INTEGER64 * XY_p;
int bxby;
int prog_id,stage_id;
INTEGER64 total;
char message[50];

XL_SEXP * ret;
INTEGER64 total_size;

ss_printf("load_zone-1\n");
ss_printf("TARGET START %s\n",pt_dc(ud->m_utm->c.m,start,PTDC_PIXEL_1));
ss_printf("TARGET END %s\n",pt_dc(ud->m_utm->c.m,end,PTDC_PIXEL_1));
	if ( start[1] == end[1] )
		return 0;
	if ( start[2] == end[2] )
		return 0;
ss_printf("load_zone-2\n");

	bx = ((int)1)<<ud->m_bl->c.m->block_size[0];
	by = ((int)1)<<ud->m_bl->c.m->block_size[1];
	bxby = bx*by;
	mask[0] = -(INTEGER64)bx;
	mask[1] = -(INTEGER64)by;
	flags = d_alloc(bx*by);
	XY = d_alloc(sizeof(*XY)*bx*by*3);
	pixels = d_alloc(sizeof(*pixels)*bx*by);

	/* Setup Zone */
	ud->ep.org_lambda = (ud->utm_st_west[0]+ud->zone_width/2)*2*M_PI/360;
	ud->ep.org_X_enable = 1;
	ud->ep.org_X = 0;
	if ( ud->UTMno >= 0 )
		ud->ep.org_X0 = 0;
	else	ud->ep.org_X0 = 10000000;
	ud->ep.org_Y0 = 500000;

/*	
	m_utm_gn_tree_node = ud->m_utm->c.gn_tree_node;
	m_utm_gn_create = ud->m_utm->c.gn_create;
	m_utm_gn_wait = ud->m_utm->c.gn_wait;

	ud->m_utm->c.gn_tree_node = GN_NODE;
	ud->m_utm->c.gn_create = GN_READ_ONLY;
	ud->m_utm->c.gn_wait = GN_ERROR_NORETRY;
*/
	push_gn(&ud->m_utm->c,
		GN_NODE,
		GN_READ_ONLY,
		GN_ERROR_NORETRY);

	set_matrix_env(ud->m_utm->c.m,"create-node","disable");
	
	p_utm = ud->m_utm->p;
	p_utm.ofs = 0;
	p_utm.data_ptrs[0] = 0;
	p_utm.data_ptrs[1] = 0;
	p_utm.data_ptrs[2] = 0;
	p_utm.data_ptrs[3] = 0;
	p_utm.data_ix = d_alloc(sizeof(MX_CACHE_PARAM_IX)*ud->m_utm->c.m->p.channel_nos);
	for ( i = 0 ; i < ud->m_utm->c.ds_len ; i ++ ) {
		if ( ud->m_utm->c.access_ch[i] == ud->utm_channel ) {
			p_utm.data_ix[i].x = 0;
			p_utm.data_ix[i].p = 2;
			ds_from = i;
		}
		else {
			p_utm.data_ix[i].x = MXC_INVALID;
			p_utm.data_ix[i].p = 0;
		}
	}
	
/*
	m_bl_gn_tree_node = ud->m_bl->c.gn_tree_node;
	m_bl_gn_create = ud->m_bl->c.gn_create;
	m_bl_gn_wait = ud->m_bl->c.gn_wait;
*/

	for ( i = 0 ; i < ud->m_bl->c.ds_len ; i ++ )
		if ( ud->m_bl->c.access_ch[i] == ud->bl_channel )
			ds_pos = i;

/*
	ud->m_bl->c.gn_tree_node = GN_TREE;
	ud->m_bl->c.gn_create = GN_LIST_CREATE;
	ud->m_bl->c.gn_wait = GN_LIST_CREATE;
*/
	push_gn(&ud->m_bl->c,
		GN_TREE,
		GN_LIST_CREATE,
		GN_LIST_CREATE);
		

	set_matrix_env(ud->m_utm->c.m,"create-node","enable");

//print_elipsoid(&ud->ep);
ss_printf("load_zone-3\n");
	ix[0] = 0;
	ret = 0;
	
	total_size = (end[2]-start[2])*(end[1]-start[1]);

	if ( total_size ) {
		prog_id = new_progressive(l_string(std_cm,"ImportUTM"),
					  l_string(std_cm,".progressive"),0);

		if ( ud->UTMno >= 0 )
			sprintf(message,"UTM%iN %s",ud->UTMno,part_msg);
		else	sprintf(message,"UTM%iS %s",-ud->UTMno,part_msg);
		stage_id = new_stage(prog_id,l_string(std_cm,message),-1,0);

		next_stage(prog_id,stage_id,total_size,0);

	}

	total = 0;

	for ( ix[2] = start[2] ; ix[2] < end[2] ; ix[2] += by ) {
		for ( ix[1] = start[1] ; ix[1] < end[1] ; ix[1] += bx , total += bx*by) {
if ( tim != get_xltime() ) {
ss_printf("TARGET %s < %s %f\n",pt_dc(ud->m_utm->c.m,ix,PTDC_PIXEL_1),
	  pt_dc(ud->m_utm->c.m,end,PTDC_PIXEL_1),
	(ix[2]-start[2])/(double)(end[2]-start[2])*100);
tim = get_xltime();
}

			if ( total_size )
				set_stage(prog_id,0,total,0);

			ret = xli_break_check(s,10);
			if ( get_type(ret) == XLT_ERROR )
				break;
			if ( check_in_zone(ix,bx,by,ud,zone) < 0 )
				continue;
			flags_p = flags;
			XY_p = XY;
			for ( y = 0 ; y < by ; y ++ ) {
				_phi = (y+ix[2])/ud->reso_y + ud->offset_y;
				for ( x = 0 ; x < bx ; x ++ ) {
					_lambda = (x+ix[1])/ud->reso_x + ud->offset_x;
//ss_printf("LAMBDA %f %f %f\n",_lambda,ud->utm_st_west[zone],ud->utm_end_east[zone]);
					if ( _lambda < ud->utm_st_west[zone] ) {
//						flags[x + y*bx] = -1;
						*flags_p++ = -1;
						XY_p += 3;
						continue;
					}
					if ( _lambda >= ud->utm_end_east[zone] ) {
//						flags[x + y*bx] = -1;
						*flags_p++ = -1;
						XY_p += 3;
						continue;
					}
//					flags[x + y*bx] = 0;
					*flags_p ++ = 0;
					_lambda = zone_lambda_adjust(_lambda,ud->utm_st_west[zone]+ud->zone_width/2);
					utm2bl(&_X_,&_Y,_lambda*2*M_PI/360,_phi*2*M_PI/360,&ud->ep);
/*
ss_printf("=== %f %f (%i :: %f %f :: %f %f)=> ",_X_,_Y,ud->XY_dir,
ud->zone_offset_x,ud->zone_offset_y,ud->zone_reso_x,ud->zone_reso_y);
*/
					if ( ud->XY_dir ) {
						_X_ = (_X_ - ud->zone_offset_x)*ud->zone_reso_x;
						_Y = (_Y - ud->zone_offset_y)*ud->zone_reso_y;
					}
					else {
					double __X;
						__X = (_Y - ud->zone_offset_y)*ud->zone_reso_x;
						_Y = (_X_ - ud->zone_offset_x)*ud->zone_reso_y;
						_X_ = __X;
					}
//ss_printf("%f %f\n",_X_,_Y);


/*
					XY[x + bx*y] = 0;
					XY[(x + bx*y)*3+1] = rint(_X_);
					XY[(x + bx*y)*3+2] = rint(_Y);
*/
					*XY_p++ = 0;
					*XY_p++ = rint(_X_);
					*XY_p++ = rint(_Y);
				}
			}
			for ( i = 0 ; i < bxby ; i ++ ) {
				if ( flags[i] )
					continue;
				index_l = 3*i;
				index_x = index_l+1;
				index_y = index_l+2;
				if ( XY[index_x] < 0 ) {
					flags[i] = -1;
					continue;
				}
				if ( XY[index_y] < 0 ) {
					flags[i] = -1;
					continue;
				}
//ss_printf("XX %lli %lli %lli\n",XY[index_l],XY[index_x],XY[index_y]);
				p_utm.dc = &XY[index_l];
				p_utm.data_ptrs[2] = &pixels[i];
				if ( read_mx_cache(&p_utm) < 0 ) {
					flags[i] = -1;
					masked[0] = XY[index_x] & mask[0];
					masked[1] = XY[index_y] & mask[1];
					for ( j = i+1 ; j < bx*by ; j ++ ) {
						if ( flags[j] )
							continue;
						if ( ((XY[3*j+1] & mask[0]) == masked[0]) &&
							((XY[3*j+2] & mask[1]) == masked[1]) )
							flags[j] = -1;
					}
				}
				else {
					flags[i] = 1;
					masked[0] = XY[index_x] & mask[0];
					masked[1] = XY[index_y] & mask[1];
					pixels_target = p_utm.c->ds[ds_from].offset;
					target_x = p_utm.c->ds[ds_from].ix[0];
					target_y = p_utm.c->ds[ds_from].ix[1];
					for ( j = i+1 ; j < bxby ; j ++ ) {
						if ( flags[j] )
							continue;
						if ( ((XY[3*j+1] & mask[0]) == masked[0]) &&
							((XY[3*j+2] & mask[1]) == masked[1]) ) {
							ofs_x = XY[3*j+1] &(bx-1);
							ofs_y = XY[3*j+2] &(by-1);
							if ( target_x <= ofs_x ) {
								flags[j] = -1;
								continue;
							}
							if ( target_y <= ofs_y ) {
								flags[j] = -1;
								continue;
							}
							flags[j] = 1;
							pixels[j] = 
								pixels_target[ofs_x + ofs_y*target_x];
						}
					}
				}
			}
			for ( i = 0 ; i < bxby ; i ++ )
				if ( flags[i] > 0 )
					goto ok;
			continue;
		ok:
//ss_printf("OK\n");
			if ( get_mx_cache(&ud->m_bl->c,ix) < 0 )
				continue;
			pixels_target = ud->m_bl->c.ds[ds_pos].offset;
			if ( ud->m_bl->c.ds[ds_pos].ix[0] == bx && ud->m_bl->c.ds[ds_pos].ix[1] == by ) {
				pixels_src = pixels;
				for ( i = 0 ; i < bxby ; i ++ , pixels_target ++ , pixels_src ++ ) {
					if ( flags[i] < 0 )
						continue;
					*pixels_target = *pixels_src;
//ss_printf("=== COLOR-2 %x %i\n",*pixels_target,flags[i]);
				}
			}
			else {
				target_x = ud->m_bl->c.ds[ds_pos].ix[0];
				target_y = ud->m_bl->c.ds[ds_pos].ix[1];
				for ( y = 0 ; y < target_y ; y ++ ) {
					for ( x = 0 ; x < target_x ; x ++ ) {
						index_src = x + y*bx;
						if ( flags[index_src] < 0 )
							continue;
						index_dest = x + y*target_x;
						pixels_target[index_dest] = pixels[index_src];
//ss_printf("=== COLOR-1 %x %i\n",pixels_target[index_dest],flags[index_src]);
					}
				}
			}
//ss_printf("=== COLOR %x %i\n",pixels_target[0],flags[0]);
			ud->m_bl->c.dirty = NF_DIRTY;
		}
	}
	
	if ( total_size ) {
		next_stage(prog_id,0,0,0);
		close_progressive(prog_id,0);
	}
/*
	ud->m_bl->c.gn_tree_node = m_bl_gn_tree_node;
	ud->m_bl->c.gn_create = m_bl_gn_create;
	ud->m_bl->c.gn_wait = m_bl_gn_wait;

	ud->m_utm->c.gn_tree_node = m_utm_gn_tree_node;
	ud->m_utm->c.gn_create = m_utm_gn_create;
	ud->m_utm->c.gn_wait = m_utm_gn_wait;
*/
	pop_gn(&ud->m_bl->c);
	pop_gn(&ud->m_utm->c);

	flush_mx_cache(&ud->m_bl->c,0);
	flush_mx_cache(&ud->m_utm->c,0);

	d_f_ree(flags);
	d_f_ree(XY);
	d_f_ree(pixels);
	d_f_ree(p_utm.data_ix);
	
	return ret;
}

XL_SEXP * 
import_UTM(UTM_DATA * ud,XL_SEXP * s)
{
INTEGER64 z1_start_tile[3];
INTEGER64 z1_end_tile[3];
INTEGER64 z2_start_tile[3];
INTEGER64 z2_end_tile[3];
int UTMno;
MATRIX * m_bl;
double center;
XL_SEXP * ret;

ss_printf("IMPORT UTM zw=%f\n",ud->zone_width);
	if ( ud->UTMno > 0 ) {
		ud->utm_end_north = 90;
		ud->utm_st_south = 0;
		UTMno = ud->UTMno;
	}
	else {
		ud->utm_end_north = 0;
		ud->utm_st_south = -90;
		UTMno = - ud->UTMno;
	}
	center = -180 + (UTMno-1)*6+3;
	ud->utm_end_east[0] = center + ud->zone_width/2;
	ud->utm_st_west[0] = center - ud->zone_width/2;
	ud->utm_st_west[1] = ud->utm_st_west[0] + 360;
	ud->utm_end_east[1] = ud->utm_end_east[0] + 360;

	m_bl = ud->m_bl->c.m;

	z1_start_tile[0] = 0;
	z1_start_tile[1] = (ud->utm_st_west[0] - ud->offset_x)*ud->reso_x;
	z1_start_tile[2] = (ud->utm_st_south - ud->offset_y)*ud->reso_y;
	z1_start_tile[1] &= -(((INTEGER64)1)<<m_bl->block_size[0]);
	z1_start_tile[2] &= -(((INTEGER64)1)<<m_bl->block_size[1]);

	z1_end_tile[0] = 0;
	z1_end_tile[1] = (ud->utm_end_east[0] - ud->offset_x)*ud->reso_x;
	z1_end_tile[2] = (ud->utm_end_north - ud->offset_y)*ud->reso_y;
	if ( z1_end_tile[1] & ((((INTEGER64)1)<<m_bl->block_size[0])-1) ) {
		z1_end_tile[1] &= -(((INTEGER64)1)<<m_bl->block_size[0]);
		z1_end_tile[1] += (((INTEGER64)1)<<m_bl->block_size[0]);
	}
	if ( z1_end_tile[2] & ((((INTEGER64)1)<<m_bl->block_size[1])-1) ) {
		z1_end_tile[2] &= -(((INTEGER64)1)<<m_bl->block_size[1]);
		z1_end_tile[2] += (((INTEGER64)1)<<m_bl->block_size[1]);
	}
ss_printf("z1_start_tile %s\n",pt_dc(ud->m_utm->c.m,z1_start_tile,PTDC_PIXEL_1));
ss_printf("z1_end_tile %s\n",pt_dc(ud->m_utm->c.m,z1_end_tile,PTDC_PIXEL_1));
	
	boundary_setup(z1_start_tile,m_bl,0);
	boundary_setup(z1_start_tile,m_bl,1);
	boundary_setup(z1_end_tile,m_bl,0);
	boundary_setup(z1_end_tile,m_bl,1);
	
	z2_start_tile[0] = 0;
	z2_start_tile[1] = (ud->utm_st_west[1] - ud->offset_x)*ud->reso_x;
	z2_start_tile[2] = (ud->utm_st_south - ud->offset_y)*ud->reso_y;
	z2_start_tile[1] &= -(((INTEGER64)1)<<m_bl->block_size[0]);
	z2_start_tile[2] &= -(((INTEGER64)1)<<m_bl->block_size[1]);

	z2_end_tile[0] = 0;
	z2_end_tile[1] = (ud->utm_end_east[1] - ud->offset_x)*ud->reso_x;
	z2_end_tile[2] = (ud->utm_end_north - ud->offset_y)*ud->reso_y;
	if ( z2_end_tile[1] & ((((INTEGER64)1)<<m_bl->block_size[0])-1) ) {
		z2_end_tile[1] &= -(((INTEGER64)1)<<m_bl->block_size[0]);
		z2_end_tile[1] += (((INTEGER64)1)<<m_bl->block_size[0]);
	}
	if ( z2_end_tile[2] & ((((INTEGER64)1)<<m_bl->block_size[1])-1) ) {
		z2_end_tile[2] &= -(((INTEGER64)1)<<m_bl->block_size[1]);
		z2_end_tile[2] += (((INTEGER64)1)<<m_bl->block_size[1]);
	}

	boundary_setup(z2_start_tile,m_bl,0);
	boundary_setup(z2_start_tile,m_bl,1);
	boundary_setup(z2_end_tile,m_bl,0);
	boundary_setup(z2_end_tile,m_bl,1);
	
	ret = load_zone(z1_start_tile,z1_end_tile,ud,0,s,"1st part");
	if ( get_type(ret) == XLT_ERROR )
		return ret;
	return load_zone(z2_start_tile,z2_end_tile,ud,1,s,"2nd part");
}


XL_SEXP *
gb_gmxImportUTM(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
MX_ENTRY * mx_e;
L_CHAR * id;
XL_SEXP * data;
UTM_DATA ud;
L_CHAR * sn,*sn1,*sn2;
int sign;
GB_POINT ptr;
char * err_msg;

	err_msg = "id";
	id = get_sf_attribute(sf,l_string(std_cm,"id"));
	if ( id == 0 )
		goto inv_param;
	mx_e = search_mx_entry_by_id(atoi(n_string(std_cm,id)));
	if ( mx_e == 0 )
		goto inv_param;
	ud.m_bl = mx_e;

	err_msg = "utmid";
	id = get_sf_attribute(sf,l_string(std_cm,"utmid"));
	if ( id == 0 )
		goto inv_param;
	mx_e = search_mx_entry_by_id(atoi(n_string(std_cm,id)));
	if ( mx_e == 0 )
		goto inv_param;
	ud.m_utm = mx_e;

	err_msg = "ch";
	id = get_sf_attribute(sf,l_string(std_cm,"ch"));
	if ( id == 0 )
		goto inv_param;
	ud.bl_channel = atoi(n_string(std_cm,id));
	
	err_msg = "utmch";
	id = get_sf_attribute(sf,l_string(std_cm,"utmch"));
	if ( id == 0 )
		ud.utm_channel = ud.bl_channel;
	else	ud.utm_channel = atoi(n_string(std_cm,id));

	err_msg = "zwidth";
	id = get_sf_attribute(sf,l_string(std_cm,"zwidth"));
	if ( id == 0 )
		ud.zone_width = 6;
	else	sscanf(n_string(std_cm,id),"%lf",&ud.zone_width);

	err_msg = "XYdir";
	id = get_sf_attribute(sf,l_string(std_cm,"XYdir"));
	if ( id == 0 )
		ud.XY_dir = 1;
	else if ( l_strcmp(id,l_string(std_cm,"forward")) == 0 )
		ud.XY_dir = 1;
	else	ud.XY_dir = 0;

	data = get_el(s,1);
	switch ( get_type(data) ) {
	case XLT_INTEGER:
		ud.offset_x = data->integer.data;
		break;
	case XLT_FLOAT:
		ud.offset_x = data->floating.data;
		break;
	default:
		err_msg = "offset_x(Arg 1)";
		goto type_missmatch;
	}

	data = get_el(s,2);
	switch ( get_type(data) ) {
	case XLT_INTEGER:
		ud.offset_y = data->integer.data;
		break;
	case XLT_FLOAT:
		ud.offset_y = data->floating.data;
		break;
	default:
		err_msg = "offset_y(Arg 2)";
		goto type_missmatch;
	}

	data = get_el(s,3);
	switch ( get_type(data) ) {
	case XLT_INTEGER:
		ud.reso_x = data->integer.data;
		break;
	case XLT_FLOAT:
		ud.reso_x = data->floating.data;
		break;
	default:
		err_msg = "reso_x(Arg 3)";
		goto type_missmatch;
	}

	data = get_el(s,4);
	switch ( get_type(data) ) {
	case XLT_INTEGER:
		ud.reso_y = data->integer.data;
		break;
	case XLT_FLOAT:
		ud.reso_y = data->floating.data;
		break;
	default:
		err_msg = "reso_y(Arg 4)";
		goto type_missmatch;
	}

	data = get_el(s,5);
	switch ( get_type(data) ) {
	case XLT_INTEGER:
		ud.UTMno = data->integer.data;
		break;
	case XLT_STRING:
		sn = ll_copy_str(data->string.data);
		sn1 = sn2 = sn;
		sign = 1;
		for ( ; *sn1 ; sn1 ++ ) {
			switch ( *sn1 ) {
			case 'N':
			case 'n':
				*sn1 = 0;
				break;
			case 'S':
			case 's':
				*sn1 = 0;
				sign = -1;
				break;
			default:
				continue;
			}
			break;
		}
		for ( ; *sn2 =='0' ; sn2 ++ );
		sscanf(n_string(std_cm,sn2),"%i",&ud.UTMno);
		ud.UTMno *= sign;
		d_f_ree(sn);
		break;
	default:
		err_msg = "UTMno(Arg 5)";
		goto type_missmatch;
	}
	
	err_msg = "zone_offset_x/y(Arg 6)";
	data = get_el(s,6);
	if ( xl_to_gb_point(&ptr,data) < 0 )
		goto inv_param;
	ud.zone_offset_x = ptr.x;
	ud.zone_offset_y = ptr.y;

	err_msg = "zone_rezo_mirect(Arg 7)";
	data = get_el(s,7);
	if ( xl_to_gb_rect(&ud.zone_minrect,data) < 0 )
		goto inv_param;

	err_msg = "zone_rezo_x/y(Arg 8)";
	data = get_el(s,8);
	if ( xl_to_gb_point(&ptr,data) < 0 )
		goto inv_param;
	ud.zone_reso_x = ptr.x;
	ud.zone_reso_y = ptr.y;

	data = get_el(s,9);
	switch ( get_type(data) ) {
	case XLT_INTEGER:
		ud.ep.a = data->integer.data;
		break;
	case XLT_FLOAT:
		ud.ep.a = data->floating.data;
		break;
	default:
		err_msg = "alipsoid-a(Arg 9)";
		goto type_missmatch;
	}

	data = get_el(s,10);
	switch ( get_type(data) ) {
	case XLT_INTEGER:
		ud.ep.b = data->integer.data;
		break;
	case XLT_FLOAT:
		ud.ep.b = data->floating.data;
		break;
	default:
		err_msg = "alipsoid-b(Arg 10)";
		goto type_missmatch;
	}

	ud.ep.m0 = SCALE_CONSTANT;

	return import_UTM(&ud,s);

type_missmatch:
	flush_mx_cache(&mx_e->c,0);
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"gmxImportUTM"),
		List(n_get_string("type missmatch"),n_get_string(err_msg),-1));
/*
cannot_open:
	flush_mx_cache(&mx_e->c,0);
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_OPEN_FILE,
		l_string(std_cm,"gmxImportUTM"),
		List(n_get_string("cannot open the file"),
			filename,
			-1));
*/
inv_param:
	flush_mx_cache(&mx_e->c,0);
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"gmxImportUTM"),
		List(n_get_string("invalida parameter"),
			n_get_string(err_msg),
			-1));
/*
permission_error:
	flush_mx_cache(&mx_e->c,0);
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_PERMISSION_DENIED,
		l_string(std_cm,"gmxImportUTM"),
		n_get_string("file path"));
*/
}

