/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<math.h>
#include	<stdlib.h>
#include	"task.h"
#include	"utils.h"
#include	"resource.h"
#include	"xlerror.h"
#include	"memory_debug.h"
#include	"memory_routine.h"
#include	"lock_level.h"
#include	"u_math.h"
#include	"gbgraph.h"
#include	"gbview.h"
#include	"xl.h"
#include	"window.h"

void
draw_map(	
	GBVIEW_FLAME * gf,
	RESOURCE* r,
	DRAW_WORK * dw)
{
MAP_POINT_LIST * m;
int len;
GB_POINT * ptr;
REAL1 * reso;
int i,j;
PIC pic;
PIC_ELEMENT * pe;
GB_RECT rect;
int main_code,sub_code;
int flags;
GB_RECT * sr;
int sr_len;
GB_POINT pp;

	len = 0;
	for ( m = R_NEXT(MAP_POINT_LIST*,&r->map.point_list) ;
			m != (MAP_POINT_LIST*)&r->map.point_list;
			m = R_NEXT(MAP_POINT_LIST*,&m->h) )
		len ++;
	ptr = d_alloc(sizeof(GB_POINT)*len);
	reso = d_alloc(sizeof(REAL1)*len);
	i = 0 ; 
	sr = get_surp_rect(&sr_len,&dw->surp,r);
	for ( m = R_NEXT(MAP_POINT_LIST*,&r->map.point_list) ;
			m != (MAP_POINT_LIST*)&r->map.point_list;
			m = R_NEXT(MAP_POINT_LIST*,&m->h) , i ++) {
		pp = m->dest;
		for ( j = 0 ; j < sr_len ; j ++ )
			if ( inside_rect(&sr[j],pp) )
				goto ok;
		ptr[i] = pp;
		reso[i] = -1;
		continue;
	ok:
		ptr[i] = pp;
		reso[i] = 1;
	}
	map_from_resource(dw->mh,ptr,reso,len);
	main_code = sub_code = 0;
	i = 0;
	for ( m = R_NEXT(MAP_POINT_LIST*,&r->map.point_list) ;
			m != (MAP_POINT_LIST*)&r->map.point_list;
			m = R_NEXT(MAP_POINT_LIST*,&m->h) , i ++) {
		if ( reso[i] < 0 )
			continue;
		gc_push(0,0,"draw_map");
		pic = get_onmap_string_pic(gf,
			get_string(m->tag));
		gc_pop(0,0);
		for ( pe = pic.list ; pe ; pe = pe->next ) {
			if ( ptr[i].x > 0x10000 )
				goto next;
			if ( ptr[i].y > 0x10000 )
				goto next;
			if ( ptr[i].x < -0x10000 )
				goto next;
			if ( ptr[i].y < -0x10000 )
				goto next;
			rect.tl.x = pe->p.r.tl.x + rint(ptr[i].x);
			rect.br.x = pe->p.r.br.x + rint(ptr[i].x);
			rect.tl.y = pe->p.r.tl.y + rint(ptr[i].y);
			rect.br.y = pe->p.r.br.y + rint(ptr[i].y);
			if ( pe->flags & PLF_ANCOR )
				flags = SIF_ANCOR;
			else	flags = 0;
			wf_insert_si(
				gf,
				ISI_INSERT,
				dw->wfid,
				r->h.no,
				main_code,
				sub_code,
				&rect,
				pe->data,
				pe->alpha,
				flags,
				pe->ref);
		next:
			pe->data = 0;
			pe->alpha = 0;
		}
		free_pic(pic);
		main_code += 256;
		sub_code ++;
	}
	d_f_ree(ptr);
	d_f_ree(reso);
}

void
get_point_map()
{
	er_panic("get_point_map(1)");
}

