/**********************************************************************
 
	Copyright (C) 2008 Hirohisa MORI <joshua@globalbase.org>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"win_flame.h"


#include	"machine/u_math.h"
#include	"win_flame.h"
#include	"memory_debug.h"
#include	"gbgraph.h"


int
_e1d_p_redraw(GBVIEW_FLAME * gf,WIN_FLAME * wf)
{
int w,h;
MAP_HISTORY * mh;
WIN_FLAME * _wf;
SURP_SET surp;
int id;
GB_RECT r;
int ci_ret;
WF_PARAM_1D * p1d;

	r.tl.x = r.tl.y = 0;
	r.br.x = gf->win_width;
	r.br.y = 0;

	wf_lock(gf);


	if ( wf->flags & WFF_RESIZE ) {
		wf_unlock(gf);
		return -2;
	}
	wf->mov_x = 0;
	wf->mov_y = 0;
	wf->mov_flag = 0;

	w = gf->win_width;
	h = gf->win_height;

	mh = add_mh(&gf->flame_base_display_map,wf->mh);
	set_surp(&surp,&r,gf->flame_base_resolution);
	map_from_flame(mh,surp.ptr,surp.reso,SURP_NOS);
	id = wf->id;
	p1d = wf_get_param_1d(gf,wf);
	wf_unlock(gf);

retry:
	ci_ret = cache_image(gf,wf->id,wf->draw,0,0,0,w,&r,mh,&surp,1,
		WFF_PLOT_DIRTY,p1d);
	if ( ci_ret & WFF_FLUSH ) {
	GB_RECT rct;
		wf_work_area_flush(wf->wa_set);
		rct.tl.x = 0;
		rct.br.x = gf->win_width;
		rct.tl.y = gf->flame_base_y_offset + wf->e1d_y_top + wf->e1d_top_mergin;
		rct.br.y = gf->flame_base_y_offset + wf->e1d_y_bottom + wf->e1d_bottom_mergin;
		win_flame_dirty(gf,wf->id,&rct,WFF_LUSTER_DIRTY,0);

		goto retry;
	}

	wf_lock(gf);
	wf_free_param_1d(p1d);
	_wf = _get_wf_ptr(gf,id);
	if ( _wf != wf )
		goto end;

	if ( wf->flags & WFF_RESIZE ) {
		free_mh(mh);
		wf_unlock(gf);
		return -2;
	}
	if ( wf->mov_flag )
		wf_free_si(wf);
	else	regulate_si(wf);

end:
	wf_unlock(gf);
	free_mh(mh);
	return 0;
}

int
e1d_p_redraw(GBVIEW_FLAME * gf,WIN_FLAME * wf)
{
int ret;
GV_RESOURCE_LIST * rl;
int top,bottom;
	ret = 0;
	wf_lock(gf);
	top = gf->flame_base_y_offset + wf->e1d_y_top + wf->e1d_top_mergin;
	bottom = gf->flame_base_y_offset + wf->e1d_y_bottom + wf->e1d_bottom_mergin;
	if ( top >= gf->win_height ) {
		wf_unlock(gf);
		return 0;
	}
	if ( bottom <= 0 ) {
		wf_unlock(gf);
		return 0;
	}
	rl = _search_resource_list(gf,wf->draw,0,1);
	if ( rl == 0 ) {
		wf_unlock(gf);
		return 1;
	}
	rl->weight = W_E1D_PLOT;
	if ( wf->flags & WFF_PLOT_DIRTY ) {
		wf->flags &= ~(WFF_PLOT_DIRTY|WFF_RESIZE);
		wf_unlock(gf);
		_e1d_p_redraw(gf,wf);
		ret = 1;
	}
	else	wf_unlock(gf);
	return ret;
}

void
e1d_wf_insert_action_plot(GBVIEW_FLAME * gf,WIN_FLAME * wf,int flags,int mov_base_distance,int mov_distance)
{
int total;
	total =  mov_base_distance + mov_distance;
	if ( total == 0 )
		return;
	wf_move_si(gf,wf,0,total);
}


int
e1d_p_move(
	GBVIEW_FLAME * gf,
	WIN_FLAME * wf,VPOINT from,VPOINT to,void * _ix)
{
int top,bottom;
int dy;
	dy = to.y - from.y;
	top = gf->flame_base_y_offset + wf->e1d_y_top + wf->e1d_top_mergin;
	bottom = gf->flame_base_y_offset + wf->e1d_y_bottom + wf->e1d_bottom_mergin;
	if ( dy > 0 )
		bottom += dy;
	else	top += dy;
	if ( top >= gf->win_height )
		return 0;
	if ( bottom <= 0 )
		return 0;
	return e2d_p_move(gf,wf,from,to,_ix);
}


