/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it \u02da
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"machine/u_math.h"
#include	"gbgraph.h"
#include	"win_flame.h"
#include	"memory_debug.h"
#include	"viewindex.h"
#include	"radar.h"

void ov_default();


typedef struct globe_move_wa_t {
	GBVIEW_FLAME * gf;
	WIN_FLAME * wf;
	GLOBE_MOVE_T * t;
} GLOBE_MOVE_WA_T;

void
globe_move_wa_f(I_POINT * ptr,int len,void * _tt)
{
GB_RECT r;
GB_POINT3D p;
double d,sq_radius;
GBVIEW_FLAME * gf;
WIN_FLAME * wf;
GLOBE_MOVE_T * t;
GLOBE_MOVE_WA_T * tt;
	tt = _tt;
	gf = tt->gf;
	wf = tt->wf;
	t = tt->t;
	r.tl.x = r.tl.y = 0;
	r.br.x = gf->win_width;
	r.br.y = gf->win_height;
	sq_radius = t->radius * t->radius;
	for (  ; len ; len -- , ptr ++ ) {
		if ( ptr->x == 0x80000000 || ptr->y == 0x80000000 )
			continue;
		p.x = ptr->x - gf->win_width/2;
		p.y = ptr->y - gf->win_height/2;
		d = p.x * p.x + p.y * p.y;
		if ( d > sq_radius )
			goto del;
		p.z = sqrt(sq_radius - d);
		p = mp_mul3d(t->rev_rm,p);
		if ( p.z < 0 )
			goto del;
		ptr->x = rint(p.x) + gf->win_width/2;
		ptr->y = rint(p.y) + gf->win_height/2;

		continue;
	del:
		ptr->x = 0x80000000;
		ptr->y = 0x80000000;
		continue;
	}
}

void
globe_move_wa(WF_WORK_AREA_SET * aset,GBVIEW_FLAME * gf,WIN_FLAME * wf,GLOBE_MOVE_T * t)
{
GLOBE_MOVE_WA_T tt;
	tt.gf = gf;
	tt.wf = wf;
	tt.t = t;
	wf_work_area_move(aset,globe_move_wa_f,&tt);
}



int
new_rotate_and_center(
	GBVIEW_FLAME * gf,
	GB_POINT from,
	GB_POINT to)
{
MATRIX3D rm;
double radius;
GB_POINT3D pt,pt_old;
GB_POINT center;
MATRIX3D lambda,phi,cita;
double center_lambda,center_phi;
int er;
REAL1 new_rotate;
GB_POINT new_center;
RESOURCE * r;
	r = gf->flame_base->draw;
	radius = conv_unit(&er,
			r->h.cu.uenv,
			gf->flame_base_resolution,
			reso_c_unit(&r->h.cu),
			l_string(std_cm,"dot/rad"));

	from.x -= gf->win_width/2;
	from.y -= gf->win_height/2;
	to.x -= gf->win_width/2;
	to.y -= gf->win_height/2;

	if ( get_gmatrix(rm,from,to,radius) < 0 )
		return -1;

	center_lambda = conv_unit(&er,
			r->h.cu.uenv,
			gf->flame_base_center.x,
			r->h.cu.unit,
			l_string(std_cm,"rad"));
	center_phi = conv_unit(&er,
			r->h.cu.uenv,
			gf->flame_base_center.y,
			r->h.cu.unit,
			l_string(std_cm,"rad"));

	get_round_matrix3d_lambda(lambda,center_lambda);
	get_round_matrix3d_phi(phi,center_phi);
	get_round_matrix3d_cita(cita,gf->flame_base_rotate);
	pt.x = pt.y = 0;
	pt.z = 1;
	pt = mp_mul3d(rm,pt);
	pt = mp_mul3d(cita,pt);
	pt = mp_mul3d(phi,pt);
	pt = mp_mul3d(lambda,pt);
	center = get_globe_position3d(pt);

	new_center.x = conv_unit(&er,
		r->h.cu.uenv,
		center.x,
		l_string(std_cm,"rad"),
		r->h.cu.unit);
	new_center.y = conv_unit(&er,
		r->h.cu.uenv,
		center.y,
		l_string(std_cm,"rad"),
		r->h.cu.unit);

	pt_old.x = pt_old.z = 0;
	pt_old.y = 1;
	pt = pt_old;

	pt = mp_mul3d(rm,pt);
	pt = mp_mul3d(cita,pt);
	pt = mp_mul3d(phi,pt);
	pt = mp_mul3d(lambda,pt);

	get_round_matrix3d_lambda(lambda,-center.x);
	get_round_matrix3d_phi(phi,-center.y);

	pt = mp_mul3d(lambda,pt);
	pt = mp_mul3d(phi,pt);

	/* new_rotate = kakudo of y axis and pt */

	if ( pt.x || pt.y ) {
		if ( pt.x < pt.y ) {
			if ( pt.x < - pt.y ) {
				/* 2 */
				new_rotate = -M_PI/2 - atan(pt.y/pt.x);
			}
			else {
				/* 1 */
				new_rotate = atan(pt.x/pt.y);
			}
		}
		else {
			if ( pt.x < - pt.y ) {
				/* 3 */
				if ( pt.x < 0 ) {
					new_rotate = -M_PI + atan(pt.x/pt.y);
				}
				else {
					new_rotate = M_PI + atan(pt.x/pt.y);
				}
			}
			else {
				/* 4 */
				new_rotate = M_PI/2 - atan(pt.y/pt.x);
			}
		}
	}
	else	new_rotate = 0;


log_printf(LOG_MESSAGE,LOG_LAYER_GB,0,
"NEW %f %f - %f\\n",new_center.x,new_center.y,new_rotate);

	gf->flame_base_center = new_center;
	gf->flame_base_rotate = new_rotate;
	_calc_pitch(gf,1);
	return 0;
}


void
wf_move_si_globe(GBVIEW_FLAME * gf,WIN_FLAME * wf,GLOBE_MOVE_T *t)
{
GB_RECT r;
SYMBOL_INDICATE ** sip, * si1;
GB_POINT3D p;
double d,sq_radius;
int dx,dy;
	r.tl.x = r.tl.y = 0;
	r.br.x = gf->win_width;
	r.br.y = gf->win_height;
	sq_radius = t->radius * t->radius;
	for ( sip = &wf->sym_i ; *sip ; ) {
		si1 = *sip;
		p.x = si1->rect.tl.x - gf->win_width/2;
		p.y = si1->rect.tl.y - gf->win_height/2;
		d = p.x * p.x + p.y * p.y;
		if ( d > sq_radius )
			goto del;
		p.z = sqrt(sq_radius - d);
		p = mp_mul3d(t->rev_rm,p);
		if ( p.z < 0 )
			goto del;
		dx = rint(p.x) + gf->win_width/2 - si1->rect.tl.x;
		dy = rint(p.y) + gf->win_height/2 - si1->rect.tl.y;

		si1->rect.tl.x += dx;
		si1->rect.br.x += dx;
		si1->rect.tl.y += dy;
		si1->rect.br.y += dy;
		if ( cross_rect_rect(&r,&si1->rect) == 1 ) {
			sip = &(*sip)->next;
			continue;
		}
	del:
		*sip = si1->next;
		if ( si1->data )
			d_f_ree(si1->data);
		if ( si1->alpha )
			d_f_ree(si1->alpha);
		if ( si1->rect.tl.x == si1->rect.br.x )
			delete_irq(si1->rno,si1->code);

		d_f_ree(si1);
	}
}


int
globe_small_move(GBVIEW_FLAME * gf,WIN_FLAME * wf,VPOINT from,VPOINT to,
	void * _t)
{
unsigned long * dest;
int w,h;
GLOBE_MOVE_T * t;
I_RECT new_rct;
	t = (GLOBE_MOVE_T*)_t;

	w = gf->win_width;
	h = gf->win_height;
	dest = index_move_small(
		&new_rct,
		wf->pixels,wf->small_rct,
		t->ix,w,h,
		BACKGROUND_COLOR|C_DIRTY,
		C_DIRTY);
	wf_move_si_globe(gf,wf,t);
	globe_move_wa(wf->wa_set,gf,wf,t);
	d_f_ree(wf->pixels);
	wf->pixels = dest;
	wf->small_rct = new_rct;
	wf_check_small(gf,wf);
	if ( wf->flags & WFF_LUSTER )
		wf->flags |= WFF_LUSTER_DIRTY;
	if ( wf->flags & WFF_POLY )
		wf->flags |= WFF_POLY_DIRTY;
	if ( wf->flags & WFF_PLOT )
		wf->flags |= WFF_PLOT_DIRTY;
	return 0;
}


int
globe_move(GBVIEW_FLAME * gf,WIN_FLAME * wf,VPOINT from,VPOINT to,
	void * _t)
{
unsigned long * dest;
int w,h;
GLOBE_MOVE_T * t;
	t = (GLOBE_MOVE_T*)_t;

	w = gf->win_width;
	h = gf->win_height;
	dest = d_alloc(sizeof(unsigned long)*w*h);
	index_move(dest,wf->pixels,t->ix,w,h,BACKGROUND_COLOR|C_DIRTY,
			C_DIRTY);
	wf_move_si_globe(gf,wf,t);
	globe_move_wa(wf->wa_set,gf,wf,t);
	d_f_ree(wf->pixels);
	wf->pixels = dest;
	if ( wf->flags & WFF_LUSTER )
		wf->flags |= WFF_LUSTER_DIRTY;
	if ( wf->flags & WFF_POLY )
		wf->flags |= WFF_POLY_DIRTY;
	if ( wf->flags & WFF_PLOT )
		wf->flags |= WFF_PLOT_DIRTY;
	return 0;
}


int
globe_move_plot(GBVIEW_FLAME * gf,WIN_FLAME * wf,
	VPOINT from,VPOINT to,
	void * _t)
{
GLOBE_MOVE_T * t;
	t = _t;
	wf_move_si_globe(gf,wf,t);
	if ( wf->flags & WFF_PLOT )
		wf->flags |= WFF_PLOT_DIRTY;
	globe_move_wa(wf->wa_set,gf,wf,t);
	return 0;
}

void
globe_calc_pitch(GBVIEW_FLAME * gf,int flag)
{
GB_POINT pp;
REAL1 reso,phi;
REAL1 x_sign,y_sign;
RESOURCE * r;
int er;

	r = gf->flame_base->draw;
	if ( r->c.geometory_type & GT_A_X_REV ) 
		x_sign = -1;
	else	x_sign = 1;
	if ( r->c.geometory_type & GT_A_Y_REV )
		y_sign = -1;
	else	y_sign = 1;
	gf->flame_base_display_map.d.pp.forward_rate
		= conv_unit(&er,
			r->h.cu.uenv,
			1,
			r->h.cu.unit,
			l_string(std_cm,"rad"));

	if ( flag == 0 ) {
		pp.x = ((REAL1)gf->win_width)/2;
		pp.y = ((REAL1)gf->win_height)/2;
		reso = 1;
		map_from_flame(
			&gf->flame_base_display_map,
			&pp,
			&reso,
			1);
		gf->flame_base_center = pp;
	}


	gf->flame_base_display_map.d.pp.lambda
		= gf->flame_base_center.x * x_sign;
	gf->flame_base_display_map.d.pp.phi
		= phi = gf->flame_base_center.y * y_sign;

	phi = conv_unit(&er,
			r->h.cu.uenv,
			phi,
			r->h.cu.unit,
			l_string(std_cm,"rad"));
	reso = conv_unit(&er,
			r->h.cu.uenv,
			gf->flame_base_resolution,
			reso_c_unit(&r->h.cu),
			l_string(std_cm,"dot/rad"));

       	gf->flame_base_display_map.d.pp.reverse_sur.org.x =
		-(cos(gf->flame_base_rotate)*gf->win_width
				+
		  sin(gf->flame_base_rotate)*gf->win_height)
			/(2*reso);
	gf->flame_base_display_map.d.pp.reverse_sur.org.y =
		-(-sin(gf->flame_base_rotate)*gf->win_width
				+
		  cos(gf->flame_base_rotate)*gf->win_height)
			/(2*reso);
	gf->flame_base_display_map.d.pp.reverse_sur.matrix[0][0] =
		cos(gf->flame_base_rotate)/reso;
	gf->flame_base_display_map.d.pp.reverse_sur.matrix[0][1] =
		sin(gf->flame_base_rotate)/reso;
	gf->flame_base_display_map.d.pp.reverse_sur.matrix[1][0] =
		-sin(gf->flame_base_rotate)/reso;
	gf->flame_base_display_map.d.pp.reverse_sur.matrix[1][1] =
		cos(gf->flame_base_rotate)/reso;

	gf->flame_base_display_map.d.pp.reverse_vol[0][0] = 1;
	gf->flame_base_display_map.d.pp.reverse_vol[0][1] = 0;
	gf->flame_base_display_map.d.pp.reverse_vol[0][2] = 0;
	gf->flame_base_display_map.d.pp.reverse_vol[1][0] = 0;
	gf->flame_base_display_map.d.pp.reverse_vol[1][1] = cos(phi);
	gf->flame_base_display_map.d.pp.reverse_vol[1][2] = -sin(phi);
	gf->flame_base_display_map.d.pp.reverse_vol[2][0] = 0;
	gf->flame_base_display_map.d.pp.reverse_vol[2][1] = sin(phi);
	gf->flame_base_display_map.d.pp.reverse_vol[2][2] = cos(phi);


	gf->flame_base_display_map.d.pp.forward_sur.org.x =
		((REAL1)gf->win_width)/2;
	gf->flame_base_display_map.d.pp.forward_sur.org.y =
		((REAL1)gf->win_height)/2;
	gf->flame_base_display_map.d.pp.forward_sur.matrix[0][0] =
		cos(gf->flame_base_rotate)*reso;
	gf->flame_base_display_map.d.pp.forward_sur.matrix[0][1] =
		-sin(gf->flame_base_rotate)*reso;
	gf->flame_base_display_map.d.pp.forward_sur.matrix[1][0] =
		sin(gf->flame_base_rotate)*reso;
	gf->flame_base_display_map.d.pp.forward_sur.matrix[1][1] =
		cos(gf->flame_base_rotate)*reso;

	gf->flame_base_display_map.d.pp.forward_vol[0][0] = 1;
	gf->flame_base_display_map.d.pp.forward_vol[0][1] = 0;
	gf->flame_base_display_map.d.pp.forward_vol[0][2] = 0;
	gf->flame_base_display_map.d.pp.forward_vol[1][0] = 0;
	gf->flame_base_display_map.d.pp.forward_vol[1][1] = cos(phi);
	gf->flame_base_display_map.d.pp.forward_vol[1][2] = sin(phi);
	gf->flame_base_display_map.d.pp.forward_vol[2][0] = 0;
	gf->flame_base_display_map.d.pp.forward_vol[2][1] = -sin(phi);
	gf->flame_base_display_map.d.pp.forward_vol[2][2] = cos(phi);

	gf->flame_base_display_map.type = MHT_PP;
	gf->flame_base_display_map.dir = MHD_REVERSE;

}

int
wf_move_globe(GBVIEW_FLAME * gf,VPOINT from,VPOINT to)
{
WIN_FLAME * wf;
GB_POINT gb_from,gb_to;
double radius;
RESOURCE * r;
int x,y,ix;
char * rp, * _rp;
unsigned long * rpp,* _rpp;
int w,h;
int er;
GLOBE_MOVE_T gt;
I_POINT * ixp;
I_RECT ir;

	w = gf->win_width;
	h = gf->win_height;

	new_rotate_and_center(gf,v2gb_point(from),v2gb_point(to));

	r = gf->flame_base->draw;
	radius = conv_unit(&er,
			r->h.cu.uenv,
			gf->flame_base_resolution,
			reso_c_unit(&r->h.cu),
			l_string(std_cm,"dot/rad"));

	gt.ix = d_alloc(sizeof(I_POINT)*w*h);
	gt.radius = radius;
	if ( wf_make_gmatrix_index(gt.ix,
			gb_from = v2gb_point(from),
			gb_to = v2gb_point(to),radius,w,h) < 0 ) {
		d_f_ree(gt.ix);
		return 0;
	}
	get_gmatrix(gt.rm,gb_from,gb_to,radius);
	get_inv_gmatrix(gt.rev_rm,gb_from,gb_to,radius);

	for ( wf = gf->flame ; wf ; wf = wf->next ) {
		if ( wf->flags & (WFF_FREE|WFF_HIDE) )
			continue;
		win_flame_move(gf,wf,from,to,&gt);
	}

	_wf_purge_select(gf);

	_rp = rp = d_alloc(w*h);
	_rpp = rpp = d_alloc(sizeof(long)*w*h);
	ixp = gt.ix;
	ir.tl.x = ir.tl.y = 0;
	ir.br.x = ir.br.y = -1;
	for ( y = 0 ; y < h ; y ++ )
		for ( x = 0 ; x < w ; x ++ , ixp ++ , rp ++ , rpp ++ ) {
			if ( ixp->x < 0 )
				goto no_data;
			ix = ixp->x + ixp->y * w;
			*rp = gf->redraw[ix];
			*rpp = gf->redraw_plane[ix];
			if ( *rp == RP_REDRAW )
				insert_vrect(&ir,x,y);
			continue;
		no_data:
			*rp = RP_REDRAW;
			*rpp = BACKGROUND_COLOR;
			insert_vrect(&ir,x,y);
		}
	gf->redraw_r.tl.x = gf->redraw_r.tl.y 
		= gf->redraw_r.br.x = gf->redraw_r.br.y = 0;
	insert_redraw_r(gf,&ir);
	d_f_ree(gt.ix);
	d_f_ree(gf->redraw);
	gf->redraw = _rp;
	d_f_ree(gf->redraw_plane);
	gf->redraw_plane = _rpp;
	assert_ls(gf,LSF_MOVE);
	gf->move_flag = 1;
	_set_move_timer(gf);
#ifdef CACHE_TEST_DEBUG
ss_printf("CACHE-TEST WAKEUP-WIN-MANAGE %lli\\n",(INTEGER64)get_xltime());
#endif
	_wakeup_win_manage(gf->radar_ptr);

	return _get_env_seq(gf);
}


int
globe_move_gen(GBVIEW_FLAME * gf,WIN_FLAME * wf,VPOINT from, VPOINT to,void * ix)
{
	return wf_move_globe(gf,from,to);
}


