/**********************************************************************
 
	Copyright (C) 2008- Hirohisa MORI <joshua@globalbase.org>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"memory_debug.h"
#include	"xl.h"
#include	"xlerror.h"
#include	"utils.h"
#include	"spidering.h"

XL_SEXP * gb_SPcd();

void
init_gb_SPcd(XLISP_ENV * env1,XLISP_ENV * env0)
{
	set_env(env1,l_string(std_cm,"SPcd"),
		get_func_prim(gb_SPcd,FO_APPLICATIVE,0,2,2));
	set_env(env0,l_string(std_cm,"___pwd"),n_get_string("root"));
}

XL_SEXP *
gb_SPcd(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,
	XL_SYM_FIELD * sf)
{
XL_SEXP * path;
XL_SEXP * pwd;
L_CHAR * target_path;
int len1,len2;
void * data;
L_CHAR ext[3];
XL_SEXP * pwd_sym;
INTEGER64 fofs;
	path = get_el(s,1);
	if ( get_type(path) != XLT_STRING )
		goto type_missmatch;
	pwd = eval(env,pwd_sym=n_get_symbol("___pwd"));
	ext[0] = LC_SECC_HEADER;
	ext[1] = LC_SECC_INFO_START;
	ext[2] = 0;
	if ( memcmp(path->string.data,l_string(std_cm,"root"),sizeof(L_CHAR)*4) == 0 ) {
		target_path = ll_copy_str(path->string.data);
		data = get_sp_data(&fofs,wa_list,target_path,&ext[0]);
		if ( data == 0 )
			goto invalid_param;
		d_f_ree(data);
	}
	else if ( get_type(pwd) != XLT_STRING ) {
		target_path = ll_copy_str(path->string.data);
		data = get_sp_data(&fofs,wa_list,target_path,&ext[0]);
		if ( data == 0 )
			goto invalid_param;
		d_f_ree(data);
	}
	else if ( l_strcmp(path->string.data,l_string(std_cm,"..")) == 0 ) {
		target_path = get_sp_parent_path((PN64_SEARCH_FUNDAMENTAL_INFO**)&data,wa_list,pwd->string.data);
		if ( target_path == 0 )
			goto invalid_param;
		d_f_ree(data);
	}
	else {
		target_path = ll_copy_str(pwd->string.data);
		len1 = l_strlen(target_path);
		len2 = l_strlen(path->string.data);
		target_path = d_re_alloc(target_path,sizeof(L_CHAR)*(len1+len2+1));
		l_strcpy(&target_path[len1],path->string.data);
		data = get_sp_data(&fofs,wa_list,target_path,&ext[0]);
		if ( data == 0 )
			goto invalid_param;
		d_f_ree(data);
	}
	set_op(env,pwd_sym,get_string(target_path));
	return 0;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"SPcd"),
		0);
invalid_param:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"SPcd"),
		n_get_string("invlid path"));
}

