/**********************************************************************
 
	Copyright (C) 2008- Hirohisa MORI <joshua@globalbase.org>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"memory_debug.h"
#include	"xl.h"
#include	"xlerror.h"
#include	"utils.h"
#include	"spidering.h"

XL_SEXP * gb_SPdatabasePath();

void
init_gb_SPdatabasePath(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"SPdatabasePath"),
		get_func_prim(gb_SPdatabasePath,FO_APPLICATIVE,0,2,2));
}

XL_SEXP *
gb_SPdatabasePath(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,
	XL_SYM_FIELD * sf)
{
SPIDERING_WORK_AREA * wa;
XL_SEXP * path;
int er;
	path = get_el(s,1);
	if ( get_type(path) != XLT_STRING )
		goto type_missmatch;
	wa = open_spcache(&er,path->string.data);
	if ( wa == 0 )
		goto invalid_param;
	return 0;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"SPdatabasePath"),
		0);
invalid_param:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"SPdatabasePath"),
		List(n_get_string("filename error"),
			get_integer(er,0),
			-1));
}

