/**********************************************************************
 
	Copyright (C) 2008- Hirohisa MORI <joshua@globalbase.org>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"memory_debug.h"
#include	"xl.h"
#include	"xlerror.h"
#include	"utils.h"
#include	"spidering.h"

XL_SEXP * gb_SPdefineAgent();

void
init_gb_SPdefineAgent(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"SPdefineAgent"),
		get_func_prim(gb_SPdefineAgent,FO_APPLICATIVE,0,4,4));
}

XL_SEXP *
gb_SPdefineAgent(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,
	XL_SYM_FIELD * sf)
{
XL_SEXP * name;
XL_SEXP * core_binary;
XL_SEXP * loading;
char * err;
	name = get_el(s,1);
	core_binary = get_el(s,2);
	loading = get_el(s,3);
	err = "name";
	if ( get_type(name) != XLT_STRING )
		goto type_missmatch;
	err = "core-binary";
	if ( get_type(core_binary) == XLT_STRING )
		goto type_missmatch;
	err = "loading-file";
	if ( get_type(loading) != XLT_STRING )
		goto type_missmatch;
	if ( new_outer_sp_agent(name->string.data,core_binary->string.data,loading->string.data) == 0 )
		goto already_exist;
	return 0;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"SPdefineAgent"),
		List(n_get_string("type missmatch"),n_get_string(err),-1));
already_exist:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_DUP_DEFINITION,
		l_string(std_cm,"SPdefineAgent"),
		List(n_get_string("already exist agent"),
			-1));
}

