/**********************************************************************
 
	Copyright (C) 2007- Hirohisa MORI <joshua@globalbase.org>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"memory_debug.h"
#include	"utils.h"
#include	"xlerror.h"
#include	"xl.h"
#include	"mx_format.h"
#include	"ppm_types.h"
#include	"radar.h"
#include	"win_flame.h"

void
matrix_test(MATRIX * m);
extern int test_debug;

#define GVHA_LOADING_STATUS

#define SCAN_LEVEL_OFS		((INTEGER64)2)


#define IGN_SEARCH_LOADING	0x00000001
#define IGN_LAYER_MANAGEMENT	0x00000002
#define IGN_RETRIEVE1		0x00000004
#define IGN_RETRIEVE2		0x00000008
#define IGN_CHANGE_BASE_CRD	0x00000010

//#define IGN_FLAGS	(IGN_SEARCH_LOADING|IGN_LAYER_MANAGEMENT|IGN_RETRIEVE1|IGN_RETRIEVE2|IGN_CHANGE_BASE_CRD)
#define IGN_FLAGS	0

/*
([gvImageSpider id="matrix-id"]
	spidering-warp-point[start-point]
	spidering-end-point
	save-start-point
	)

([gvImageSpider id="get-status"]
	spidering-warp-point[start-point]
	spidering-end-point
	save-start-point
	)
*/


typedef struct spider_work {
	GBVIEW_FLAME*			gf;
	INTEGER64 *			start;
	INTEGER64 *			org_start;
	WARP_POINT *			wp;
	GB_POINT			start_ptr;
	int				channel;
	GBVIEW_PLANE			plane;
	unsigned			load:1;
} SPIDER_WORK;

XL_SEXP * gv_gvImageSpider();

void
init_gvImageSpider(XLISP_ENV * env0,XLISP_ENV * env1)
{
	set_env(env1,l_string(std_cm,"gvImageSpider"),
		get_func_prim(gv_gvImageSpider,FO_APPLICATIVE,0,4,4));
}


INTEGER64 data_request_time;
int data_request_value;
GBVIEW_FLAME * now_gf;

int
loading_status_sum(LOADING_STATUS * ls,int ign)
{
int i;
int all;


	all = 0;
	
	if ( !(ign & IGN_SEARCH_LOADING) ) {
		all += ls->rc.search_loading;
#ifdef GVHA_LOADING_STATUS
	if ( ls->rc.search_loading )
	ss_printf("rc.search_loading = %i\n",ls->rc.search_loading);
#endif
	}
	if ( !(ign & IGN_LAYER_MANAGEMENT) ) {
	all += ls->rc.layer_management;
#ifdef GVHA_LOADING_STATUS
if ( ls->rc.layer_management )
ss_printf("rc.layer_management = %i\n",ls->rc.layer_management);
#endif
	}
	if ( !(ign & IGN_CHANGE_BASE_CRD) ) {
	all += ls->rc.change_base_coord;
#ifdef GVHA_LOADING_STATUS
if ( ls->rc.change_base_coord )
ss_printf("rc.change_base_cord = %i\n",ls->rc.change_base_coord);
#endif
	}
	all += ls->rc.ri.d.beam;
#ifdef GVHA_LOADING_STATUS
if ( ls->rc.ri.d.beam )
ss_printf("rc.ri.d.beam = %i\n",ls->rc.ri.d.beam);
#endif
	for ( i = CRT_MAX ; i >= 0 ; i -- ) {
		all += ls->rc.ri.d.loading_res[i];
#ifdef GVHA_LOADING_STATUS
if ( ls->rc.ri.d.loading_res[i] )
ss_printf("rc.ri.d.loading_res[%i] = %i\n",i,ls->rc.ri.d.loading_res[i]);
#endif
	}
	for ( i = CRT_MAX ; i >= 0 ; i -- ) {
		all += ls->rc.ri.d.ready_res[i];
#ifdef GVHA_LOADING_STATUS
if ( ls->rc.ri.d.ready_res[i] )
ss_printf("rc.ri.d.ready_res[%i] = %i\n",i,ls->rc.ri.d.ready_res[i]);
#endif
	}
	all += ls->rc.ri.d.load_to_beam;
#ifdef GVHA_LOADING_STATUS
if ( ls->rc.ri.d.load_to_beam )
ss_printf("rc.ri.d.load_to_beam = %i\n",ls->rc.ri.d.load_to_beam);
#endif
	all += ls->rc.ri.d.beam_to_resource;
#ifdef GVHA_LOADING_STATUS
if  ( ls->rc.ri.d.beam_to_resource )
ss_printf("rc.ri.d.beam_to_resource = %i\n",ls->rc.ri.d.beam_to_resource);
#endif
	if ( !(ign & IGN_RETRIEVE1) ) {
	all += ls->rc.ri.d.retrieve1;
#ifdef GVHA_LOADING_STATUS
if ( ls->rc.ri.d.retrieve1 )
ss_printf("rc.ri.d.retrieve1 = %i\n",ls->rc.ri.d.retrieve1);
#endif
	}
	if ( !(ign & IGN_RETRIEVE2) ) {
	all += ls->rc.ri.d.retrieve2;
#ifdef GVHA_LOADING_STATUS
if ( ls->rc.ri.d.retrieve2 )
ss_printf("rc.ri.d.retrieve2 = %i\n",ls->rc.ri.d.retrieve2);
#endif
	}
	all += ls->wf.draw;
#ifdef GVHA_LOADING_STATUS
if ( ls->wf.draw )
ss_printf("rc.wf.draw = %i - Resouce Check %i %i\n",ls->wf.draw,
	s_check_resource3(),s_check_resource2(0));
#endif
	all += ls->wf.exit;
#ifdef GVHA_LOADING_STATUS
if ( ls->wf.exit )
ss_printf("rc.wf.exit = %i\n",ls->wf.exit);
#endif
	all += ls->wf.load_structure;
#ifdef GVHA_LOADING_STATUS
if ( ls->wf.load_structure )
ss_printf("rc.wf.load_structure = %i\n",ls->wf.load_structure);
#endif
	all += ls->wf.data_request;
#ifdef GVHA_LOADING_STATUS
if ( ls->wf.data_request )
ss_printf("rc.wf.data_request = %i\n",ls->wf.data_request);
#endif
	all += ls->wf.indicate_request;
#ifdef GVHA_LOADING_STATUS
if ( ls->wf.indicate_request )
ss_printf("rc.wf.indicate_request = %i\n",ls->wf.indicate_request);
#endif
	all += ls->wf.indicate;
#ifdef GVHA_LOADING_STATUS
if ( ls->wf.indicate )
ss_printf("rc.wf.indicate = %i\n",ls->wf.indicate);
#endif
	all += ls->wf.raw_image_request;
#ifdef GVHA_LOADING_STATUS
if ( ls->wf.raw_image_request )
ss_printf("rc.wf.raw_image_request = %i\n",ls->wf.raw_image_request);
#endif

/*
if ( data_request_value != ls->wf.data_request ) {
data_request_value = ls->wf.data_request;
data_request_time = get_xltime();
}
else {
INTEGER64 sub;
	sub = get_xltime() - data_request_time;
	ss_printf("DATA REQUEST TIME = %lli\n",sub);
	if  ( sub > 30 && now_gf && data_request_value ) {
	WIN_FLAME * wf;
		ss_printf("TRIGGER =========================\n");
exit(1);
		for ( wf = now_gf->flame ; wf ; wf = wf->next ) {
			if ( wf->pixels ) {
				wf->flags |= WFF_LUSTER_DIRTY;
				for ( i = 0 ; i < now_gf->win_width * now_gf->win_height ; i ++ )
					wf->pixels[i] |= C_DIRTY;
			}
		}
	}
}
*/
	return all;
}

void
call_spider_event(GBVIEW_FLAME * gf,int type,void * sarg,void * uarg)
{
LOADING_STATUS ls;
GBVIEW_STATUS sts;
int all;
	if ( type != ET_STATUS )
		return;
//ss_printf("WF SPIDER\n");
	memset(&ls,0,sizeof(ls));
	wf_status(gf,&sts);
	ls.wf = sts.loading_status;
	wf_free_status(&sts);
	if ( (all=loading_status_sum(&ls,IGN_FLAGS)) == 0 )
		wakeup_task((int)uarg);
}

void
call_rc_spider_event(RADAR_CACHE * rc_ptr,void * sw)
{
LOADING_STATUS ls;
int all;
//ss_printf("RC SPIDER\n");
	memset(&ls,0,sizeof(ls));
	get_rc_loading_status(
		rc_ptr,&ls.rc);
	if ( (all=loading_status_sum(&ls,IGN_FLAGS)) == 0 )
		wakeup_task((int)sw);
}

void
print_sts_layer(GBVIEW_STATUS * sts)
{
GBVIEW_LAYER_STATUS * ls,*ls1,**lsp;
static GBVIEW_LAYER_STATUS * ls_last;

	for ( ls = sts->layers, ls1 = ls_last ; ls && ls1 ; ls = ls->next , ls1 = ls1->next ) {
		if ( l_strcmp(ls->entry_url,ls1->entry_url) )
			goto print;
		if ( ls->hide_time != ls1->hide_time )
			goto print;
	}
	if ( ls || ls1 )
		goto print;
	return;
print:
	ss_printf("STS\n");
	for ( ls = sts->layers ; ls ; ls = ls->next )
		ss_printf("\tL %ls " I64_FORMAT "\n",ls->entry_url,ls->hide_time);

	wf_free_layer_status(ls_last);
	ls_last = 0;
	lsp = &ls_last;
	for ( ls = sts->layers ; ls ; ls = ls->next ) {
		ls1 = d_alloc(sizeof(*ls1));
		memcpy(ls1,ls,sizeof(*ls));
		ls1->entry_url = ll_copy_str(ls->entry_url);
		ls1->target_url = ll_copy_str(ls->target_url);
		ls1->next = 0;
		*lsp = ls1;
		lsp = &ls1->next;
	}
}

int
spider_func(MATRIX_SCAN_T * sc)
{
SPIDER_WORK * sw;
MATRIX * m;
GB_POINT center;
GBVIEW_STATUS sts;
LOADING_STATUS ls;
MATRIX_NODE * n;
GB_RECT rr;
unsigned long * inner_plane;
int width,height;
int _width,_height;
int w,h;
MATRIX_DH_SET dh;
unsigned int * _dh;
unsigned int r,g,b,cc;
int x,y;
int x_ofs,y_ofs;
	sw = (SPIDER_WORK*)sc->work;
	sc->channel = sw->channel;
	n = sc->n;
	m = sc->m;
	x_ofs = (sc->dim_code[1]>>(sw->start[0]*m->dim_divide[0])) 
			& ((((INTEGER64)1)<<(SCAN_LEVEL_OFS*m->dim_divide[0]+m->block_size[0]))-1);
	y_ofs = (sc->dim_code[2]>>(sw->start[0]*m->dim_divide[1])) 
			& ((((INTEGER64)1)<<(SCAN_LEVEL_OFS*m->dim_divide[1]+m->block_size[1]))-1);
	width = ((int)1)<<m->block_size[0];
	height = ((int)1)<<m->block_size[1];
	rr.tl.x = 0;
	rr.tl.y = 0;
	rr.br.x = (_width = 2*width + (((INTEGER64)1)<<(m->block_size[0]+SCAN_LEVEL_OFS*m->dim_divide[0])));
	rr.br.y = (_height = 2*height + (((INTEGER64)1)<<(m->block_size[1]+SCAN_LEVEL_OFS*m->dim_divide[1])));

	switch ( sc->dir ) {
	case MST_FIRST:


		if ( sc->dim_code[0] > sw->start[0]+SCAN_LEVEL_OFS )
			return MST_SRCH;
		if ( sc->dim_code[0] < sw->start[0] )
			return 0;
		if ( sc->dim_code[0] == sw->start[0] ) {
			inner_plane = sw->plane.r.plane;
			for ( y = y_ofs ; y < y_ofs + height ; y ++ )
				for ( x = x_ofs ; x < x_ofs + width ; x ++ )
					if ( (inner_plane[x+y*_width] & C_TRANSPARENT) == 0 )
						goto load;
			sw->load = 0;
			return 0;
		load:
			sc->loading_type = SLT_CHANNEL;
			sc->gn_tree_node = GN_TREE;
			sc->gn_create = GN_LIST_CREATE;
			sc->dirty_flags = 0;
			sw->load = 1;
			return MST_1LOAD;
		}
		if ( sc->dim_code[0] < sw->start[0]+SCAN_LEVEL_OFS )
			return MST_SRCH;

		/* SCAN_LEVEVL_OFS */

		center.x = sw->wp->center.x + ((((sc->dim_code[1] - sw->org_start[1])>>(sw->start[0]*m->dim_divide[0])))
					+ _width/2)
					/sw->wp->resolution;
		center.y = sw->wp->center.y + ((((sc->dim_code[2] - sw->org_start[2])>>(sw->start[0]*m->dim_divide[1])))
					+ _height/2)
					/sw->wp->resolution;
		rc_warp((RADAR_CACHE*)sw->gf->radar_ptr,WT_CENTER,0,&center,sw->wp->resolution,0,sw->wp->base,0,0);


		wf_wakeup(sw->gf);
now_gf = sw->gf;
		for ( ; ; ) {
		int all;
/*
			set_redraw_rect(sw->gf,&rr);
			if ( !wf_redraw(sw->gf,&sw->plane,
				0,0,
				3*width,3*height) )
				er_panic("spider_func");
			wf_free_plane(&sw->plane);
*/

			wf_status(sw->gf,&sts);
			ls.wf = sts.loading_status;
print_sts_layer(&sts);
			wf_free_status(&sts);
			get_rc_loading_status(
				(RADAR_CACHE*)sw->gf->radar_ptr,&ls.rc);
			if ( (all=loading_status_sum(&ls,IGN_FLAGS)) == 0 )
				break;
			wf_wakeup(sw->gf);
ss_printf("WAIT=1== %i\n",all);
			new_timeout((int)sw,1);
			sleep_task((int)sw,SEM_NULL);
		}
ss_printf("ST\n");
		set_redraw_rect(sw->gf,&rr);
		if ( !wf_redraw(sw->gf,&sw->plane,
			0,0,
			_width,_height) )
			er_panic("spider_func");
		return MST_SRCH;
/*
	load:
ss_printf("ST-2\n");
*/

	case MST_AFTERLOAD:
ss_printf("=============================================================AFTER LOAD\n");
		n = sc->n;
		if ( sc->dim_code[0] > sw->start[0] )
			return MST_SRCH;
		if ( sc->dim_code[0] < sw->start[0] )
			return 0;
		m = sc->m;
		if ( sw->load == 0 )
			return 0;
		m = n->matrix;

		get_matrix_dh_set(&dh,sc->channel_data);
		inner_plane = sw->plane.r.plane;
		
		_dh = dh.offset;
		w = dh.ix[0];
		h = dh.ix[1];
		
		for ( y = 0 ; y < h ; y ++ ) {
			for ( x = 0 ; x < w ; x ++ ) {
				cc = inner_plane[x + x_ofs + (y+y_ofs)*_width];
				if ( !(cc & C_TRANSPARENT) ) {
					r = (cc>>(COL_BIT-8))&0x0ff;
					g = (cc>>(2*COL_BIT-8))&0x0ff;
					b = (cc>>(3*COL_BIT-8))&0x0ff;
					cc = (r<<24)|(g<<16)|(b<<8);
					_dh[x + y*w] = cc;
				}
				sc->dirty_flags = NF_DIRTY;
			}
		}
		
		return 0;
	case MST_LAST:
		if ( sc->dim_code[0] == sw->start[0]+SCAN_LEVEL_OFS ) {
			wf_free_plane(&sw->plane);
			memset(&sw->plane,0,sizeof(sw->plane));
			return 0;
		}
		return 0;
	default:
		return 0;
	}
	
	return 0;
}

void
set_base_permanent_lock(WARP_POINT * wp)
{
WARP_POINT_LAYER * ly;

	for ( ly = wp->layers ; ly ; ly = ly->next ) {
		if ( ly->flags & WFF_BASE_P_LOCK )
			return;
	}
	for ( ly = wp->layers ; ly ; ly = ly->next ) {
		if ( ly->flags & WFF_BASE_LOCK ) {
			ly->flags |= WFF_BASE_P_LOCK;
			return;
		}
	}
	for ( ly = wp->layers ; ly ; ly = ly->next ) {
		if ( l_strcmp(ly->entry,wp->base) == 0 ) {
			ly->flags |= WFF_BASE_P_LOCK;
			return;
		}
	}
	ly = d_alloc(sizeof(*ly));
	ly->entry = ll_copy_str(wp->base);
	ly->flags = WFF_BASE_P_LOCK;
	ly->next = wp->layers;
	wp->layers = ly;
}

XL_SEXP *
gv_gvImageSpider(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
L_CHAR * id,* ch;
int _ch;
char * e_msg;
INTEGER64 * _start,* _end,*__start;
MX_ENTRY * mx_e;
WARP_POINT * wp;
GB_POINT end_ptr;
INTEGER64 width,height;
GBVIEW_FLAME * gf;
GBVIEW_STATUS sts;
LOADING_STATUS ls;
SPIDER_WORK sw;
INTEGER64 mask;
XL_SEXP * x,* y,* p;
GB_RECT rr;
GBVIEW_PLANE plane;
	e_msg = "id";
	id = get_sf_attribute(sf,l_string(std_cm,"id"));
	if ( id == 0 )
		goto inv_param;
	if ( l_strcmp(id,l_string(std_cm,"get-status")) == 0 ) {
		mx_e = 0;
		goto next;
	}
	e_msg = "value of id";
	mx_e = search_mx_entry_by_id(atoi(n_string(std_cm,id)));
	if ( mx_e == 0 )
		goto inv_param;
	e_msg = "channel";
	ch = get_sf_attribute(sf,l_string(std_cm,"channel"));
	if ( ch == 0 )
		goto inv_param;
	_ch = atoi(n_string(std_cm,ch));
next:
	wp = sexp2wp(get_el(s,1));
	e_msg = "start-warp-point";
	if ( wp == 0 )
		goto inv_param;
	e_msg = "spidering-end-point";
print_sexp(s_stdout,get_el(s,3),0);
ss_printf("\n");
	if ( get_gbpoint(0,&end_ptr,get_el(s,2)) < 0 )
		goto inv_param;

	if ( wp->center.x >= end_ptr.x ||
		wp->center.y >= end_ptr.y ) {
		e_msg = "spidering start point and end point";
		goto inv_param;
	}
	width = (end_ptr.x - wp->center.x)*wp->resolution;
	height = (end_ptr.y - wp->center.y)*wp->resolution;
	if ( width == 0 || height == 0 ) {
		e_msg = "too small resolution";
		goto inv_param;
	}
	if ( mx_e == 0 ) {
		p = get_el(s,3);
		x = get_el(p,1);
		y = get_el(p,2);
		if ( get_type(x) != XLT_INTEGER )
			goto type_missmatch;
		if ( get_type(y) != XLT_INTEGER )
			goto type_missmatch;
		return List(get_integer(x->integer.data + width,0),
			get_integer(y->integer.data + height,0),-1);
	}

	_start = get_dim_code_from_sexp(mx_e->c.m,get_el(s,3));
	__start = copy_dim_code(mx_e->c.m,_start);
ss_printf("FF %s\n",pt_dc(mx_e->c.m,_start,PTDC_NODE_ID));

	mask = -(((INTEGER64)1)<<(_start[0]*mx_e->c.m->dim_divide[0] + mx_e->c.m->block_size[0]));
	_start[1] &= mask;
	mask = -(((INTEGER64)1)<<(_start[0]*mx_e->c.m->dim_divide[1] + mx_e->c.m->block_size[1]));
	_start[2] &= mask;
	
	e_msg = "dim_code format (start)";
	if ( _start == 0 )
		goto inv_param;
	_end = copy_dim_code(mx_e->c.m,_start);
	_end[1] += width<<(_end[0]*mx_e->c.m->dim_divide[0]);
	_end[2] += height<<(_end[0]*mx_e->c.m->dim_divide[1]);
ss_printf("call-force %s %s\n",pt_dc(mx_e->c.m,_start,PTDC_NODE_ID),pt_dc(mx_e->c.m,_end,PTDC_NODE_ID));

	gf = wf_open();
	wf_init_status(&sts);
	sts.flags = SF_DEFAULT_WS|SF_WIDTH|SF_HEIGHT|SF_EVENT;
	sts.event = call_spider_event;
	sts.event_user_arg = (void*)&sw;
	sts.default_ws = get_ws(l_string(std_cm,"DefaultStyle"));
	sts.width = (((int)1)<<mx_e->c.m->block_size[0])*2+(((int)1)<<(mx_e->c.m->block_size[0]+SCAN_LEVEL_OFS*mx_e->c.m->dim_divide[0]));
	sts.height = (((int)1)<<mx_e->c.m->block_size[1])*2+(((int)1)<<(mx_e->c.m->block_size[1]+SCAN_LEVEL_OFS*mx_e->c.m->dim_divide[1]));
	wf_set_status(gf,&sts);
	
	sw.start = _start;
	sw.org_start = __start;
	sw.wp = wp;
	sw.gf = gf;
	sw.channel = _ch;

	set_base_permanent_lock(wp);
	rc_warp((RADAR_CACHE*)gf->radar_ptr,WT_WARP_POINT,0,0,0,0,0,wp,1);
	
	width = ((int)1)<<mx_e->c.m->block_size[0];
	height = ((int)1)<<mx_e->c.m->block_size[1];
	rr.tl.x = 0;
	rr.tl.y = 0;
	rr.br.x = 3*width;
	rr.br.y = 3*height;

	wf_wakeup(gf);
	for ( ; ; ) {
	int all;
		set_redraw_rect(gf,&rr);
		if ( !wf_redraw(gf,&plane,
			0,0,
			3*width,3*height) )
			er_panic("spider_func");
		wf_free_plane(&plane);
		wf_status(gf,&sts);
print_sts_layer(&sts);
		ls.wf = sts.loading_status;
		wf_free_status(&sts);
		get_rc_loading_status(
			(RADAR_CACHE*)gf->radar_ptr,&ls.rc);
		if ( (all=loading_status_sum(&ls,0)) == 0 )
			break;
		wf_wakeup(gf);
ss_printf("WAIT = %i\n",all);
		sleep_sec(1);
	}
ss_printf("START ====\n");
	rc_set_status_event(gf->radar_ptr,call_rc_spider_event,&sw);
	matrix_scan_force(mx_e->c.m,MI_FETCH_1_TP,_start,_end,spider_func,&sw);
	
	wf_close(gf);
	d_f_ree(_start);
	d_f_ree(__start);
	d_f_ree(_end);
	return 0;


type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"gvImageSpider"),
		0);
/*
cannot_open:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_OPEN_FILE,
		l_string(std_cm,"gvImageSpider"),
		List(n_get_string("cannot open the file"),
			filename,
			-1));
*/
inv_param:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"gvImageSpider"),
		List(n_get_string("invalida parameter (attribute id)"),
			n_get_string(e_msg),
			-1));
/*
permission_error:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_PERMISSION_DENIED,
		l_string(std_cm,"gvImageSpider"),
		n_get_string("file path"));
*/
}

