/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___DTREE64_H___
#define ___DTREE64_H___

#include	"favt64.h"
#include	"long_char.h"

typedef struct dtree64_node {
	L_CHAR			ch;
	U_INTEGER64		tree;
	U_INTEGER64		data;
} DTREE64_NODE;

typedef struct dtree64_trace_work {
	PDB64 * 		p;
	int 			(*func)();
	void *			w;
	int 			(*trace)();
	L_CHAR *		target;
} DTREE64_TRACE_WORK;

void dtree64_endian();
FAVT64_ROOT * alloc64_dtree(PDB64 * p,int type);
U_INTEGER64 search_dtree64(int * errp,int * sizep,FAVT64_ROOT * r,L_CHAR * str,int perfect_flag);
int dtree64_trace_from_small(int * errp,FAVT64_ROOT * r,int (*func)(),void * work);
int dtree64_trace_from_large(int * errp,FAVT64_ROOT * r,int (*func)(),void * work);
int delete_dtree64(int * errp,FAVT64_ROOT * r,L_CHAR * str,U_INTEGER64 old);
int
insert_dtree64(int * errp,
	FAVT64_ROOT * r,L_CHAR * str,U_INTEGER64 old,U_INTEGER64 data);

#endif

