/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___EX_MATRIX_H___
#define ___EX_MATRIX_H___

#include	"xl.h"

typedef struct ex_matrix {
	short		h_size;
	short		v_size;
	double		d[1];
} EX_MATRIX;

#define XI(m,y,x)	((x)+(y)*(m)->h_size)
#define XD(m,y,x)	((m)->d[XI(m,y,x)])

typedef struct ex_lsm_work {
	int		from;
	int		to;
	EX_MATRIX *	m;
	EX_MATRIX *	q;
} EX_LSM_WORK;

EX_MATRIX * new_ex_matrix(int v,int h);
void free_ex_matrix(EX_MATRIX * m);
EX_MATRIX * add_ex(EX_MATRIX *,EX_MATRIX *);
EX_MATRIX * sub_ex(EX_MATRIX *,EX_MATRIX *);
EX_MATRIX * mul_ex(EX_MATRIX *,EX_MATRIX *);
double inner_ex(int * er,EX_MATRIX *,EX_MATRIX*);
EX_MATRIX * get_ex_from_sexp(XL_SEXP *);
XL_SEXP * get_sexp_from_ex(EX_MATRIX *);
EX_MATRIX * copy_ex(EX_MATRIX * org);
EX_MATRIX * ex_equation(int * erp,EX_MATRIX * m1,EX_MATRIX * m2,int copy_flag);
int ex_uppertriangle(EX_MATRIX * m1,EX_MATRIX * m2,int * index);
EX_MATRIX * ex_get_lsm(int * erp,EX_LSM_WORK * w);
EX_LSM_WORK* new_ex_lsm(int from,int to);
int ex_lsm_insert(EX_LSM_WORK * w,EX_MATRIX * p,EX_MATRIX * q);
int ex_insert_hrect(EX_MATRIX * hrect,EX_MATRIX * p);
void free_lsm(EX_LSM_WORK * w);
EX_MATRIX *
new_ex_matrix_E(int v);



#endif
