/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifndef ___GBF_H___
#define ___GBF_H___

#include	"long_char.h"

typedef struct gbf_header {
	char		signature[16];
	char		fontname[224];
	int		size;
	int		st_no;
	int		end_no;	
	int		nos;
} GBF_HEADER;

typedef struct gbf_ofs {
	short		st_x;
	short		st_y;
	short		end_x;
	short		end_y;
	short		w;
	short		type;
#define FT_SPACE 0 /* white space */
#define FT_BITMAP 1 /* 1 bit */
#define FT_GRAY 2 /* 8 bit grayscale */
	unsigned int	ofs;
} GBF_OFS;

typedef struct gbf_data {
	struct gbf_data *	next;
	GBF_OFS * ofs;

	char *		path;
	int		size;
	int		st_no;
	int		end_no;	
	int		nos;
} GBF_DATA;


typedef struct gbf_font {
	int		len;
	GBF_DATA *	dat[1];
} GBF_FONT;

void gbf_init();
void gbf_set_display_key(char * key);
GBF_DATA * gbf_search(short id);
unsigned int gbf_get_len(GBF_OFS * ofs);
/*
VDISPLAY * gbf_open_disp(VERROR * err);
*/
void gbf_get_string_pic(
	LC_STRING_PIC * p,
	int dir,
	LCF_SET * str,
	int	len);
void gbf_load(char * output_path);
int gbf_get_font(
	LC_FONT * font,
	LC_FONT_ENGINE * fe);
void gbf_init();



#endif
