/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___GBS_TRAILER_H___
#define ___GBS_TRAILER_H___


#include	"gbgraph.h"

#define TT_COLOR	1
#define TT_P2D		2
#define TT_L_P2D	3

typedef struct p2d_col_trailer {
	unsigned char	t_type;
	char		dummy1;
	short		id;
	GB_COLOR	col;
} P2D_COL_TRAILER;

typedef struct p2d_s_pt_trailer {
	char		lod_min;
	char		lod_max;
	short		no;
	GB_POINT_F	p;
} P2D_S_PT_TRAILER;

typedef struct p2d_s_trailer {
	unsigned char	t_type;
	unsigned char	type;
	short		padding_id;
	short		line_id;
	short		pnos;
	unsigned int	code;
	P2D_S_PT_TRAILER p[1];
} P2D_S_TRAILER;

typedef struct p2d_l_pt_trailer {
	char		lod_min;
	char		lod_max;
	short		dummy;
	int		no;
	GB_POINT_F	p;
} P2D_L_PT_TRAILER;

typedef struct p2d_l_trailer {
	unsigned char	t_type;
	unsigned char	type;
	short		padding_id;
	short		line_id;
	short		dummy;
	int		pnos;
	unsigned int	code;
	P2D_L_PT_TRAILER p[1];
} P2D_L_TRAILER;

typedef union trailer {
	unsigned char	t_type;
	P2D_COL_TRAILER	c;
	P2D_S_TRAILER	d_s;
	P2D_L_TRAILER	d_l;
} TRAILER;

typedef struct p2d_t_set {
	TRAILER *	trailer;
	int		size;
	TRAILER *	next;
} P2D_T_SET;

#define P2D_TRAILER_S_PT_SIZE(pn)	\
	((int)(&(((P2D_S_TRAILER*)0)->p[pn])))
#define P2D_TRAILER_L_PT_SIZE(pn)	\
	((int)(&(((P2D_L_TRAILER*)0)->p[pn])))

void
set_s_p2d_trailer(P2D_T_SET * set,int pnos);
void
set_l_p2d_trailer(P2D_T_SET * set,int pnos);
void
get_trailer(P2D_T_SET * set);
void
change_endian_col_trailer(P2D_COL_TRAILER * t);
void
change_endian_trailer_to_net(TRAILER * t);
void
change_endian_trailer_to_host(TRAILER * t);
void
get_s_p2d_trailer(P2D_T_SET * set);
void
get_l_p2d_trailer(P2D_T_SET * set);
void
get_col_trailer(P2D_T_SET * set);

#endif

