/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___NETMAPPER_H___
#define ___NETMAPPER_H___

#include	"avt.h"
#include	"xl.h"
#include	"gbgraph.h"

#define DEFAULT_TARGET_PITCH	0.00000001
//#define DEFAULT_TARGET_PITCH	0.0004
#define MAX_PITCH		2
#define PA_LEVEL		1
#define NB_LEVEL		3
#define LOOP_TIME		2
#define TINS_NOS		300
#define DELTA_PITCH		0.001
//#define DELTA_PITCH 10.0

typedef struct nm_edge_v {
	struct nm_edge_v *	next;
	struct nm_vertex *	v;
	struct nm_edge *	this;
} NM_EDGE_V;

typedef struct nm_edge {
	NM_EDGE_V		ev[2];
} NM_EDGE;

typedef struct name_ptr {
	double		x;
	double		y;
} NAME_PTR;

typedef struct nm_vertex {
	struct nm_vertex *	next;
	int			size;
	void *			name;
	NM_EDGE_V *		edge;
	struct nm_vertex *	co;
	struct nm_vertex *	loop_next;
	int			flags;
#define VF_LOOP		0x00000001
} NM_VERTEX;

typedef struct nm_target {
	NM_VERTEX *		vertex;
	short			name_type;
#define NMT_PTR		1
#define NMT_STR		2
	int			(*avt_cmp)();
	AVT_NODE *		tree;
	double			tolerance;
} NM_TARGET;

typedef struct nm_loop {
	struct nm_loop *	loop_next;
	struct nm_loop *	next;
	NM_VERTEX *		v;
	int			length;
	struct nm_loop *	work_next;
} NM_LOOP;

typedef struct backup_header {
	int			type;
} BACKUP_HEADER;

#define BT_EDGE		0

typedef struct backup_vertex {
	int			type;
#define BT_VERTEX	1
	NAME_PTR		ptr;
} BACKUP_VERTEX;


typedef struct netlist_src {
	struct netlist_src *	next;
	L_CHAR *		fileheader;
	L_CHAR *		filename;
	GB_POINT		ptr;
	unsigned		floating:1;
} NETLIST_SRC;

typedef struct netlist_vertex {
	struct netlist_vertex *	next;
	int			opt_no;
	L_CHAR *		point_name;
	NETLIST_SRC *		src_list;
	int			plist_ofs;
	unsigned		valid:2;
#define VV_NOTUSE		0
#define VV_USE			1
#define VV_LOCK			2
#define VV_NEW			3
#define VV_MAX			4
} NETLIST_VERTEX;

typedef struct netlist_tin {
	struct netlist_tin *	next;
	unsigned		save_flag:1;
	NETLIST_VERTEX *	vertex[3];
	NETLIST_SRC *		selects[3];
	double			pseudo_angle;
	double			t1;
	double			t2;
	int			rf;
	AFFEN2D			a;
	double			dr[3];
	double			od;
	double			od2;
	struct netlist_tin *	nh[3];
	NETLIST_VERTEX *	nh_v1[3];
	NETLIST_VERTEX *	nh_v2[3];
	unsigned		od2_flag:1;
	unsigned		nh_flag:1;
} NETLIST_TIN;

typedef struct netlist_work {
	NETLIST_TIN *		tins;
	NETLIST_VERTEX *	vertex;
	L_CHAR *		src_filename_before;
	L_CHAR *		src_filename_after;
	L_CHAR *		dest_filename;
	L_CHAR *		save_dir;
	L_CHAR *		fileheader;
	REAL1			target_pitch;

	int			total_vertex;
	int			valid_tin;
	
	double			max_dist;
	double			dist;
	int			dist_cnt;
	double			radius;
	int			_radius;
	GB_POINT		center;
	
	double			max;
	NETLIST_TIN *		reverse;
	
	unsigned		floating:1;
} NETLIST_WORK;

typedef struct netlist_point_list {
	struct netlist_point_list *	next;
	L_CHAR *			name;
} NETLIST_POINT_LIST;

void init_target(NM_TARGET * t,short name_type);
NM_VERTEX * new_vertex(NM_TARGET * t,void * name,int size);
NM_EDGE * new_edge(NM_TARGET * t,NM_VERTEX * p1,NM_VERTEX * p2);
void clean_ve(NM_TARGET * t);
XL_SEXP * output_mapping();

extern NM_TARGET net_target[];
extern int loading_target;
extern int backup_fid;

void	init_svg_path(XLISP_ENV*);

#endif
