/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___V_DISPLAY_H___
#define ___V_DISPLAY_H___

#include "v/VObject.h"


class VDisplay : public VObject
{
  public:
	enum { object_type = 0 };
	virtual unsigned	get_type() const { return object_type; }
	virtual unsigned	max_children() const { return MAX_CHILDREN_NO_LIMIT; }
	
	static VDisplay*	create();
	
	static VDisplay *	get_main_display() { return main_display; }
	
  protected :
	virtual ~VDisplay();
	
	virtual VExError	create_do(const VObjectStatus *, int flags,
					VObject * nmp, void * arg);
	virtual void	destroy_do(VObject*);
	
	virtual VError	accept_child_ex(long type, VObject* obj) const;
	
	static VDisplay *	main_display;
};

#endif
