/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___V_WINDOW_H___
#define ___V_WINDOW_H___

#include "v/VDisplay.h"
#include "v/VMenu.h"

typedef struct dialog_io {
	const char*		type;
#define DIO_MSG_LEN			2
#define DIO_RMSG_LEN			2
	L_CHAR *		msg[DIO_MSG_LEN];
	int			ret;
#define DIO_ERR			(-1)
#define DIO_UNKNOWN		(-2)
#define DIO_NONE		0
#define DIO_OK			1
#define DIO_CANCEL		2
#define DIO_SAVE		3
#define DIO_DONTSAVE		4
#define DIO_MAX			5
	L_CHAR *		ret_msg[DIO_RMSG_LEN];
	void *			work;
	void			(*pre_func)(struct dialog_io *,XL_SEXP *);
	void			(*post_func)(struct dialog_io *,XL_SEXP *);
} DIALOG_IO;

extern "C" {
extern VWindow * window_list;
}

class VWindow : public VObject
{
  public:
	enum { object_type = VO_WIND };
	virtual unsigned	get_type() const { return object_type; }
	virtual unsigned	max_children() const { return 1; }
	
	enum VWindowAttr {
		resizable = 0x1,
		floating = 0x2,
		modal = 0x4
	};

	static VWindow*	create(const VObjectStatus *s, int flags, int category=0, VExError *err=0) {
		VObjectStatus ns = s ? *s : v_default_sts;
		ns.parent = VDisplay::get_main_display();
		return static_cast<VWindow*>(
			create_tmp(internal_new, object_type, &ns, flags|VSF_PARENT, err, &category));
	}
	static VWindow*	create(const VObjectStatus *s, int flags, void *arg, VExError *err) {
		return create(s, flags, *(int*)arg, err);
	}
	
	virtual VExError	get_status(VObjectStatus *, int flags) const;
	virtual VExError	set_status(const VObjectStatus *, int flags);
	
	virtual void	child_status_changed(VObject *child, VInfo* info);
	
	virtual void	redraw(VRect* rect=0) const;
	
	virtual void	set_window_close_handler(V_CALLBACK(handler), void* user_arg) {
		window_close_handler = handler;
		this->user_arg = user_arg;
	}
	virtual void	get_window_close_handler(V_CALLBACK((*handler)), void** user_arg) {
		*handler = window_close_handler;
		*user_arg = this->user_arg;
	}
	virtual bool	attempt_close();	// called from OS on clicking close box
	
	virtual void	win_dialog(DIALOG_IO*io);
	
	int				get_category() { return category; }
/*
	VCustomizedMenuBar *	get_menu_bar() { 
		return menu_bar;
	}
*/
	VCustomizedMenuBar *	get_menu_bar();

	void
	refresh_menu_bar(int c);
	void
	_refresh_menu_bar_func(int c);
	void _refresh_menu_bar();
	void insert_window_list();
	void delete_window_list();
		
	virtual VExError add_child_do(VObject* child);
	virtual void	remove_child_do(VObject* child);

	static void close_all_window()
	{
	VWindow * win;
		for ( ; ; ) {
			win = window_list;
			if ( win == 0 )
				break;
			win->destroy();
		}
	}

  protected:
	virtual ~VWindow();
	
	virtual VExError	create_do(const VObjectStatus *, int flags,
					VObject * nmp, void * arg);
	virtual void	destroy_do(VObject*);
	
	V_CALLBACK	(window_close_handler);
	void*	user_arg;
	// callback for window attempt close. If sholdn't close,
	// just return, otherwise perform destroy.
	
	int				category;
	VCustomizedMenuBar *	menu_bar;
	VWindow *		wlist_next;
	VWindow *		wlist_prev;
	
	
  private:
	static VObject *internal_new(){
		return new VWindow();
	}
};

#endif
