/**********************************************************************
 
	Copyright (C) 2007- Hirohisa MORI <joshua@globalbase.org>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include "machine/include.h"
/*
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include <unistd.h>
*/
#include	"geo.h"
#include	"change_endian.h"
#include	"u_file.h"

void
str_mid(char *dest,char *source,int num1,int num2);
void
str_right(char *dest,char *source,int num);



int load_dted2(short * data,int * org_east,int * org_north,
		char *dir_name,char *filename,int flag)

{
	short	dem1;
	int	sec;
	int	org_n,org_e;
	char	fnm[20];
	int	i,j;
	char 	path[127];
	short * dp;

	int dir_name_len;

	int 	fp1;

	sec= 3;


	dir_name_len = strlen(dir_name);
	if ( dir_name_len < 4 )
		return -1;

	org_e = atoi(&dir_name[dir_name_len-3])*3600;
	switch ( dir_name[dir_name_len-4] ) {
	case 'e':
	case 'E':
		break;
	case 'w':
	case 'W':
		org_e = -org_e;
		break;
	default:
		return -2;
	}

	if ( !((strcmp(&filename[3],".dt1") == 0) ||
		(strcmp(&filename[3],".dt2") == 0)) )
		return -3;

	memcpy(fnm,filename,5);
	fnm[3] = 0;
	org_n = (atoi(&fnm[1])+1)*3600;
	switch ( fnm[0] ) {
	case 'n':
	case 'N':
		break;
	case 's':
	case 'S':
		org_n = -org_n;
		break;
	default:
		return -4;
	}

	*org_east = org_e;
	*org_north = org_n;
	if ( flag )
		return 0;

	strcpy(path,dir_name);
	strcpy(&path[dir_name_len],"/");
	strcpy(&path[dir_name_len+1],filename);

	fp1 = u_open64(path,O_RDONLY);
	if ( fp1 < 0 )
		return -5;

	u_lseek64(fp1,3429,SEEK_SET);

	dp = data;
	for (i=0; i<1201; i++) {
//		n = org_n + (sec * i);

       		u_lseek64(fp1, 8L, SEEK_CUR);

		for (j=0; j<1201; j++) {
//			e = org_e + (sec * j);

			u_read(fp1,&dem1, 2);
			change_endian(dem1);

 			if ( dem1 < 0 ) {
				dem1 &= 0x7fff;
				dem1 = -dem1;
			}

//			printf("%.9f %.9f %.1f \n",n,e,(double)dem2);
			
			*dp++ = dem1;
		}
		u_lseek64(fp1, 4L, SEEK_CUR);

	}
	u_close( fp1 );
	return 0;
}
