/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"utils.h"
#include	"long_char.h"

extern CODE_METHOD euc_cm, jis_cm,sjis_cm;


CODE_METHOD *
get_encoding(L_CHAR * _code)
{
L_CHAR * code;
CODE_METHOD * ret;
L_CHAR * p;
	if ( _code == 0 )
		return 0; 
	code = ll_copy_str(_code);
	for ( p = code ; *p ; p ++ ) {
		if ( 'a' <= *p && *p <= 'z' )
			*p += 'A' - 'a';
	}
	if ( l_strcmp(code,l_string(std_cm,"SHIFT_JIS")) == 0 )
		ret = &sjis_cm;
	else if ( l_strcmp(code,l_string(std_cm,"SHIFT-JIS")) == 0 )
		ret = &sjis_cm;
	else if ( l_strcmp(code,l_string(std_cm,"EUC")) == 0 )
		ret = &euc_cm;
	else if ( l_strcmp(code,l_string(std_cm,"EUC-JP")) == 0 )
		ret = &euc_cm;
	else if ( l_strcmp(code,l_string(std_cm,"JIS")) == 0 )
		ret = &jis_cm;
	else if ( l_strcmp(code,l_string(std_cm,"UTF-8")) == 0 )
		ret = &utf8_cm;
	else	ret = 0;
	return ret;
}

