/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef GM_COASTLINE_LFT_H___
#define GM_COASTLINE_LFT_H___

#include "vpf_table.h"

typedef struct {
	LONG id;
	char f_code[6];
	SHORT acc;
	SHORT exs;
	char soc[4];
	SHORT tile_id;
	LONG edg_id;
}GM_COAST_LINE_LFT_RECORD;

void gm_coast_line_lft_delete(GM_COAST_LINE_LFT_RECORD *record);
BOOL gm_coast_line_lft_read(VPF_TABLE *table, FILE *fp, VPF_LIST *cols_info);
LONG gm_coast_line_lft_get_tileid(const GM_COAST_LINE_LFT_RECORD *record);
LONG gm_coast_line_lft_get_edge_id(const GM_COAST_LINE_LFT_RECORD *record);
void gm_coast_line_lft_write_information_tag(FILE *fp, const GM_COAST_LINE_LFT_RECORD *record);
#endif


