/**********************************************************************
 
	Copyright (C) 2005- Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"machine/include.h"
#include	"memory_debug.h"
#include	"pri_level.h"
#include	"lock_level.h"
#include	"utils.h"
#include	"task.h"
#include	"matrix.h"
#include	"xl.h"
#include	"xlerror.h"
#include	"memory_routine.h"
#include	"xl_zlib.h"


XL_SEXP *
xl_mxCompressZ(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf);
void * mx_glay_compress_1(int * ,MATRIX_DH_SET * d1);
void * mx_glay_compress_2(int * ,MATRIX_DH_SET * d1);
void * mx_jpeg_compress_1(int * ,MATRIX_DH_SET * d1);
void * mx_jpeg_compress_2(int * ,MATRIX_DH_SET * d1);

void gc_tick_notin_tick();

void
init_mxCompressZ(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"mxCompressZ"),
		get_func_prim(xl_mxCompressZ,FO_APPLICATIVE,0,2,2));
}



XL_SEXP *
xl_mxCompressZ(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
void * d1;
MATRIX_DH_SET ds;
MATRIX_ALLOC_BLOCK_PARAM * bp;
MATRIX_TOKEN * t;
XL_SEXP * ret;
void * d;
MATRIX_ALLOC_BLOCK_PARAM p;
L_CHAR * _opt;
int opt;
RECORD_LIST64 * rl;
int size;

	t = get_env_work(env);
	if ( t == 0 )
		return 0;
		

	_opt = get_sf_attribute(sf,l_string(std_cm,"opt"));
	if ( _opt == 0 )
		opt = 7;
	else	opt = atoi(n_string(std_cm,_opt));

	d1 = get_vdata_from_sexp(get_el(get_el(s,1),2));

	if ( d1 == 0 )
		goto inv_param;
		
	ds.hd = d1;
	switch ( ds.hd->type ) {
	case MDT_BLOCK:
		bp = d1;
		rl = new_recordlist64(0,0);
		set_recordlist_chain64(rl,&bp->h.type,sizeof(bp->h.type),0);
		set_recordlist_chain64(rl,bp->block,bp->size,0);
		break;
	default:
		get_matrix_dh_set(&ds,d1);
		rl = new_recordlist64(0,0);
		set_recordlist_chain64(rl,&ds.hd->type,sizeof(ds.hd->type),0);
		(*ds.tp->convert_to_net)(
			ds.tp,rl,d1);
		break;
	}
	size = setup_recordlist64(rl);
	p.block = zlib_compress(
		&p.size,
		rl->data,
		size,
		opt);
	free_recordlist64(rl);

	d = (*mx_type_block.alloc_data)(&mx_type_block,MD_MMALLOC,&p,0,
			__FILE__,__LINE__);
	d_f_ree(p.block);

	ret = List(
		n_get_symbol("data"),
		get_sexp_from_dim_code(t->process_node->matrix,t->process_node->dim_code),
		get_ptr(d,gc_mtx_block),
		-1);
	goto end;
/*
type_missmatch:
	ret = get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"mxCompressZ"),
		0);
	goto end;
*/
inv_param:
	ret = get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"mxCompressZ"),
		n_get_string("invalid parameter in mxCompressZ"));
	goto end;
end:

	return ret;
}





