/**********************************************************************
 
	Copyright (C) 2007 Hirohisa MORI <joshua@globalbase.org>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"change_endian.h"
#include	"memory_debug.h"
#include	"recordlist64.h"
#include	"matrix.h"
#include	"pg_vector.h"
#include	"xlerror.h"
#include	"xl_zlib.h"
#include	"memory_routine.h"
#include	"simple_alloc.h"
#include	"geo.h"

void
check_mem_list(char*);
void
gc_tick_notin_tick();

int
fd_initial_none(IP_FIELD * d1,void*,void *,int);
void
fd_copy_none(IP_FIELD * d1,IP_FIELD* d2,SIMPLE_ALLOC_T * sat);
void
fd_merge_none(IP_FIELD * dest,IP_FIELD * src1,IP_FIELD * src2);
void
fd_diff_none(IP_FIELD * dest,IP_FIELD * up,IP_FIELD * down);
void
fd_add_none(IP_FIELD * dest,IP_FIELD * up,IP_FIELD * diff,SIMPLE_ALLOC_T * sat);
unsigned char *
fd_to_internal_none(IP_FIELD * dest,unsigned char * p,SIMPLE_ALLOC_T * sat);
unsigned char *
fd_to_external_none(IP_FIELD * src,unsigned char * p);
int fd_size_none(IP_FIELD * d1);
int fd_cmp_none(IP_FIELD * d1,IP_FIELD * d2);


int
fd_initial_str(IP_FIELD * d1,void*,void *,int);
void
fd_copy_str(IP_FIELD * d1,IP_FIELD* d2,SIMPLE_ALLOC_T * sat);
void
fd_merge_str(IP_FIELD * dest,IP_FIELD * src1,IP_FIELD * src2);
void
fd_diff_str(IP_FIELD * dest,IP_FIELD * up,IP_FIELD * down);
void
fd_add_str(IP_FIELD * dest,IP_FIELD * up,IP_FIELD * diff,SIMPLE_ALLOC_T * sat);
unsigned char *
fd_to_internal_str(IP_FIELD * dest,unsigned char * p,SIMPLE_ALLOC_T * sat);
unsigned char *
fd_to_external_str(IP_FIELD * src,unsigned char * p);
int fd_size_str(IP_FIELD * d1);
void fd_gc_str(FD_OPT * p);
int fd_cmp_str(IP_FIELD * d1,IP_FIELD * d2);

int
fd_initial_int(IP_FIELD * d1,void*,void *,int);
void
fd_copy_int(IP_FIELD * d1,IP_FIELD* d2,SIMPLE_ALLOC_T * sat);
void
fd_merge_int(IP_FIELD * dest,IP_FIELD * src1,IP_FIELD * src2);
void
fd_diff_int(IP_FIELD * dest,IP_FIELD * up,IP_FIELD * down);
void
fd_add_int(IP_FIELD * dest,IP_FIELD * up,IP_FIELD * diff,SIMPLE_ALLOC_T * sat);
unsigned char *
fd_to_internal_int(IP_FIELD * dest,unsigned char * p,SIMPLE_ALLOC_T * sat);
unsigned char *
fd_to_external_int(IP_FIELD * src,unsigned char * p);
int fd_size_int(IP_FIELD * d1);
int fd_cmp_int(IP_FIELD * d1,IP_FIELD * d2);



int
fd_initial_rgba(IP_FIELD * d1,void*,void *,int);
void
fd_copy_rgba(IP_FIELD * d1,IP_FIELD* d2,SIMPLE_ALLOC_T * sat);
void
fd_merge_rgba(IP_FIELD * dest,IP_FIELD * src1,IP_FIELD * src2);
void
fd_diff_rgba(IP_FIELD * dest,IP_FIELD * up,IP_FIELD * down);
void
fd_add_rgba(IP_FIELD * dest,IP_FIELD * up,IP_FIELD * diff,SIMPLE_ALLOC_T * sat);
unsigned char *
fd_to_internal_rgba(IP_FIELD * dest,unsigned char * p,SIMPLE_ALLOC_T * sat);
unsigned char *
fd_to_external_rgba(IP_FIELD * src,unsigned char * p);
int fd_size_rgba(IP_FIELD * d1);
int fd_cmp_rgba(IP_FIELD * d1,IP_FIELD * d2);



FIELD_TYPE field_type_tbl[] = {
	{0,0,0,0,0,0,0,0,0},
	{	fd_initial_none,
		fd_copy_none,
		fd_merge_none,
		fd_diff_none,
		fd_add_none,
		fd_to_internal_none,
		fd_to_external_none,
		fd_size_none,
		fd_cmp_none,
		0},

	{	fd_initial_str,
		fd_copy_str,
		fd_merge_str,
		fd_diff_str,
		fd_add_str,
		fd_to_internal_str,
		fd_to_external_str,
		fd_size_str,
		fd_cmp_str,
		fd_gc_str},

	{	fd_initial_int,
		fd_copy_int,
		fd_merge_int,
		fd_diff_int,
		fd_add_int,
		fd_to_internal_int,
		fd_to_external_int,
		fd_size_int,
		fd_cmp_int,
		0},

	{	fd_initial_rgba,
		fd_copy_rgba,
		fd_merge_rgba,
		fd_diff_rgba,
		fd_add_rgba,
		fd_to_internal_rgba,
		fd_to_external_rgba,
		fd_size_rgba,
		fd_cmp_rgba,
		0}
};


/* TYPE NONE */

int
fd_initial_none(IP_FIELD * target,void* data,void * w,int flag)
{
FD_NONE_OPT * opt;
	if ( target == 0 ) {
		opt = (FD_NONE_OPT*)w;
		opt->h.merge_type = CH_TYPE_NONE;
		return 0;
	}
	target->d.str = 0;
	return 0;
}

void
fd_copy_none(IP_FIELD * d1,IP_FIELD* d2,SIMPLE_ALLOC_T * sat)
{
	d1->type = d2->type;
	d1->d.str = 0;
}


void
fd_merge_none(IP_FIELD * dest,IP_FIELD * src1,IP_FIELD * src2)
{
	dest->type = CH_NONE;
	dest->d.str = 0;
	return;
}


void
fd_diff_none(IP_FIELD * dest,IP_FIELD * up,IP_FIELD * down)
{
	dest->type = CH_NONE;
	dest->d.str = 0;
}

void
fd_add_none(IP_FIELD * dest,IP_FIELD * up,IP_FIELD * diff,SIMPLE_ALLOC_T * sat)
{
	dest->type = CH_NONE;
	dest->d.str = 0;
}

unsigned char *
fd_to_internal_none(IP_FIELD * dest,unsigned char * p,SIMPLE_ALLOC_T * sat)
{
	return p+1;
}

unsigned char *
fd_to_external_none(IP_FIELD * src,unsigned char * p)
{
	return p;
}

int fd_size_none(IP_FIELD * d1)
{
	return 0;
}


int fd_cmp_none(IP_FIELD * d1,IP_FIELD * d2)
{
	return 0;
}


/* TYPE STRING */

int
fd_initial_str(IP_FIELD * target,void* _data,void * opt,int flag)
{
FD_STR_OPT * _opt;
CODE_METHOD * cm;
STREAM * st;
XL_SEXP * encode;
XL_SEXP * data;
L_CHAR * dstr;


//ss_printf("fd_initial_str\n");
	if ( target == 0 ) {
		data = (XL_SEXP*)_data;
		_opt = (FD_STR_OPT*)opt;
		if ( get_type(data) != XLT_PAIR )
			return -1;
		encode = get_el(data,0);
		if ( get_type(encode) != XLT_STRING )
			return -2;
		cm = search_cm(n_string(std_cm,encode->string.data));
		if ( cm == 0 )
			return -4;
		if ( get_type(get_el(data,1)) != XLT_NULL )
			_opt->convert = get_el(data,1);
		else	_opt->convert = 0;
		_opt->cm = cm;
		_opt->h.merge_type = CH_TYPE_STRING;
		if ( list_length(data) == 3 )
			_opt->h.init_sexp = get_el(data,2);
		return 0;
	}
	_opt = (FD_STR_OPT*)opt;
	if ( opt )
		cm = _opt->cm;
	else	cm = &utf8_cm;
	if ( flag ) {
		dstr = (L_CHAR *)_data;
		if ( dstr == 0 ) {
			target->type = CH_STRING_ERASE;
			target->d.str = 0;
		}
		else {
			target->type = CH_STRING;
			target->d.str = ln_copy_str(cm,code_convert_with_combine(
					dstr,
					l_strlen(dstr),
					cm->main_code,
					CBF_SRC_PLANE|CBF_DST_PLANE));
//ss_printf("CONV = %s\n",target->d.str);
		}
	}
	else {
		data = (XL_SEXP*)_data;
		switch ( get_type(data) ) {
		case XLT_NULL:
			target->type = CH_STRING_ERASE;
			target->d.str = 0;
			break;
		default:
			gc_push(0,0,"fd_initial_str");
			if ( _opt->convert ) {
			XLISP_ENV * env;
				env = new_env(gblisp_top_env0);
				set_env(env,l_string(std_cm,"___convert"),
					data);
				data = eval(env,_opt->convert);
				if ( get_type(data) == XLT_ERROR ) {
/*
print_sexp(s_stdout,data,0);
ss_printf("\n");
*/
					gc_pop(0,0);
					return -1;
				}
			}
			target->type = CH_STRING;
			if ( get_type(data) == XLT_STRING ) {

				target->d.str = ln_copy_str(cm,code_convert_with_combine(
					data->string.data,
					l_strlen(data->string.data),
					cm->main_code,
					CBF_SRC_PLANE|CBF_DST_PLANE));
//ss_printf("CONV = %ls\n",target->d.str);
			}
			else {
				st = s_open_string_write(cm);
				print_sexp(st,convert_code(data,cm->main_code,CBF_ERR_KEEP),0);
				target->d.str = copy_str(s_get_string(st));
				s_close(st);
			}
			gc_pop(0,0);
			break;
		}
	}
	return 0;
}


char *
sat_copy_str(char * str,SIMPLE_ALLOC_T * sat)
{
char * ret;
	if ( str == 0 )
		return 0;
	if ( sat ) {
		ret = smp_alloc(sat,strlen(str)+1);
		strcpy(ret,str);
		return ret;
	}
	else {
		return copy_str(str);
	}
}

void
fd_copy_str(IP_FIELD * d1,IP_FIELD* d2,SIMPLE_ALLOC_T * sat)
{
	d1->type = d2->type;
	switch ( d1->type ) {
	case CH_STRING:
		d1->d.str = sat_copy_str(d2->d.str,sat);
		break;
	case CH_STRING_INHERIT:
	case CH_STRING_ERASE:
		d1->d.str = 0;
		break;
	default:
		er_panic("fd_copy_Str");
	}
}

void
fd_merge_str(IP_FIELD * dest,IP_FIELD * src1,IP_FIELD * src2)
{
	switch ( src1->type ) {
	case CH_STRING:
		switch ( src2->type ) {
		case CH_STRING:
			if ( strcmp(src1->d.str,src2->d.str) == 0 ) {
				dest->type = CH_STRING;
				dest->d.str = copy_str(src1->d.str);
			}
			else {
				dest->type = CH_STRING_ERASE;
				dest->d.str = 0;
			}
			break;
		case CH_STRING_ERASE:
			dest->type = CH_STRING_ERASE;
			dest->d.str = 0;
			break;
		default:
			er_panic("fd_merge_str");
		}
		break;
	case CH_STRING_ERASE:
		dest->type = CH_STRING_ERASE;
		dest->d.str = 0;
		break;
	default:
		er_panic("fd_merge_str");
	}
}

void
fd_diff_str(IP_FIELD * dest,IP_FIELD * up,IP_FIELD * down)
{
	switch ( up->type ) {
	case CH_STRING:
		switch ( down->type ) {
		case CH_STRING:
			if ( strcmp(up->d.str,down->d.str) == 0 ) {
				dest->type = CH_STRING_INHERIT;
				dest->d.str = 0;
			}
			else {
				dest->type = CH_STRING;
				dest->d.str = copy_str(down->d.str);
			}
			break;
		case CH_STRING_ERASE:
			dest->type = CH_STRING_ERASE;
			dest->d.str = 0;
			break;
		default:
			er_panic("fd_diff_str");
		}
		break;
	case CH_STRING_ERASE:
		switch ( down->type ) {
		case CH_STRING:
			dest->type = CH_STRING;
			dest->d.str = copy_str(down->d.str);
			break;
		case CH_STRING_ERASE:
			dest->type = CH_STRING_ERASE;
			dest->d.str = 0;
			break;
		default:
			er_panic("fd_diff_str");
		}
		break;
	default:
		er_panic("fd_diff_str");
	}
}

void
fd_add_str(IP_FIELD * dest,IP_FIELD * up,IP_FIELD * diff,SIMPLE_ALLOC_T * sat)
{
//ss_printf("FD_ADD_STR %x %x\n",up->type,diff->type);
	switch ( up->type ) {
	case CH_STRING:
		switch ( diff->type ) {
		case CH_STRING:
			dest->type = CH_STRING;
			dest->d.str = sat_copy_str(diff->d.str,sat);
//ss_printf("FD_ADD_STR %s\n",dest->d.str);
			break;
		case CH_STRING_ERASE:
			dest->type = CH_STRING_ERASE;
			dest->d.str = 0;
			break;
		case CH_STRING_INHERIT:
			dest->type = CH_STRING;
			dest->d.str = sat_copy_str(up->d.str,sat);
//ss_printf("FD_ADD_STR %s\n",dest->d.str);
			break;
		default:
			er_panic("fd_add_str");
		}
		break;
	case CH_STRING_ERASE:
		switch ( diff->type ) {
		case CH_STRING:
			dest->type = CH_STRING;
			dest->d.str = sat_copy_str(diff->d.str,sat);
//ss_printf("FD_ADD_STR %s\n",dest->d.str);
			break;
		case CH_STRING_ERASE:
		case CH_STRING_INHERIT:
			dest->type = CH_STRING_ERASE;
			dest->d.str = 0;
			break;
		default:
			er_panic("fd_add_str");
		}
		break;
	default:
		er_panic("fd_add_str");
	}
}

unsigned char *
fd_to_internal_str(IP_FIELD * dest,unsigned char * p,SIMPLE_ALLOC_T * sat)
{
int len;
unsigned char type;
	type = *p;
	p ++;
	switch ( type ) {
	case CH_STRING:
		len = strlen((char*)p);
		if ( dest ) {
			dest->d.str = sat_alloc(len+1,sat);
			strcpy(dest->d.str,(char*)p);
		}
		p += len+1;
		return p;
	case CH_STRING_ERASE:
	case CH_STRING_INHERIT:
		if ( dest )
			dest->d.str = 0;
		return p;
	default:
		er_panic("fd_to_internal_str");
		return 0;
	}
}

unsigned char *
fd_to_external_str(IP_FIELD * src,unsigned char * p)
{
int len;
	switch ( src->type ) {
	case CH_STRING:
		len = strlen(src->d.str);
		strcpy((char*)p,src->d.str);
		p += len+1;
		return p;
	case CH_STRING_ERASE:
	case CH_STRING_INHERIT:
		return p;
	default:
		er_panic("fd_to_external_str");
		return 0;
	}
}

int
fd_size_str(IP_FIELD * d1)
{
	switch ( d1->type ) {
	case CH_STRING:
		return strlen(d1->d.str)+1;
	case CH_STRING_ERASE:
	case CH_STRING_INHERIT:
		return 0;
	default:
		er_panic("fd_size_str");
		return 0;
	}
}

void
fd_gc_str(FD_OPT * p)
{
	gc_gb_sexp(((FD_STR_OPT*)p)->convert);
}


int fd_cmp_str(IP_FIELD * d1,IP_FIELD * d2)
{
int ret;
	if ( d1->type > d2->type )
		return 1;
	if ( d1->type < d2->type )
		return -1;
	switch ( d1->type ) {
	case CH_STRING:
		ret = strcmp(d1->d.str,d2->d.str);
		if ( ret < 0 )
			return -1;
		if ( ret > 0 )
			return 1;
		return 0;
	case CH_STRING_INHERIT:
	case CH_STRING_ERASE:
		return 0;
	default:
		return 0;
	}
}

/* TYPE INTEGER64 */

int
fd_initial_int(IP_FIELD * target,void * _d,void * w,int flag)
{
FD_INT_OPT * opt;
INTEGER64 data;
double _data;
XL_SEXP * reso,*count,*type,*offset;
XL_SEXP * d;
L_CHAR * dstr;
	if ( target == 0 ) {
		d = (XL_SEXP*)_d;
		if ( list_length(d) < 4 )
			return -1;
		opt = (FD_INT_OPT*)w;
		type = get_el(d,0);
		reso = get_el(d,1);
		offset = get_el(d,2);
		count = get_el(d,3);
		switch ( get_type(type) ) {
		case XLT_INTEGER:
			opt->type = type->integer.data;
			break;
		default:
			return -2;
		}
		switch ( get_type(reso) ) {
		case XLT_INTEGER:
			opt->reso = reso->integer.data;
			break;
		case XLT_FLOAT:
			opt->reso = reso->floating.data;
			break;
		default:
			return -3;
		}
		switch ( get_type(offset) ) {
		case XLT_INTEGER:
			opt->offset = offset->integer.data;
			break;
		case XLT_FLOAT:
			opt->offset = offset->floating.data;
			break;
		default:
			return -9;
		}
		switch ( get_type(count) ) {
		case XLT_INTEGER:
			opt->count = count->integer.data;
			break;
		default:
			return -4;
		}
		if ( list_length(d) == 5 )
			opt->h.init_sexp = get_el(d,4);
		return 0;
	}
	opt = (FD_INT_OPT*)w;
	if ( flag ) {
		dstr = (L_CHAR*)_d;
		switch ( opt->type ) {
		case FDIT_INT:
			sscanf(n_string(std_cm,dstr),I64_FORMAT,&data);
			data = data * opt->reso + opt->offset;
			break;
		case FDIT_FLOAT:
		case FDIT_DD:
			sscanf(n_string(std_cm,dstr),"%lf",&_data);
			data = _data * opt->reso + opt->offset;
			break;
		case FDIT_DDMMSS:
			sscanf(n_string(std_cm,dstr),"%lf",&_data);
			data = ddmmss_int(_data) * opt->reso + opt->offset;
			break;
		default:
			return -7;
		}
	}
	else {
		d = (XL_SEXP*)_d;
		switch ( get_type(d) ) {
		case XLT_FLOAT:
			switch ( opt->type ) {
			case FDIT_INT:
			case FDIT_FLOAT:
			case FDIT_DD:
				data = d->floating.data * opt->reso + opt->offset;
				break;
			case FDIT_DDMMSS:
				data = ddmmss_float(d->floating.data) * opt->reso + opt->offset;
				break;
			default:
				return -5;
			}
			break;
		case XLT_INTEGER:
			switch ( opt->type ) {
			case FDIT_INT:
			case FDIT_FLOAT:
			case FDIT_DD:
				data = d->integer.data * opt->reso + opt->offset;
				break;
			case FDIT_DDMMSS:
				data = ddmmss_int(d->integer.data) * opt->reso + opt->offset;
				break;
			default:
				return -6;
			}
			break;
		case XLT_STRING:
			switch ( opt->type ) {
			case FDIT_INT:
				sscanf(n_string(std_cm,d->string.data),I64_FORMAT,&data);
				data = data * opt->reso + opt->offset;
				break;
			case FDIT_FLOAT:
			case FDIT_DD:
				sscanf(n_string(std_cm,d->string.data),"%lf",&_data);
				data = _data * opt->reso + opt->offset;
				break;
			case FDIT_DDMMSS:
				sscanf(n_string(std_cm,d->string.data),"%lf",&_data);
				data = ddmmss_int(_data) * opt->reso + opt->offset;
				break;
			default:
				return -7;
			}
			break;
		default:
			return XLE_SEMANTICS_TYPE_MISSMATCH;
		}
	}
	target->type = opt->h.merge_type;
	switch ( target->type ) {
	case CH_TYPE_INT:
		if ( opt->h.dim < 0 )
			return -9;
		target->d.i = d_alloc(sizeof(INTEGER64));
		target->d.i[0] = data;
		break;
	case CH_INT_ADD:
	case CH_INT_MIN:
	case CH_INT_MAX:
		target->d.i = d_alloc(sizeof(INTEGER64));
		target->d.i[0] = data;
		break;
	case CH_INT_AVG:
		target->d.i = d_alloc(sizeof(INTEGER64)*2);
		target->d.i[0] = data;
		target->d.i[1] = opt->count;
		break;
	default:
		return -8;
	}
	return 0;
}

void
fd_copy_int(IP_FIELD * d1,IP_FIELD* d2,SIMPLE_ALLOC_T * sat)
{
int size;
	d1->type = d2->type;
	if ( d2->type != CH_INT_AVG )
		size = sizeof(INTEGER64);
	else	size = sizeof(INTEGER64)*2;
	d1->d.i = sat_alloc(size,sat);
	memcpy(d1->d.i,d2->d.i,size);
}


void
fd_merge_int(IP_FIELD * dest,IP_FIELD * src1,IP_FIELD * src2)
{
	if ( src1->type != src2->type )
		er_panic("fd_merge_int");
	dest->type = src1->type;
	switch ( src1->type ) {
	case CH_INT_ADD:
		dest->d.i = d_alloc(sizeof(INTEGER64));
		dest->d.i[0] = src1->d.i[0] + src2->d.i[0];
		break;
	case CH_INT_AVG:
		dest->d.i = d_alloc(sizeof(INTEGER64)*2);
		dest->d.i[1] = src1->d.i[1] + src2->d.i[1];
		if ( dest->d.i[1] )
			dest->d.i[0] = (src1->d.i[0]*src1->d.i[1] + src2->d.i[0]*src2->d.i[1])/dest->d.i[1];
		else	
			dest->d.i[0] = (src1->d.i[0]*src1->d.i[1] + src2->d.i[0]*src2->d.i[1])/2;
		break;
	case CH_INT_MAX:
		dest->d.i = d_alloc(sizeof(INTEGER64));
		if ( src1->d.i[0] < src2->d.i[0] )
			dest->d.i[0] = src2->d.i[0];
		else	dest->d.i[0] = src1->d.i[0];
		break;
	case CH_INT_MIN:
		dest->d.i = d_alloc(sizeof(INTEGER64));
		if ( src1->d.i[0] > src2->d.i[0] )
			dest->d.i[0] = src2->d.i[0];
		else	dest->d.i[0] = src1->d.i[0];
		break;
	default:
		er_panic("fd_merge_int");
	}
}


void
fd_diff_int(IP_FIELD * dest,IP_FIELD * up,IP_FIELD * down)
{
	if ( up->type != down->type )
		er_panic("fd_merge_int");
	dest->type = up->type;
	switch ( up->type ) {
	case CH_INT_ADD:
	case CH_INT_MAX:
	case CH_INT_MIN:
		dest->d.i = d_alloc(sizeof(INTEGER64));
		dest->d.i[0] = down->d.i[0];
		break;
	case CH_INT_AVG:
		dest->d.i = d_alloc(sizeof(INTEGER64)*2);
		dest->d.i[1] = down->d.i[1];
		dest->d.i[0] = down->d.i[0] - up->d.i[0];
		break;
	default:
		er_panic("fd_merge_int");
	}
}


void
fd_add_int(IP_FIELD * dest,IP_FIELD * up,IP_FIELD * diff,SIMPLE_ALLOC_T * sat)
{
	if ( up->type != diff->type )
		er_panic("fd_merge_int");
	dest->type = up->type;
	switch ( up->type ) {
	case CH_INT_ADD:
	case CH_INT_MAX:
	case CH_INT_MIN:
		dest->d.i = sat_alloc(sizeof(INTEGER64),sat);
		dest->d.i[0] = diff->d.i[0];
		break;
	case CH_INT_AVG:
		dest->d.i = sat_alloc(sizeof(INTEGER64)*2,sat);
		dest->d.i[1] = diff->d.i[1];
		dest->d.i[0] = diff->d.i[0] + up->d.i[0];
		break;
	default:
		er_panic("fd_merge_int");
	}
}


unsigned char *
fd_to_external_int(IP_FIELD * src,unsigned char * p)
{
INTEGER64 d[2];
	switch ( src->type ) {
	case CH_INT_ADD:
	case CH_INT_MAX:
	case CH_INT_MIN:
		d[0] = src->d.i[0];
		change_endian(d[0]);
		memcpy(p,&d[0],sizeof(INTEGER64));
		p += sizeof(INTEGER64);
		break;
	case CH_INT_AVG:
		d[0] = src->d.i[0];
		d[1] = src->d.i[1];
		change_endian(d[0]);
		change_endian(d[1]);
		memcpy(p,&d[0],sizeof(INTEGER64)*2);
		p += sizeof(INTEGER64)*2;
		break;
	default:
		er_panic("fd_merge_int");
	}
	return p;
}


unsigned char *
fd_to_internal_int(IP_FIELD * dest,unsigned char * p,SIMPLE_ALLOC_T * sat)
{
INTEGER64 d[2];
unsigned char type;
	type = *p;
	p ++;
	switch ( type ) {
	case CH_INT_ADD:
	case CH_INT_MAX:
	case CH_INT_MIN:
		if ( dest ) {
			memcpy(&d[0],p,sizeof(INTEGER64));
			change_endian(d[0]);
			dest->d.i = sat_alloc(sizeof(INTEGER64),sat);
			dest->d.i[0] = d[0];
		}
		p += sizeof(INTEGER64);
		break;
	case CH_INT_AVG:
		if ( dest ) {
			memcpy(&d[0],p,sizeof(INTEGER64)*2);
			change_endian(d[0]);
			change_endian(d[1]);
			dest->d.i = sat_alloc(sizeof(INTEGER64)*2,sat);
			dest->d.i[0] = d[0];
			dest->d.i[1] = d[1];
		}
		p += sizeof(INTEGER64)*2;
		break;
	default:
		er_panic("fd_merge_int");
	}
	return p;
}


int fd_size_int(IP_FIELD * d1)
{
	switch ( d1->type ) {
	case CH_INT_ADD:
	case CH_INT_MAX:
	case CH_INT_MIN:
		return sizeof(INTEGER64);
	case CH_INT_AVG:
		return sizeof(INTEGER64)*2;
	default:
		er_panic("fd_merge_int");
	}
	return 0;
}


int fd_cmp_int(IP_FIELD * d1,IP_FIELD * d2)
{
	if ( d1->d.i[0] < d2->d.i[0] )
		return -1;
	if ( d1->d.i[0] > d2->d.i[0] )
		return 1;
	return 0;
}


/* TYPE RGBA */

int
fd_initial_rgba(IP_FIELD * target,void * _d,void * w,int flag)
{
FD_RGBA_OPT * opt;
INTEGER64 data;
XL_SEXP *count;
XL_SEXP * d;
L_CHAR * dstr;

	opt = (FD_RGBA_OPT*)w;
	if ( target == 0 ) {
		d = (XL_SEXP*)_d;
		count = get_el(d,0);
		switch ( get_type(count) ) {
		case XLT_INTEGER:
			opt->count = count->integer.data;
			break;
		default:
			return -1;
		}
		opt->h.merge_type = CH_TYPE_RGBA;
		if ( list_length(d) == 2 )
			opt->h.init_sexp = get_el(d,1);
		return 0;
	}
	if ( flag ) {
		dstr = (L_CHAR*)_d;
		sscanf(n_string(std_cm,dstr),I64_FORMAT,&data);
	}
	else {
		d = (XL_SEXP*)_d;
		switch ( get_type(d) ) {
		case XLT_INTEGER:
			data = d->integer.data;
			break;
		case XLT_STRING:
			sscanf(n_string(std_cm,d->string.data),I64_FORMAT,&data);
			break;
		default:
print_sexp(s_stdout,d,0);
ss_printf("\n");
			return -2;
		}
	}
	target->type = opt->h.merge_type;
	target->d.i = d_alloc(sizeof(INTEGER64)*2);
	target->d.i[0] = data;
	target->d.i[1] = opt->count;
	return 0;
}


void
fd_copy_rgba(IP_FIELD * d1,IP_FIELD* d2,SIMPLE_ALLOC_T * sat)
{
	d1->type = d2->type;
	d1->d.rgba = sat_alloc(sizeof(*d1->d.rgba),sat);
	*d1->d.rgba = *d2->d.rgba;
}

void
fd_merge_rgba(IP_FIELD * dest,IP_FIELD * src1,IP_FIELD * src2)
{
int i;
U_INTEGER64 a,b;
	if ( src1->type != src2->type )
		er_panic("fd_merge_rgba");
	dest->type = src1->type;
	dest->d.rgba = d_alloc(sizeof(*dest->d.rgba));
	dest->d.rgba->count = src1->d.rgba->count + src2->d.rgba->count;
	for ( i = 0 ; i < 4 ; i ++ ) {
		a = src1->d.rgba->rgba[i]*src1->d.rgba->count;
		b = src2->d.rgba->rgba[i]*src2->d.rgba->count;
		if ( dest->d.rgba->count )
			dest->d.rgba->rgba[i] = (a+b)/dest->d.rgba->count;
		else
			dest->d.rgba->rgba[i] = (a+b)/2;
	}
}


void
fd_diff_rgba(IP_FIELD * dest,IP_FIELD * up,IP_FIELD * down)
{
	if ( up->type != down->type )
		er_panic("fd_diff_rgba");
	dest->type = up->type;
	dest->d.rgba = d_alloc(sizeof(*dest->d.rgba));
	*dest->d.rgba = *down->d.rgba;
}


void
fd_add_rgba(IP_FIELD * dest,IP_FIELD * up,IP_FIELD * diff,SIMPLE_ALLOC_T * sat)
{
	if ( up->type != diff->type )
		er_panic("fd_diff_rgba");
	dest->type = up->type;
	dest->d.rgba = sat_alloc(sizeof(*dest->d.rgba),sat);
	*dest->d.rgba = *diff->d.rgba;
}


unsigned char *
fd_to_internal_rgba(IP_FIELD * dest,unsigned char * p,SIMPLE_ALLOC_T * sat)
{
unsigned char type;
	type = *p;
	p ++;
	if ( dest == 0 ) {
		return p + 4 + sizeof(INTEGER64);
	}
	dest->d.rgba = sat_alloc(sizeof(*dest->d.rgba),sat);
	memcpy(dest->d.rgba->rgba,p,4);
	p += 4;
	memcpy(&dest->d.rgba->count,p,sizeof(INTEGER64));
	change_endian(dest->d.rgba->count);
	p += sizeof(INTEGER64);
	return p;
}


unsigned char *
fd_to_external_rgba(IP_FIELD * src,unsigned char * p)
{
INTEGER64 d;
	memcpy(p,src->d.rgba->rgba,4);
	p += 4;
	d = src->d.rgba->count;
	change_endian(d);
	memcpy(p,&d,sizeof(INTEGER64));
	p += sizeof(INTEGER64);
	return p;
}


int fd_size_rgba(IP_FIELD * d1)
{
	return 4 + sizeof(INTEGER64);
}


int fd_cmp_rgba(IP_FIELD * d1,IP_FIELD * d2)
{
int i;
	for ( i = 0 ; i < 4 ; i ++ ) {
		if ( d1->d.rgba->rgba[i] < d2->d.rgba->rgba[i] )
			return -1;
		if ( d1->d.rgba->rgba[i] > d2->d.rgba->rgba[i] )
			return 1;
	}
	return 0;
}

/***********************************************
	FIELD OPERATION
************************************************/

IP_FIELD *
xx_copy_fields(IP_FIELD *fd,SIMPLE_ALLOC_T * sat,char*file,int line);
#define copy_fields(fd,sat)	xx_copy_fields((fd),(sat),__FILE__,__LINE__)

IP_FIELD *
xx_copy_fields(IP_FIELD *fd,SIMPLE_ALLOC_T * sat,char*file,int line)
{
int i;
IP_FIELD * ret;
	if ( fd == 0 )
		return 0;
	ret = sat_alloc(sizeof(IP_FIELD)*fd[0].len,sat);
	for ( i = 0 ; i < fd[0].len ; i ++ ) {
		if ( field_type_tbl[fd[i].type>>CH_TYPE_SHIFT].copy == 0 )
			er_panic("copy_fields");
		(*field_type_tbl[fd[i].type>>CH_TYPE_SHIFT].copy)(&ret[i],&fd[i],sat);
	}
	ret[0].len = fd[0].len;
	return ret;
}

void
xx_change_st_fields(IP_FIELD *fd,char*file,int line)
{
int i;
	if ( fd == 0 )
		return;
	xx_change_statistics(fd,file,line);
	for ( i = 0 ; i < fd[0].len ; i ++ ) {
		if ( fd[i].d.str )
			xx_change_statistics(fd[i].d.str,file,line);
	}
}


void
free_fields(IP_FIELD * fd)
{
int i;
	if ( fd == 0 )
		return;
	for ( i = 0 ; i < fd[0].len ; i ++ ) {
		if ( fd[i].d.str )
			d_f_ree(fd[i].d.str);
	}
	d_f_ree(fd);
}

IP_FIELD *
merge_fields(unsigned char * flags,IP_FIELD * fd1,IP_FIELD * fd2)
{
IP_FIELD * ret;
IP_FIELD * max,*min;
int i;
	if ( fd1 == 0 && fd2 == 0 )
		return 0;
	if ( fd1 == 0 )
		return copy_fields(fd2,0);
	if ( fd2 == 0 )
		return copy_fields(fd1,0);
	if ( fd1[0].len < fd2[0].len ) {
		max = fd2;
		min = fd1;
	}
	else {
		max = fd1;
		min = fd2;
	}
	ret = d_alloc(sizeof(IP_FIELD)*max[0].len);
	for ( i = 0 ; i < min[0].len ; i ++ ) {
		if ( (min[i].type & CH_TYPE_MASK) == CH_TYPE_NONE )
			(*field_type_tbl[max[i].type>>CH_TYPE_SHIFT].copy)(&ret[i],&max[i],0);
		else if ( (max[i].type & CH_TYPE_MASK) == CH_TYPE_NONE )
			(*field_type_tbl[min[i].type>>CH_TYPE_SHIFT].copy)(&ret[i],&min[i],0);
		else {
			if ( (min[i].type & CH_TYPE_MASK) != (max[i].type & CH_TYPE_MASK) ) {
				ss_printf("MF %x %x\n",
					min[i].type,
					max[i].type);
				er_panic("merge_fields(1)");
			}
			(*field_type_tbl[max[i].type>>CH_TYPE_SHIFT].merge)(&ret[i],&min[i],&max[i]);
		}
	}
	for ( ; i < max[0].len ; i ++ ) {
		(*field_type_tbl[max[i].type>>CH_TYPE_SHIFT].copy)(&ret[i],&max[i],0);
	}
	ret[0].len = max[0].len;
	*flags |= PP_MERGED_FIELDS;
	return ret;
}

IP_FIELD *
diff_fields(IP_FIELD * down,IP_FIELD * up)
{
int i;
IP_FIELD * ret;
	if ( down == 0 && up == 0 )
		return 0;
	if ( up == 0 ) {
		ret = copy_fields(down,0);
		return ret;
	}
	if ( down == 0 )
		return 0;
	ret = d_alloc(sizeof(IP_FIELD)*down[0].len);
	ret[0].len = down[0].len;
	for ( i = 0 ; i < down[0].len ; i ++ ) {
		if ( (up[i].type & CH_TYPE_MASK) == CH_TYPE_NONE ) {
			(*field_type_tbl[down[i].type>>CH_TYPE_SHIFT].copy)(&ret[i],&down[i],0);
		}
		else if ( (down[i].type & CH_TYPE_MASK) == CH_TYPE_NONE ) {
			(*field_type_tbl[down[i].type>>CH_TYPE_SHIFT].copy)(&ret[i],&down[i],0);
		}
		else {
			if ( (up[i].type & CH_TYPE_MASK) != (down[i].type & CH_TYPE_MASK) ) {
				ss_printf("MF %x %x\n",
					up[i].type,
					down[i].type);
				er_panic("merge_fields(2)");
			}
			(*field_type_tbl[up[i].type>>CH_TYPE_SHIFT].diff)(&ret[i],&up[i],&down[i]);
		}
	}
	return ret;
}


void
free_internal_plot(INTERNAL_PLOT * ip)
{
	if ( ip == 0 )
		return;
	if ( ip->fields )
		free_fields(ip->fields);
	if ( ip->base )
		d_f_ree(ip->base);
	d_f_ree(ip->c);
	d_f_ree(ip);
}

void
free_internal_plot_list(INTERNAL_PLOT * ip)
{
INTERNAL_PLOT * ip1;
	for ( ; ip ; ) {
		ip1 = ip;
		ip = ip->next;
		free_internal_plot(ip1);
	}
}


INTERNAL_PLOT *
xx_copy_internal_plot(MATRIX * m,INTERNAL_PLOT * ip,char * file,int line);
#define copy_internal_plot(m,ip)	xx_copy_internal_plot(m,ip,__FILE__,__LINE__)

INTERNAL_PLOT *
xx_copy_internal_plot(MATRIX * m,INTERNAL_PLOT * ip,char * file,int line)
{
INTERNAL_PLOT * ret,**rp,*r;
	ret = 0;
	rp = &ret;
	for ( ; ip ; ip = ip->next ) {
		r = d_alloc(sizeof(*r));
		memset(r,0,sizeof(*r));
		*r = *ip;
		r->next = 0;
		r->c = xx_d_alloc(sizeof(r->c[0])*m->p.dim,file,line);
		memcpy(r->c,ip->c,sizeof(r->c[0])*m->p.dim);
		if ( ip->fields )
			r->fields = xx_copy_fields(ip->fields,0,file,line);
		if  ( ip->base ) {
			r->base = xx_d_alloc(sizeof(INTEGER64)*m->p.dim,file,line);
			memcpy(r->base,ip->base,sizeof(INTEGER64)*m->p.dim);
		}
		*rp = r;
		rp = &(*rp)->next;
	}
	return ret;
}

void
xx_change_st_internal_plot(INTERNAL_PLOT * ip,char * file,int line);
#define change_st_internal_plot(ip)	xx_change_st_internal_plot(ip,__FILE__,__LINE__)

void
xx_change_st_internal_plot(INTERNAL_PLOT * ip,char * file,int line)
{
	for ( ; ip ; ip = ip->next ) {
		xx_change_statistics(ip,file,line);
		xx_change_statistics(ip->c,file,line);
		if ( ip->fields )
			xx_change_st_fields(ip->fields,file,line);
		if  ( ip->base )
			xx_change_statistics(ip->base,file,line);
	}
}


int
cmp_plot(MATRIX * m,unsigned short * c1,unsigned short * c2)
{
int i;
int shift;
unsigned short a,b;
	shift = 0;
	for ( i = 0 ; i < m->p.dim ; i ++ ) {
		if ( m->block_size[i] > shift )
			shift = m->block_size[i];
	}
	shift --;
	for ( ; shift >= 0 ; shift -- ) {
		for ( i = 0 ; i < m->p.dim ; i ++ ) {
			if ( m->block_size[i] <= shift )
				continue;
			a = c1[i]&(1<<shift);
			b = c2[i]&(1<<shift);
			if ( a < b )
				return -1;
			if ( a > b )
				return 1;
		}
	}
	return 0;
}

int code2internal_step;

INTERNAL_PLOT*
code2internal(MATRIX * m,PRIMITIVE_PLOT*ptr,int ptr_size,SIMPLE_ALLOC_T * sat)
{
INTERNAL_PLOT * ret,**rp,*r;
int dim_len;
unsigned short * p;
unsigned char *cp,*cpp;
INTEGER64 * int_p;
int i;
int len;
unsigned char cp_type;

	if ( sat )
		smp_init(sat);

	ret = 0;
	rp = &ret;
	for ( ; ; ) {
		if ( ptr->flags == PP_END )
			break;
		r = sat_alloc(sizeof(*r),sat);
		memset(r,0,sizeof(*r));
		r->flags = ptr->flags;
		dim_len = m->p.dim;
		r->c = sat_alloc(dim_len*sizeof(r->c[0]),sat);
		p = &ptr->c[0];
		memcpy(r->c,p,dim_len*sizeof(r->c[0]));
		for ( i = 0 ; i < dim_len ; i ++ ) {
			change_endian(r->c[i]);
		}
		p += dim_len;
		if ( r->flags & PP_BASE ) {
			int_p = (INTEGER64*)p;
			r->base = sat_alloc(sizeof(INTEGER64)*dim_len,sat);
			memcpy(r->base,int_p,sizeof(INTEGER64)*dim_len);
			for ( i = 0 ; i < dim_len ; i++ ) {
				change_endian(r->base[i]);
			}
			cp = (unsigned char*)(int_p+dim_len);
		}
		else {
			r->base = 0;
			cp = (unsigned char*)p;
		}
		if ( r->flags & PP_ID ) {
		INTEGER64 * pd;
			pd = (INTEGER64*)cp;
			memcpy(&r->id,pd,sizeof(INTEGER64));
			change_endian(r->id);
			cp = (unsigned char*)&pd[1];
		}
		cpp = cp;
		for ( i = 0 ; ; i ++ ) {
			if ( *cp == 0 ) {
				cp ++;
				break;
			}
			cp_type = *cp;
			cp = (*field_type_tbl[cp_type>>CH_TYPE_SHIFT].to_internal)(0,cp,sat);
		}
		len = i;
		r->fields = sat_alloc(sizeof(IP_FIELD)*len,sat);
		cp = cpp;
		for ( i = 0 ; ; i ++ ) {
			if ( *cp == 0 ) {
				cp ++;
				break;
			}
			r->fields[i].type = *cp;
			r->fields[i].d.str = 0;
			cp = (*field_type_tbl[r->fields[i].type>>CH_TYPE_SHIFT].to_internal)(&r->fields[i],cp,sat);
		}

/*
		r->fields[i].d.str = 0;
		r->fields[i].type = 0;
*/
		r->fields[0].len = len;
		ptr = (PRIMITIVE_PLOT*)cp;
		*rp = r;
		r->next = 0;
		rp = &r->next;
	}
	return ret;
}

int
get_internal_plot_len(INTERNAL_PLOT * ip)
{
int ret;
	ret = 0;
	for ( ; ip ; ip = ip->next , ret ++ );
	return ret;
}

void
check_internal_plot(MATRIX * m,INTERNAL_PLOT * ip,char*msg)
{
int i;
INTERNAL_PLOT * ip2;
	if ( ip == 0 )
		return;
	for ( ; ip ; ip = ip->next ) {
		if ( ip->fields == 0 )
			continue;
		for ( i = 0 ; i < ip->fields[0].len ; i ++ ) {
			switch ( ip->fields[i].type ) {
			case CH_NONE:

			case CH_STRING:
			case CH_STRING_INHERIT:
			case CH_STRING_ERASE:

			case CH_INT_ADD:
			case CH_INT_AVG:
			case CH_INT_MAX:
			case CH_INT_MIN:

			case CH_RGBA:
				break;
			default:
				ss_printf("%s %x\n",msg,ip->fields[i].type);
				er_panic("CHECK");
			}
		}
		ip2 = ip->next;
		if ( ip2 )
			if ( cmp_plot(m,ip->c,ip2->c) > 0 ) {
				ss_printf("%s\n",msg);
				er_panic("CHECK2");
			}
	}
}

void
print_internal_plot(MATRIX * m,INTERNAL_PLOT * ip,char*msg)
{
int i;
int cnt;
	cnt = 10;
	ss_printf("%s ",msg);
	for ( ; ip ; ip = ip->next , cnt -- ) {
		ss_printf("(%x : ",ip->flags);
		for ( i = 0 ; i < m->p.dim ; i ++ )
			ss_printf("%x ",ip->c[i]);
		ss_printf(" : ");
		if ( ip->base )
			for ( i = 0 ; i < m->p.dim ; i ++ )
				ss_printf("%x ",ip->base[i]);
		ss_printf(")");
	}
	ss_printf("\n");
}



PRIMITIVE_PLOT *
one_internal2code(int * size_p,MATRIX * m,INTERNAL_PLOT* ip)
{
int size;
PRIMITIVE_PLOT * ret;
unsigned char * p;
unsigned short * sp;
int dim_len;
int i;
INTEGER64 * int_p;
	if ( ip->flags & PP_BASE )
		size = (dim_len=m->p.dim)*sizeof(ret->c[0])+(m->p.dim)*sizeof(INTEGER64)+sizeof(*ret)-sizeof(ret->c[0])+1;
	else	size = (dim_len=m->p.dim)*sizeof(ret->c[0])+sizeof(*ret)-sizeof(ret->c[0])+1;
	if ( ip->id )
		size += sizeof(INTEGER64);
	if ( ip->fields )
		for ( i = 0 ; i < ip->fields[0].len ; i ++ ) {
			size ++;
			size += (*field_type_tbl[ip->fields[i].type>>CH_TYPE_SHIFT].size)(&ip->fields[i]);
		}
	ret = d_alloc(size);
	memset(ret,0,sizeof(*ret));
	ret->flags = ip->flags;
	if ( ip->id )
		ret->flags |= PP_ID;
	sp = &ret->c[0];
	memcpy(sp,ip->c,dim_len*sizeof(ret->c[0]));
	for ( i = 0 ; i < dim_len ; i ++ ) {
		change_endian(sp[i]);
	}
	if ( ip->flags & PP_BASE ) {
		int_p = (INTEGER64*)&sp[dim_len];
		memcpy(int_p,ip->base,dim_len*sizeof(INTEGER64));
		for ( i = 0 ; i < dim_len ; i ++ ) {
			change_endian(int_p[i]);
		}
		p = (unsigned char*)&int_p[dim_len];
	}
	else	p = (unsigned char*)&sp[dim_len];
	if ( ip->id ) {
	INTEGER64 d;
	INTEGER64 * pd;
		pd = (INTEGER64*)p;
		d = ip->id;
		change_endian(d);
		memcpy(pd,&d,sizeof(INTEGER64));
		p = (unsigned char*)&pd[1];
	}
	if ( ip->fields )
		for ( i = 0 ; i < ip->fields[0].len ; i ++ ) {
			*p++ = ip->fields[i].type;
			p = (*field_type_tbl[ip->fields[i].type>>CH_TYPE_SHIFT].to_external)(&ip->fields[i],p);
		}
	*p = 0;
	*size_p = size;
	return ret;
}

PRIMITIVE_PLOT *
internal2code(int * size_p,MATRIX * m,INTERNAL_PLOT*ip)
{
RECORD_LIST64 * rl;
int size;
PRIMITIVE_PLOT * pp;
char end_char;
	rl = new_recordlist64(0,0);
	for ( ; ip ; ip = ip->next ) {
		pp = one_internal2code(&size,m,ip);
		set_recordlist_chain64(rl,pp,size,1);
	}
	end_char = PP_END;
	set_recordlist_chain64(rl,&end_char,1,0);
	size = setup_recordlist64(rl);
	pp = rl->data;
	rl->data = 0;
	free_recordlist64(rl);
	*size_p = size;
	return pp;
}

INTERNAL_PLOT *
diff_pp(MATRIX * m,INTERNAL_PLOT ** diff,INTERNAL_PLOT * down)
{
INTERNAL_PLOT * up,*df;
INTERNAL_PLOT *ip1,*ip2;
INTERNAL_PLOT *ip3,*ip4;
int dim;
int i;
IP_FIELD * fd,*fd2;
unsigned char flags;

ss_printf("diff-1\n");
	dim = m->p.dim;
	up = copy_internal_plot(m,down);
	df = copy_internal_plot(m,down);
	ip1 = up;
	ip2 = df;
ss_printf("diff-2\n");
	for ( ; ip1 ; ip1 = ip1->next ,ip2 = ip2->next ) {
		if ( ip1->base )
			d_f_ree(ip1->base);
		ip1->base = 0;
		ip1->flags &= ~PP_BASE;
		for ( i = 0 ; i < dim ; i ++ )
			ip1->c[i] >>= m->dim_divide[i];
		for ( i = 0 ; i < dim ; i ++ )
			ip2->c[i] &= (((int)1)<<m->dim_divide[i])-1;
	}
	ip1 = up;
	ip2 = df;
/*
ss_printf("diff-3\n");
print_internal_plot(m,ip1,"diif-2-22");
*/
	for ( ; ip1 ; ) {
		fd = copy_fields(ip1->fields,0);
		flags = 0;
		ip2->flags |= PP_START_POINT;
		ip3 = ip1->next;
		ip4 = ip2->next;
//ss_printf("diff-4\n");
		for ( ; ip3 ; ) {
			for ( i = 0 ; i < dim ; i ++ ) {
//ss_printf("diff-5 %x %x\n",ip1->c[i],ip3->c[i]);
				if ( ip1->c[i] != ip3->c[i] )
					goto diff;
			}
//ss_printf("diff-4 SAME\n");
			fd2 = merge_fields(&flags,fd,ip3->fields);
			if ( ip3->id == ip1->id && ip1->id )
				ip3->id = PPID_INHERIT;
			free_fields(fd);
			fd = fd2;
			ip1->next = ip3->next;
			free_internal_plot(ip3);
			ip3 = ip1->next;
			ip4 = ip4->next;
			continue;
		diff:
			break;
		}
//ss_printf("diff-4 DIFF\n");
		free_fields(ip1->fields);
		ip1->fields = fd;
		ip1->flags |= flags;
		for ( ; ip2 != ip4 ; ip2 = ip2->next ) {
			fd2 = ip2->fields;
			ip2->fields = diff_fields(ip2->fields,fd);
			free_fields(fd2);
		}
		ip1 = ip1->next;
	}
	*diff = df;
	return up;
}


INTERNAL_PLOT *
add_diff(MATRIX * m,INTERNAL_PLOT * up,INTERNAL_PLOT * diff,INTEGER64 * down_code,SIMPLE_ALLOC_T * sat)
{
unsigned short *mask;
unsigned short * code;
INTERNAL_PLOT * ret, ** rp, * r;
int i;

	mask = d_alloc(sizeof(INTEGER64)*m->p.dim);
	code = d_alloc(sizeof(unsigned short)*m->p.dim);
	for (i = 0 ; i < m->p.dim ; i ++ ) {
		mask[i] = ((((INTEGER64)1)<<m->dim_divide[i])-1)<<(m->block_size[i]-m->dim_divide[i]);
		code[i]= (down_code[i+1]>>((down_code[0]+1)*m->dim_divide[i]))&mask[i];
	}
	ret = 0;
	rp = &ret;
	for ( ; up ; up = up->next ) {
		for ( i = 0 ; i < m->p.dim ; i ++ )
			if ( (up->c[i] & mask[i]) != code[i] )
				goto cont;
		break;
	cont:;
	}
	for ( ; up ; up = up->next ) {
		for ( i = 0 ; i < m->p.dim ; i ++ )
			if ( (up->c[i] & mask[i]) != code[i] )
				goto next2;
		for ( ; ; ) {
			r = sat_alloc(sizeof(*r),sat);
			memset(r,0,sizeof(*r));
			*r = *up;
			r->flags = diff->flags;
			r->next = 0;
			r->c = sat_alloc(sizeof(r->c[0])*m->p.dim,sat);
			for ( i = 0 ; i < m->p.dim ; i ++ ) {
				r->c[i] = ((up->c[i]<<m->dim_divide[i])|diff->c[i])&
						((1<<m->block_size[i])-1);
			}
			if ( diff->flags & PP_BASE ) {
				r->flags |= PP_BASE;
				r->base = sat_alloc(sizeof(INTEGER64)*m->p.dim,sat);
				memcpy(r->base,diff->base,sizeof(INTEGER64)*m->p.dim);
			}
			else {
				r->base = 0;
			}
			if ( diff->id == 0 ) {
				if ( diff->flags & PP_START_POINT ) {
					if ( diff->next == 0 )
						r->id = up->id;
					else if ( diff->next->flags & PP_START_POINT )
						r->id = up->id;
					else	r->id = get_matrix_obj_id(m);
				}
				else	r->id = get_matrix_obj_id(m);
			}
			else if ( diff->id == PPID_INHERIT )
				r->id = up->id;
			else	r->id = diff->id;
			if ( diff->fields && up->fields) {
				r->fields = sat_alloc(sizeof(IP_FIELD)*diff->fields[0].len,sat);
				for ( i = 0 ; i < diff->fields[0].len && i < up->fields[0].len ; i ++ ) {
					if ( (diff->fields[i].type & CH_TYPE_MASK) == CH_TYPE_NONE ) {
						(*field_type_tbl[diff->fields[i].type>>CH_TYPE_SHIFT].copy)
							(&r->fields[i],&diff->fields[i],sat);
					}
					else if ( (up->fields[i].type & CH_TYPE_MASK) != (diff->fields[i].type & CH_TYPE_MASK) ) {
						ss_printf("MF %x %x\n",
							up->fields[i].type,
							diff->fields[i].type);
						er_panic("add_diff");
					}
					else {
						(*field_type_tbl[up->fields[i].type>>CH_TYPE_SHIFT].add)
							(&r->fields[i],&up->fields[i],&diff->fields[i],sat);
					}
				}
				for ( ; i < diff->fields[0].len ; i ++ ) {
					(*field_type_tbl[diff->fields[i].type>>CH_TYPE_SHIFT].copy)
						(&r->fields[i],&diff->fields[i],sat);
				}
				r->fields[0].len = diff->fields[0].len;
			}
			else if ( diff->fields == 0 ) {
				r->fields = 0;
			}
			else if ( up->fields == 0 ) {
				r->fields = copy_fields(diff->fields,sat);
			}
			*rp = r;
			rp = &r->next;
			
			diff = diff->next;
			if ( diff == 0 )
				break;
			if ( diff->flags & PP_START_POINT )
				break;
		}
	}
next2:
	d_f_ree(mask);
	d_f_ree(code);
	return ret;
}

INTERNAL_PLOT *
shift_under_plot(MATRIX*m,INTERNAL_PLOT * ip,INTEGER64 level,INTEGER64 * dc)
{
int i;
INTERNAL_PLOT * ret,**rp,*free_list,*ip1;
INTEGER64 * ix,mask;
	ip = copy_internal_plot(m,ip);
	free_list = 0;
	ret = 0;
	rp = &ret;
	ix = d_alloc(sizeof(INTEGER64)*m->p.dim);
	for ( ; ip ; ) {
		ip1 = ip;
		ip = ip->next;
		ip1->next = 0;
//ss_printf("SUP level = %lli %lli\n",level,dc[0]);
		for ( i = 0 ; i < m->p.dim ; i ++ ) {
			if ( ip1->flags & PP_BASE )
				ix[i] = (((INTEGER64)ip1->c[i])<<(m->dim_divide[i]*level)) + ip1->base[i];
			else	ix[i] = ((INTEGER64)ip1->c[i])<<(m->dim_divide[i]*level);
			mask = (((INTEGER64)1)<<(m->dim_divide[i]*level+m->block_size[i]))
					-(((INTEGER64)1)<<(m->dim_divide[i]*dc[0]+m->block_size[i]));
/*
if ( ip1->flags & PP_BASE )
ss_printf("SUP %i %llx - %llx %llx - %llx %llx - %x\n",i,mask,ix[i],dc[i+1],dc[0],ip1->base[i],ip1->c[i]);
else
ss_printf("SUP %i %llx - %llx %llx - %llx 0 - %x\n",i,mask,ix[i],dc[i+1],dc[0],ip1->c[i]);
*/
			if ( (mask & ix[i]) == (mask & dc[i+1]) )
				continue;
			goto outside;
		}
//ss_printf("OK\n");
		for ( i = 0 ; i < m->p.dim ; i ++ ) {
			ip1->c[i] = (ix[i]>>(m->dim_divide[i]*dc[0]))&
				((((INTEGER64)1)<<m->block_size[i])-1);
			if ( ip1->flags & PP_BASE )
				ip1->base[i] = ix[i]&((((INTEGER64)1)<<(m->dim_divide[i]*dc[0]))-1);
		}
		if ( ip1->flags & PP_BASE ) {
			for ( i = 0 ; i < m->p.dim ; i ++ ) {
				if ( ip1->base[i] )
					goto next;
			}
			d_f_ree(ip1->base);
			ip1->base = 0;
			ip1->flags &= ~PP_BASE;
		}
	next:
		*rp = ip1;
		rp = &ip1->next;
		continue;
	outside:
		ip1->next = free_list;
		free_list = ip1;
	}
	free_internal_plot_list(free_list);
	d_f_ree(ix);
	return ret;
}


INTERNAL_PLOT *
shift_insert_plot(MATRIX * m,INTERNAL_PLOT * target,INTERNAL_PLOT * ip,INTEGER64 * dim_code)
{
unsigned short * code;
int i;
INTEGER64 mask;
INTERNAL_PLOT ** tp,*r,**ipp;
INTERNAL_PLOT * last;
	if ( ip == 0 )
		return target;
	code = d_alloc(sizeof(unsigned short)*m->p.dim);
	for (i = 0 ; i < m->p.dim ; i ++ ) {
		mask = ((((INTEGER64)1)<<m->dim_divide[i])-1)<<(m->block_size[i]-m->dim_divide[i]);
		code[i]= (dim_code[i+1]>>((dim_code[0]+1)*m->dim_divide[i]))&mask;
	}
	tp = &target;
	for ( r = ip ; r ; r = r->next ) {
		last = r;
		for ( i = 0 ; i < m->p.dim ; i ++ )
			r->c[i] |= code[i];
	}
	for ( ; *tp ; tp = &(*tp)->next ) {
		r = *tp;
		if ( cmp_plot(m,r->c,ip->c) >= 0 )
			break;
	}
	r = *tp;
	if ( r && cmp_plot(m,r->c,last->c) < 0 )
		er_panic("shift_insert_plot");
	*tp = ip;
	for ( ipp = &ip ; *ipp ; ipp = &(*ipp)->next );
	*ipp = r;
	return target;
}

INTERNAL_PLOT *
sort_plot(MATRIX * m,INTERNAL_PLOT * ip)
{
INTERNAL_PLOT * a,*b,*c;
INTERNAL_PLOT * ret,**rp;
	if ( ip == 0 )
		return 0;
	if ( ip->next == 0 )
		return ip;
	a = b = 0;
	for ( ; ip ; ) {
		c = ip;
		ip = ip->next;
		c->next = a;
		a = c;
		if ( ip == 0 )
			break;
		c = ip;
		ip = ip->next;
		c->next = b;
		b = c;
	}
	a = sort_plot(m,a);
	b = sort_plot(m,b);
	ret = 0;
	rp = &ret;
	for ( ; a && b ; ) {
		if ( cmp_plot(m,a->c,b->c) < 0 ) {
			c = a;
			a = c->next;
		}
		else {
			c = b;
			b = c->next;
		}
		*rp = c;
		c->next = 0;
		rp = &c->next;
	}
	if ( a )
		*rp = a;
	else	*rp = b;
	return ret;
}

INTERNAL_PLOT *
make_plot(MATRIX * m,INTEGER64 level,INTEGER64 * crd,IP_FIELD * fd)
{
int i;
INTERNAL_PLOT * ret;
	ret = d_alloc(sizeof(*ret));
	memset(ret,0,sizeof(*ret));
	ret->flags = PP_PRIMITIVE;
	ret->c = d_alloc(sizeof(ret->c[0])*m->p.dim);
	for ( i = 0 ; i < m->p.dim ; i ++ )
		ret->c[i] = (crd[i+1]>>(m->dim_divide[i]*level))&((1<<m->block_size[i])-1);
	if ( (crd[0] < level) ) {
		for ( i = 0 ; i < m->p.dim ; i ++ ) {
			if ( (crd[i+1] & ((((INTEGER64)1)<<(level*m->dim_divide[i]))
					- (((INTEGER64)1)<<(crd[0]*m->dim_divide[i])))) ) {
				ret->flags |= PP_BASE;
				ret->base = d_alloc(sizeof(INTEGER64)*m->p.dim);
				for ( i = 0 ; i < m->p.dim ; i ++ ) {
					ret->base[i] = crd[i+1] & ((((INTEGER64)1)<<(level*m->dim_divide[i]))-1);
				}
				break;
			}
		}
	}
	ret->fields = copy_fields(fd,0);
	return ret;
}


void
get_plot_crd(INTEGER64 * crd,MATRIX * m,INTERNAL_PLOT * ip,INTEGER64 level)
{
int i;
INTEGER64 a;
	for ( i = 0 ; i < m->p.dim ; i ++ ) {
		a = ((INTEGER64)ip->c[i])<<(level*m->dim_divide[i]);
		if ( ip->base )
			a += ip->base[i];
		crd[i+1] = a;
	}
	crd[0] = level;
}


/***************************************************************
	STRUCTURED BLOCK
****************************************************************/

typedef struct pp_struct_block {
	MX_STRUCT_BLOCK		h;
	int			flags;
	INTERNAL_PLOT *		plot;
	int *			ary_size;
	INTERNAL_PLOT **	ary;
	int			min;
	SIMPLE_ALLOC_T		sat;
} PP_STRUCT_BLOCK;


MX_STRUCT_BLOCK * pp_new_sb(MX_SB_NEW*,void*);
MX_STRUCT_BLOCK * pp_copy_sb(MX_STRUCT_BLOCK*);
int  pp_block2struct(MX_STRUCT_BLOCK*,MATRIX_ALLOC_BLOCK_PARAM * b);
MATRIX_ALLOC_BLOCK_PARAM * pp_struct2block(MX_STRUCT_BLOCK * blk);
void pp_free_sb(MX_STRUCT_BLOCK * blk);
int pp_operation(int cmd,MX_STRUCT_BLOCK * blk,void * param);
MX_STRUCT_BLOCK * pr_copy_sb(MX_STRUCT_BLOCK * );
void
set_pp_density(PP_STRUCT_BLOCK * b);

MX_STRUCT_BLOCK_TBL blk_pp_tbl = {
	pp_new_sb,
	pp_free_sb,
	pp_copy_sb,
	pp_block2struct,
	pp_struct2block,
	pp_operation
};


/*
	param = PP_SB_NEW
*/
MX_STRUCT_BLOCK *
pp_new_sb(MX_SB_NEW * n,void * param)
{
PP_SB_NEW *pp;
MX_SB_NEW nn;
PP_STRUCT_BLOCK * b;
char *ptr1,*ptr;
PRIMITIVE_PLOT * _ptr;
int p_size;
int free_flag;
	pp = (PP_SB_NEW*)param;
	nn = *n;
	if ( nn.m ) {
		if ( nn.n ) {
			if ( nn.n->matrix != nn.m )
				return 0;
		}
	}
	else {
		if ( nn.n ) {
			nn.m = nn.n->matrix;
		}
		if ( nn.m == 0 )
			return 0;
	}
	b = d_alloc(sizeof(*b));
	memset(b,0,sizeof(*b));
	b->h.tbl = &blk_pp_tbl;
	b->h.n = nn;
	b->flags = pp->flags;
	b->min = -1;
	
	if ( pp->data == 0 ) {
		b->plot = 0;
	}
	else {
		if ( pp->flags & PPF_COMPRESSED ) {
			ptr = ptr1 = zlib_uncompress(&p_size,(char*)pp->data,pp->size);
			if ( ptr == 0 )
				return 0;
			ptr ++;
			p_size --;
			_ptr = d_alloc(p_size);
			memcpy(_ptr,ptr,p_size);
			d_f_ree(ptr1);
			free_flag = 1;
		}
		else {
			_ptr = (PRIMITIVE_PLOT*)pp->data;
			p_size = pp->size;
			free_flag = 0;
		}
		if ( pp->flags & PPF_SAT ) {
			free_smp(&b->sat);
			b->plot = code2internal(nn.m,(PRIMITIVE_PLOT*)_ptr,p_size,&b->sat);
		}
		else	b->plot = code2internal(nn.m,(PRIMITIVE_PLOT*)_ptr,p_size,0);
		if ( free_flag )
			d_f_ree(_ptr);
	}
	return &b->h;
}

void pp_free_sb(MX_STRUCT_BLOCK * blk)
{
PP_STRUCT_BLOCK * p;
	p = (PP_STRUCT_BLOCK*)blk;
	if ( !(p->flags & PPF_SAT) ) {
		if ( p->plot )
			free_internal_plot_list(p->plot);
	}
	free_smp(&p->sat);
	d_f_ree(p);
}

MX_STRUCT_BLOCK *
pp_copy_sb(MX_STRUCT_BLOCK * b)
{
PP_STRUCT_BLOCK * p,*ret;
	p = (PP_STRUCT_BLOCK*)b;
	ret = d_alloc(sizeof(*ret));
	ret->h = p->h;
	ret->flags = p->flags;
	ret->plot = copy_internal_plot(ret->h.n.m,p->plot);
	return &ret->h;
}


int
pp_block2struct(MX_STRUCT_BLOCK* b,MATRIX_ALLOC_BLOCK_PARAM * p)
{
PP_STRUCT_BLOCK * bb;
int free_flag;
char * ptr1,*ptr;
int p_size;
PRIMITIVE_PLOT * _ptr;

	bb = (PP_STRUCT_BLOCK*)b;
	if ( bb->flags & PPF_COMPRESSED ) {
		ptr = ptr1 = zlib_uncompress(&p_size,(char*)p->block,p->size);
		if ( ptr == 0 )
			return -1;
		ptr ++;
		p_size --;
		_ptr = d_alloc(p_size);
		memcpy(_ptr,ptr,p_size);
		d_f_ree(ptr1);
		free_flag = 1;
	}
	else {
		_ptr = (PRIMITIVE_PLOT*)p->block;
		p_size = p->size;
		free_flag = 0;
	}
	if ( bb->plot )
		free_internal_plot_list(bb->plot);
	if ( bb->flags & PPF_SAT ) {
		free_smp(&bb->sat);
		bb->plot = code2internal(bb->h.n.m,(PRIMITIVE_PLOT*)_ptr,p_size,&bb->sat);
	}
	else	bb->plot = code2internal(bb->h.n.m,(PRIMITIVE_PLOT*)_ptr,p_size,0);
	if ( free_flag )
		d_f_ree(_ptr);
	set_pp_density(bb);
	return 0;
}


MATRIX_ALLOC_BLOCK_PARAM *
pp_struct2block(MX_STRUCT_BLOCK * blk)
{
PP_STRUCT_BLOCK * b;
MATRIX_ALLOC_BLOCK_PARAM * ret;
RECORD_LIST64 * rl;
int p_size;
	b = (PP_STRUCT_BLOCK * )blk;
	
	ret = d_alloc(sizeof(*ret));
	memset(ret,0,sizeof(*ret));
	ret->block = internal2code(&ret->size,b->h.n.m,b->plot);
	ret->h.type = MDT_BLOCK;
	if ( b->flags & PPF_COMPRESSED ) {
		rl = new_recordlist64(0,0);
		set_recordlist_chain64(rl,&ret->h.type,sizeof(ret->h.type),0);
		set_recordlist_chain64(rl,ret->block,ret->size,1);
		p_size = setup_recordlist64(rl);
		
		ret->block = zlib_compress(&ret->size,rl->data,p_size,7);
		
		free_recordlist64(rl);
	}
	return ret;
}

int
pp_op_divide_check(MATRIX_NODE * n,INTERNAL_PLOT * p)
{
int *count;
int i;
int size;
int a,b;
int limit;
int ret;
int len,len2;
MATRIX * m;
	m = n->matrix;
	size = 1;
	for ( i = 0 ; i < m->p.dim ; i ++ ) {
		size *= ((int)1)<<m->dim_divide[i];
	}
	count = d_alloc(sizeof(int)*size);
	for ( i = 0 ; i < size ; i ++ ) {
		count[i] = 0;
	}
	for ( ; p ; p = p->next ) {
		a = 0;
		for ( i = 0 ; i < m->p.dim ; i ++ ) {
			b = p->c[i] >> (m->block_size[i] - m->dim_divide[i]);
			b &= (((int)1)<<m->dim_divide[i])-1;
			a |= b<<(m->dim_divide[i]*i);
		}
		count[a] ++;
	}
	limit = 1;
	for ( i = 0 ; i < m->p.dim ; i ++ ) {
		len = ((int)1)<<m->block_size[i];
		len2 = (m->pixel_size[i] - n->dim_code[i+1])>>(m->dim_divide[i]*n->dim_code[0]);
		if ( len2 < len )
			len = len2;
		limit *= len / (((int)1)<<(2*m->dim_divide[i]));
	}
	ret = 0;
	for ( i = 0 ; i < size ; i ++ )
		if ( count[i] > limit ) {
			ret = 1;
			break;
		}
	d_f_ree(count);
	return ret;
}

int
get_estimate_distance(MATRIX * m,INTERNAL_PLOT * p1,INTERNAL_PLOT * p2)
{
int d;
int i;
int shift;
int bit;
int max_shift;
int a,b;
int small;
int distance;
	d = m->p.dim;
	max_shift = -1;
	for ( i = 0 ; i < d ; i ++ ) {
		for ( shift = 0 ; shift < sizeof(short)*7 ; shift ++ ) {
			bit = 1<<shift;
			if ( (p1->c[i] & (-bit)) == (p2->c[i] & (-bit)) ) {
				shift --;
				break;
			}
		}
		if ( max_shift < shift )
			max_shift = shift;
	}
	if ( max_shift < 0 )
		return 0;
	bit = 1<<max_shift;
	distance = -1;
	for ( i = 0 ; i < d ; i ++ ) {
		a = p1->c[i] & (bit-1);
		b = bit - a;
		a++;
		if ( a < b )
			small = a;
		else	small = b;
		if ( distance < 0 || distance > small )
			distance = small;
	}
	return distance;
}

int
get_distance(MATRIX * m,INTERNAL_PLOT * p1,INTERNAL_PLOT * p2)
{
int i;
int d;
int md;
	md = 0;
	for ( i = 0 ; i < m->p.dim ; i ++ ) {
		d = p1->c[i] - p2->c[i];
		if ( d < 0 )
			d = -d;
		md += d;
	}
	return md;
}


void
set_pp_density_1(PP_STRUCT_BLOCK * b)
{
INTERNAL_PLOT * p, * q;
MATRIX * m;
MATRIX_NODE * n;
int min;
int md;
	m = b->h.n.m;
	n = b->h.n.n;
	
	if ( b->min >= 0 )
		return;
	min = -1;
	for ( p = b->plot ; p ; p = p->next ) {
		for ( q = p->next ; q ; q = q->next ) {
			md = get_distance(m,p,q);
			if ( md == 0 )
				continue;
			if ( p->min_direction < 0 || p->min_direction > md )
				p->min_direction = md;
			if ( q->min_direction < 0 || q->min_direction > md )
				q->min_direction = md;
			if ( min < 0 || min > md )
				min = md;
		}
	}
	b->min = min;
}

void
set_pp_density_2(PP_STRUCT_BLOCK * b)
{
INTERNAL_PLOT * p, * q;
MATRIX * m;
MATRIX_NODE * n;
int min;
int md,d;
	m = b->h.n.m;
	n = b->h.n.n;
	min = -1;
	for ( p = b->plot ; p ; p = p->next ) {
		q = p->prev;
		for ( ; q ; q = q->prev ) {
			md = get_distance(m,p,q);
			if ( md == 0 )
				continue;
			if ( p->min_direction < 0 || p->min_direction > md )
				p->min_direction = md;
			if ( q->min_direction < 0 || q->min_direction > md )
				q->min_direction = md;
			if ( min < 0 || min > md )
				min = md;
			d = get_estimate_distance(m,p,q);
			if ( d >= p->min_direction )
				break;
		}
		q = p->next;
		for ( ; q ; q = q->next ) {
			md = get_distance(m,p,q);
			if ( md == 0 )
				continue;
			if ( p->min_direction < 0 || p->min_direction > md )
				p->min_direction = md;
			if ( q->min_direction < 0 || q->min_direction > md )
				q->min_direction = md;
			if ( min < 0 || min > md )
				min = md;
			d = get_estimate_distance(m,p,q);
			if ( d >= p->min_direction )
				break;
		}
	}
}


void
set_pp_density(PP_STRUCT_BLOCK * b)
{
INTERNAL_PLOT * p, * q;
int i;
MATRIX * m;
MATRIX_NODE * n;
int min;
	m = b->h.n.m;
	n = b->h.n.n;
	
	if ( b->min >= 0 )
		return;
	min = -1;
	q = 0;
	i = 0;
	for ( p = b->plot ; p ; p = p->next ) {
		p->min_direction = -1;
		p->prev = q;
		q = p;
		i ++;
	}
	if ( i >= 0 )
		set_pp_density_2(b);
	else	set_pp_density_1(b);
}


void
set_pp_array(PP_STRUCT_BLOCK * b)
{
int i;
int ix_size;
MATRIX * m;
MATRIX_NODE* n;
INTEGER64 tsize,ssize;
INTERNAL_PLOT * p;
int c,w;
	m = b->h.n.m;
	n = b->h.n.n;

	if ( b->ary == 0 ) {
		b->ary_size = d_alloc(sizeof(int)*m->p.dim);
		ix_size = 1;
		for ( i = 0 ; i < m->p.dim ; i ++ ) {
			tsize = m->pixel_size[i] - n->dim_code[i+1];
			tsize = tsize >> (m->dim_divide[i]*n->dim_code[0]);
			ssize = ((INTEGER64)1)<<m->block_size[i];
			if ( ssize > tsize )
				ssize = tsize;
			b->ary_size[i] = ssize;
			ix_size *= ssize;
		}
		b->ary = d_alloc(sizeof(INTERNAL_PLOT*)*ix_size);
	}
	memset(b->ary,0,sizeof(INTERNAL_PLOT*)*ix_size);
	for ( p = b->plot ; p ; p = p->next ) {
		p->min_direction = -1;
		c = 0;
		w = 1;
		for ( i = 0 ; i < m->p.dim ; i ++ ) {
			c += w*p->c[i];
			w *= b->ary_size[i];
		}
		b->ary[c] = p;
	}
}


int
pp_operation(int cmd,MX_STRUCT_BLOCK * blk,void * param)
{
INTERNAL_PLOT * pt;
PP_STRUCT_BLOCK * b;
PPC_INSERT_T * ins;
INTERNAL_PLOT ** ptp;
	b = (PP_STRUCT_BLOCK *)blk;
	switch ( cmd ) {
	case PPC_INSERT:
		ins = (PPC_INSERT_T*)param;
		pt = make_plot(b->h.n.m,ins->level,ins->crd,ins->fields);
		if ( pt == 0 )
			return -1;
		pt->next = b->plot;
		b->plot = pt;
		get_matrix_update_time(b->h.n.n,b->h.n.channel,UT_SB);
		break;
	case PPC_DELETE:
		return -1;
	case PPC_SORT:
		b->plot = sort_plot(b->h.n.m,b->plot);
		get_matrix_update_time(b->h.n.n,b->h.n.channel,UT_SB);
		break;
	case PPC_DIVIDE_CHECK:
		return pp_op_divide_check(b->h.n.n,b->plot);
	case PPC_GET_AND_CLEAR:
		ptp = (INTERNAL_PLOT**)param;
		*ptp = b->plot;
		b->plot = 0;
		get_matrix_update_time(b->h.n.n,b->h.n.channel,UT_SB);
		return 0;
	case PPC_GET:
		ptp = (INTERNAL_PLOT**)param;
		*ptp = b->plot;
		return 0;
	case PPC_SET:
		pt = (INTERNAL_PLOT*)param;
		free_internal_plot_list(b->plot);
		b->plot = pt;
		change_st_internal_plot(b->plot);
		get_matrix_update_time(b->h.n.n,b->h.n.channel,UT_SB);
		return 0;
	case PPC_ARRAY:
		set_pp_array(b);
		break;
	case PPC_FREE_ARRAY:
		if ( b->ary ) {
			d_f_ree(b->ary_size);
			d_f_ree(b->ary);
		}
		b->ary_size = 0;
		b->ary = 0;
		break;
	case PPC_DENSITY:
		set_pp_density(b);
		break;
	default:
		return -2;
	}
	return 0;
}

void
gc_fd_opt(FD_OPT * p)
{
	for ( ; p ; p = p->h.next ) {
		if ( TEST_AND_SET(p) )
			break;
		gc_gb_sexp(p->h.init_sexp);
		if ( field_type_tbl[p->h.merge_type>>CH_TYPE_SHIFT].gc )
			(*field_type_tbl[p->h.merge_type>>CH_TYPE_SHIFT].gc)(p);
	}
}


void
gc_fd_opt_ptr(FD_OPT_PTR * p)
{
	if ( p == 0 )
		return;
	if ( TEST_AND_SET(p) )
		return;
	gc_fd_opt(p->opt);
}


/*
	(mxPgPlotDiff childrenCHprimitiveList)
	RETURN
	(List myCHprimitive childrenCHdifferenceList....)
*/
XL_SEXP*
xl_mxPgPlotDiff(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV* a,XL_SYM_FIELD * sf)
{
char * err_msg;
XL_SEXP * target_list;
XL_SEXP * sym,*sample;
XL_SEXP * dc;
INTEGER64 * dim_code1;
INTERNAL_PLOT * _ret,*_ch,*up,*df;
L_CHAR * compress,*sort;
int _compress_flag;
int _sort_flag;

MATRIX_TOKEN * t;
MATRIX * m;
MATRIX_ALLOC_BLOCK_PARAM * d1,pb;
char * pp,* ptr;
int p_size;
int free_flag;
XL_SEXP * ret1,*ret2;

RECORD_LIST64 * rl;
void * d;

ss_printf("mxPgPlotDiff\n");

	t = get_env_work(env);
	if ( t == 0 )
		return 0;
	m = t->process_node->matrix;
ss_printf("mxPgPlotDiff-1\n");


	compress = get_sf_attribute(sf,l_string(std_cm,"compress"));
	if ( compress == 0 )
		_compress_flag = 0;
	else if ( l_strcmp(compress,l_string(std_cm,"on")) == 0 )
		_compress_flag = 1;
	else if ( l_strcmp(compress,l_string(std_cm,"off")) == 0 )
		_compress_flag = 0;
	else {
		err_msg = "compress";
		goto inv_param;
	}

ss_printf("mxPgPlotDiff-2\n");

	sort = get_sf_attribute(sf,l_string(std_cm,"sort"));
	if ( sort == 0 )
		_sort_flag = 0;
	else if ( l_strcmp(sort,l_string(std_cm,"on")) == 0 )
		_sort_flag = 1;
	else if ( l_strcmp(sort,l_string(std_cm,"off")) == 0 )
		_sort_flag = 0;
	else {
		err_msg = "sort";
		goto inv_param;
	}

ss_printf("mxPgPlotDiff-3\n");

	target_list = get_el(s,1);
	err_msg = "target-list not a LIST";
	if ( get_type(target_list) != XLT_PAIR )
		goto type_missmatch;
	sym = car(target_list);
	err_msg = "target-list SYMBOL not aSYMBOL";
	if ( get_type(sym) != XLT_SYMBOL )
		goto type_missmatch;
	if ( l_strcmp(sym->symbol.data,l_string(std_cm,"data")) == 0 ) {
		sample = target_list;
		target_list = cons(target_list,0);
	}
	else if ( l_strcmp(sym->symbol.data,l_string(std_cm,"Children")) == 0 ) {
		target_list = cdr(target_list);
		sample = car(target_list);
	}
	else {
		err_msg = "target-list data or Children is required";
		goto type_missmatch;
	}
	
ss_printf("mxPgPlotDiff-4\n");
print_sexp(s_stdout,target_list,0);
ss_printf("\n");

	dim_code1 = 0;
	_ret = 0;
	ret1 = 0;
	for ( ; get_type(target_list) == XLT_PAIR ; target_list = cdr(target_list) ) {
		dc = car(target_list);
		if ( dim_code1 )
			d_f_ree(dim_code1);
		dim_code1 = get_dim_code_from_sexp(m,get_el(dc,1));
		d1 = get_vdata_from_sexp(get_el(dc,2));
		err_msg = "CH data type(2)";
		if ( d1 == 0 )
			goto type_missmatch;
ss_printf("mxPgPlotDiff-5-prev %i\n",d1->size);
		if ( _compress_flag ) {
			ptr = pp = zlib_uncompress(&p_size,d1->block,d1->size);
			err_msg = "zlib uncompress";
			if ( pp == 0 )
				goto inv_param;
			ptr ++;
			p_size --;
			free_flag = 1;
		}
		else {
			p_size = d1->size;
			ptr = pp = d1->block;
			free_flag = 0;
		}
ss_printf("mxPgPlotDiff-5 %i\n",p_size);
		_ch = code2internal(m,(PRIMITIVE_PLOT*)ptr,p_size,0);
/*
		err_msg = "internal plot code";
		if ( _ch == 0 )
			goto inv_param;
*/
		if ( _sort_flag )
			_ch = sort_plot(m,_ch);

ss_printf("mxPgPlotDiff-7 %s %p\n",pt_dc(m,dim_code1,PTDC_NODE_ID),_ch);
//print_internal_plot(m,_ch,"mxPgPlotDiff-7");
//check_internal_plot(m,_ch,"mxPgPlotDiff-5-1");
		up = diff_pp(m,&df,_ch);
ss_printf("mxPgPlotDiff-8\n");
		_ret = shift_insert_plot(m,_ret,up,dim_code1);
ss_printf("mxPgPlotDiff-9 %i\n",get_internal_plot_len(_ret));
//check_internal_plot(m,_ret,"mxPgPlotDiff-5-2");

		pb.block = (void*)internal2code(&pb.size,m,df);
		pb.h.type = MDT_BLOCK;
		free_internal_plot_list(_ch);
//		free_internal_plot_list(up);
ss_printf("mxPgPlotDiff-10\n");
		if ( _compress_flag ) {
			rl = new_recordlist64(0,0);
			set_recordlist_chain64(rl,&pb.h.type,sizeof(pb.h.type),0);
			set_recordlist_chain64(rl,pb.block,pb.size,1);
			p_size = setup_recordlist64(rl);
			
			pb.block = zlib_compress(&pb.size,rl->data,p_size,7);
			
			free_recordlist64(rl);
		}
ss_printf("mxPgPlotDiff-11\n");
		d = (*mx_type_block.alloc_data)(&mx_type_block,MD_MMALLOC,&pb,0,
				__FILE__,__LINE__);
		d_f_ree(pb.block);

		ret1 = cons(List(n_get_symbol("data"),
			get_sexp_from_dim_code(m,dim_code1),
			get_ptr(d,gc_mtx_block),
			-1),ret1);
		
		if ( free_flag )
			d_f_ree(pp);
	}
	ret1 = reverse(ret1);
	if ( dim_code1 )
		d_f_ree(dim_code1);
ss_printf("mxPgPlotDiff-6 %i\n",get_internal_plot_len(_ret));

	pb.block = (void*)internal2code(&pb.size,m,_ret);
	pb.h.type = MDT_BLOCK;
ss_printf("mxPgPlotDiff-6 c-size = %i %s\n",pb.size,pt_dc(m,t->process_node->dim_code,PTDC_NODE_ID));
	if ( _compress_flag ) {
		rl = new_recordlist64(0,0);
		set_recordlist_chain64(rl,&pb.h.type,sizeof(pb.h.type),0);
		set_recordlist_chain64(rl,pb.block,pb.size,1);
		p_size = setup_recordlist64(rl);
		
		pb.block = zlib_compress(&pb.size,rl->data,p_size,7);
		
		free_recordlist64(rl);
		d = (*mx_type_block.alloc_data)(&mx_type_block,MD_MMALLOC,&pb,0,
				__FILE__,__LINE__);
	}
	else {
		d = (*mx_type_block.alloc_data)(&mx_type_block,MD_MMALLOC,&pb,0,
				__FILE__,__LINE__);
		d_f_ree(pb.block);
	}
ss_printf("mxPgPlotDiff-END %i\n",pb.size);

	return cons(List(n_get_symbol("data"),
		get_sexp_from_dim_code(m,t->process_node->dim_code),
		get_ptr(d,gc_mtx_block),
		-1),ret1);



type_missmatch:
	ret2 = get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"mxPgPlotDiff"),
		List(n_get_string("type missmatch"),n_get_string(err_msg),s,-1));
	return ret2;
inv_param:
	ret2 = get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"mxPgPlotDiff"),
		List(n_get_string("invalid parameter in mxPgPlotDiff"),n_get_string(err_msg),-1));
	return ret2;
}

/*
	(mxPgPlotDiff CHdata)
	RETURN
	CHdata
*/
XL_SEXP*
xl_mxPgPlotSort(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV* a,XL_SYM_FIELD * sf)
{
XL_SEXP *dc;
INTEGER64 * dim_code1;
MATRIX_ALLOC_BLOCK_PARAM * d1,pb;
L_CHAR * compress;
int _compress_flag;
int p_size;
char * ptr,*pp;
int free_flag;
char * err_msg;
INTERNAL_PLOT * _ch;
RECORD_LIST64 * rl;
void * d;
XL_SEXP * ret;
MATRIX_TOKEN * t;
MATRIX * m;

	t = get_env_work(env);
	if ( t == 0 )
		return 0;
	m = t->process_node->matrix;

	compress = get_sf_attribute(sf,l_string(std_cm,"compress"));
	if ( compress == 0 )
		_compress_flag = 0;
	else if ( l_strcmp(compress,l_string(std_cm,"on")) == 0 )
		_compress_flag = 1;
	else if ( l_strcmp(compress,l_string(std_cm,"off")) == 0 )
		_compress_flag = 0;
	else {
		err_msg = "compress";
		goto inv_param;
	}

	dc = get_el(s,1);
	dim_code1 = get_dim_code_from_sexp(m,get_el(dc,1));
	d1 = get_vdata_from_sexp(get_el(dc,2));
	err_msg = "CH data type(2)";
	if ( d1 == 0 )
		goto type_missmatch;
	if ( _compress_flag ) {
		ptr = pp = zlib_uncompress(&p_size,d1->block,d1->size);
		err_msg = "zlib uncompress";
		if ( pp == 0 )
			goto inv_param;
		ptr ++;
		p_size --;
		free_flag = 1;
	}
	else {
		p_size = d1->size;
		ptr = pp = d1->block;
		free_flag = 0;
	}
	_ch = code2internal(m,(PRIMITIVE_PLOT*)ptr,p_size,0);
	err_msg = "internal plot code";
	if ( _ch == 0 )
		goto inv_param;
	_ch = sort_plot(m,_ch);
	pb.block = (void*)internal2code(&pb.size,m,_ch);
	pb.h.type = MDT_BLOCK;
	free_internal_plot_list(_ch);
	if ( _compress_flag ) {
		rl = new_recordlist64(0,0);
		set_recordlist_chain64(rl,&pb.h.type,sizeof(pb.h.type),0);
		set_recordlist_chain64(rl,pb.block,pb.size,1);
		p_size = setup_recordlist64(rl);
		
		pb.block = zlib_compress(&pb.size,rl->data,p_size,7);
		
		free_recordlist64(rl);
	}
	d = (*mx_type_block.alloc_data)(&mx_type_block,MD_MMALLOC,&pb,0,
			__FILE__,__LINE__);
	d_f_ree(pb.block);

	ret = List(n_get_symbol("data"),
		get_sexp_from_dim_code(m,dim_code1),
		get_ptr(d,gc_mtx_block),
		-1);

	d_f_ree(dim_code1);

	return ret;
	
type_missmatch:
	ret = get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"mxPgPlotSort"),
		List(n_get_string("type missmatch"),n_get_string(err_msg),-1));
	return ret;
inv_param:
	ret = get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"mxPgPlotSort"),
		List(n_get_string("invalid parameter in mxPgPlotDiff"),n_get_string(err_msg),-1));
	return ret;
}


/*
	(mxPgPlotDiff childrenCHprimitiveList)
	RETURN
	(List myCHprimitive childrenCHdifferenceList)
*/
XL_SEXP*
xl_mxPgPlotAdd(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV* a,XL_SYM_FIELD * sf)
{
char * err_msg;
XL_SEXP * parent,*child;
XL_SEXP * sym;
XL_SEXP * dc;
INTEGER64 * p_dc,*c_dc;
INTERNAL_PLOT * _ret,*p_code,*c_code;
L_CHAR * compress;
int _compress_flag;

MATRIX_TOKEN * t;
MATRIX * m;
MATRIX_ALLOC_BLOCK_PARAM * pp,*cp,pb;
char * p_ptr1,* p_ptr2;
char * c_ptr1,* c_ptr2;
int p_size,c_size;
int p_free_flag,c_free_flag;
XL_SEXP *ret2;

RECORD_LIST64 * rl;
void * d;
XL_SEXP * err_sexp;


SIMPLE_ALLOC_T p_sat,c_sat,a_sat;

//ss_printf("ADD-0\n");
	t = get_env_work(env);
	if ( t == 0 )
		return 0;
	m = t->process_node->matrix;

	compress = get_sf_attribute(sf,l_string(std_cm,"compress"));
	if ( compress == 0 )
		_compress_flag = 0;
	else if ( l_strcmp(compress,l_string(std_cm,"on")) == 0 )
		_compress_flag = 1;
	else if ( l_strcmp(compress,l_string(std_cm,"off")) == 0 )
		_compress_flag = 0;
	else {
		err_msg = "compress";
		goto inv_param;
	}

	parent = get_el(s,1);
	err_msg = "parent not a LIST";
	err_sexp = s;
	if ( get_type(parent) != XLT_PAIR )
		goto type_missmatch;
	sym = car(parent);
	err_msg = "parent SYMBOL not aSYMBOL";
	if ( get_type(sym) != XLT_SYMBOL )
		goto type_missmatch;
	if ( l_strcmp(sym->symbol.data,l_string(std_cm,"data")) ) {
		err_msg = "parent data is required";
		goto type_missmatch;
	}
	dc = get_el(parent,1);
	p_dc = get_dim_code_from_sexp(m,dc);
	pp = get_vdata_from_sexp(get_el(parent,2));
	err_msg = "parent CH data type(2)";
	if ( pp == 0 )
		goto type_missmatch;

	child = get_el(s,2);
	err_msg = "child not a LIST";
	if ( get_type(child) != XLT_PAIR )
		goto type_missmatch;
	sym = car(child);
	err_msg = "child SYMBOL not aSYMBOL";
	if ( get_type(sym) != XLT_SYMBOL )
		goto type_missmatch;
	if ( l_strcmp(sym->symbol.data,l_string(std_cm,"data")) ) {
		err_msg = "child data is required";
		goto type_missmatch;
	}
	dc = get_el(child,1);
	c_dc = get_dim_code_from_sexp(m,dc);
	cp = get_vdata_from_sexp(get_el(child,2));
	err_msg = "child CH data type(2)";
	if ( cp == 0 )
		goto type_missmatch;

	if ( _compress_flag ) {
		p_ptr1 = p_ptr2 = zlib_uncompress(&p_size,pp->block,pp->size);
		err_msg = "zlib uncompress parent";
		if ( p_ptr1 == 0 )
			goto inv_param;
		p_ptr1 ++;
		p_size --;
		p_free_flag = 1;
	}
	else {
		p_size = pp->size;
		p_ptr1 = p_ptr2 = pp->block;
		p_free_flag = 0;
	}
//ss_printf("ADD-0-1\n");
	p_code = code2internal(m,(PRIMITIVE_PLOT*)p_ptr1,p_size,&p_sat);
//ss_printf("ADD-0-2\n");
	err_msg = "parent internal plot code";
	if ( p_code == 0 )
		goto inv_param;

	if ( _compress_flag ) {
		c_ptr1 = c_ptr2 = zlib_uncompress(&c_size,cp->block,cp->size);
		err_msg = "zlib uncompress child";
		if ( c_ptr1 == 0 )
			goto inv_param;
		c_ptr1 ++;
		c_size --;
		c_free_flag = 1;
	}
	else {
		c_size = cp->size;
		c_ptr1 = c_ptr2 = cp->block;
		c_free_flag = 0;
	}
//ss_printf("ADD-0-3\n");
	c_code = code2internal(m,(PRIMITIVE_PLOT*)c_ptr1,c_size,&c_sat);
//ss_printf("ADD-0-4\n");
	err_msg = "child internal plot code";
	if ( c_code == 0 )
		goto inv_param;
//ss_printf("ADD-1\n");
	smp_init(&a_sat);
	_ret = add_diff(m,p_code,c_code,c_dc,&a_sat);
//ss_printf("ADD-2\n");
	pb.block = (void*)internal2code(&pb.size,m,_ret);
//ss_printf("ADD-3 %p\n",pb.block);
	pb.h.type = MDT_BLOCK;
	if ( _compress_flag ) {
		rl = new_recordlist64(0,0);
		set_recordlist_chain64(rl,&pb.h.type,sizeof(pb.h.type),0);
		set_recordlist_chain64(rl,pb.block,pb.size,1);
		p_size = setup_recordlist64(rl);
		
		pb.block = zlib_compress(&pb.size,rl->data,p_size,7);
//ss_printf("ADD-4 %p\n",pb.block);
		
		free_recordlist64(rl);
	}
	d = (*mx_type_block.alloc_data)(&mx_type_block,MD_MMALLOC,&pb,0,
			__FILE__,__LINE__);
	d_f_ree(pb.block);

	d_f_ree(p_dc);
	d_f_ree(c_dc);
/*
	free_internal_plot_list(p_code);
	free_internal_plot_list(c_code);
*/
	free_smp(&p_sat);
	free_smp(&c_sat);
	free_smp(&a_sat);

	if ( p_free_flag )
		d_f_ree(p_ptr2);
	if ( c_free_flag )
		d_f_ree(c_ptr2);
//ss_printf("ADD-END\n");
	return List(n_get_symbol("data"),
		get_sexp_from_dim_code(m,t->process_node->dim_code),
		get_ptr(d,gc_mtx_block),
		-1);


type_missmatch:
	ret2 = get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"mxPgPlotAdd"),
		List(n_get_string("type missmatch"),n_get_string(err_msg),err_sexp,-1));
	return ret2;
inv_param:
	ret2 = get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"mxPgPlotAdd"),
		List(n_get_string("invalid parameter in mxPgPlotDiff"),n_get_string(err_msg),err_sexp,-1));
	return ret2;
}

/*
	(mxPgPlotDiff childrenCHprimitiveList)
	RETURN
	(List myCHprimitive childrenCHdifferenceList)
*/
XL_SEXP*
xl_mxPgPlotInitialize(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV* a,XL_SYM_FIELD * sf)
{
char * err_msg;
L_CHAR * compress;

MATRIX_TOKEN * t;
MATRIX * m;
XL_SEXP *ret2;


L_CHAR * channel;
int _ch;
PP_SB_NEW sb_new;
MX_SB_NEW sb_new_mx;
MATRIX_NODE * n;

L_CHAR * sat;

	t = get_env_work(env);
	if ( t == 0 )
		return 0;
	m = t->process_node->matrix;
	n = t->process_node;

	compress = get_sf_attribute(sf,l_string(std_cm,"compress"));
	if ( compress == 0 )
		sb_new.flags = 0;
	else if ( l_strcmp(compress,l_string(std_cm,"on")) == 0 )
		sb_new.flags = PPF_COMPRESSED;
	else if ( l_strcmp(compress,l_string(std_cm,"off")) == 0 )
		sb_new.flags = 0;
	else {
		err_msg = "compress";
		goto inv_param;
	}
	channel = get_sf_attribute(sf,l_string(std_cm,"channel"));
	_ch = atoi(n_string(std_cm,channel));
	matrix_node_channel_lock(t->process_node);
	if ( _ch < 0 || _ch >= m->p.channel_nos ) {
		err_msg = "channel range";
		matrix_node_channel_unlock(t->process_node,0);
		goto inv_param;
	}
	if ( m->channel_info[_ch].data_type != &mx_type_block ) {
		err_msg = "channel data type is not BLOCK";
		matrix_node_channel_unlock(t->process_node,0);
		goto inv_param;
	}
	if ( n->channel[_ch].sb )
		(*n->channel[_ch].sb->tbl->free_sb)(n->channel[_ch].sb);
	
	sat = get_sf_attribute(sf,l_string(std_cm,"sat"));
	if ( sat == 0 )
		;
	else if ( l_strcmp(sat,l_string(std_cm,"on")) == 0 )
		sb_new.flags |= PPF_SAT;
	else if ( l_strcmp(sat,l_string(std_cm,"off")) == 0 )
		;
	else {
		err_msg = "attribute sat";
		goto inv_param;
	}
	sb_new.data = 0;
	sb_new.size = 0;
	sb_new_mx.n = t->process_node;
	sb_new_mx.m = m;
	sb_new_mx.channel = _ch;
	n->channel[_ch].sb = pp_new_sb(&sb_new_mx,(void *)&sb_new);
	if ( n->channel[_ch].sb == 0 )
		er_panic("insert");

	matrix_node_channel_unlock(t->process_node,0);
	
	return 0;
/*
type_missmatch:
	ret2 = get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"mxPgPlotDiff"),
		List(n_get_string("type missmatch"),n_get_string(err_msg),-1));
	return ret2;
*/
inv_param:
	ret2 = get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"mxPgPlotDiff"),
		List(n_get_string("invalid parameter in mxPgPlotDiff"),n_get_string(err_msg),-1));
	return ret2;
}

void
init_mxPgPlot(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"mxPgPointColor"),get_integer(LABEL_POINT_COLOR,0));
	set_env(env,l_string(std_cm,"mxPgPointImg"),get_integer(LABEL_POINT_IMG,0));
	set_env(env,l_string(std_cm,"mxPgPointColor"),get_integer(LABEL_POINT_COLOR,0));

	set_env(env,l_string(std_cm,"mxPgNONE"),get_integer(CH_NONE,0));
	set_env(env,l_string(std_cm,"mxPgSTRING"),get_integer(CH_NONE,0));
	set_env(env,l_string(std_cm,"mxPgSTRING_INHERIT"),get_integer(CH_STRING_INHERIT,0));
	set_env(env,l_string(std_cm,"mxPgSTRING_ERASE"),get_integer(CH_STRING_ERASE,0));
	set_env(env,l_string(std_cm,"mxPgINT_ADD"),get_integer(CH_INT_ADD,0));
	set_env(env,l_string(std_cm,"mxPgINT_AVG"),get_integer(CH_INT_AVG,0));
	set_env(env,l_string(std_cm,"mxPgINT_MAX"),get_integer(CH_INT_MAX,0));
	set_env(env,l_string(std_cm,"mxPgINT_MIN"),get_integer(CH_INT_MIN,0));
	set_env(env,l_string(std_cm,"mxPgRGBA"),get_integer(CH_RGBA,0));

	set_env(env,l_string(std_cm,"mxPgTYPE_NONE"),get_integer(CH_TYPE_NONE,0));
	set_env(env,l_string(std_cm,"mxPgTYPE_STRING"),get_integer(CH_TYPE_STRING,0));
	set_env(env,l_string(std_cm,"mxPgTYPE_INT"),get_integer(CH_TYPE_INT,0));
	set_env(env,l_string(std_cm,"mxPgTYPE_RGBA"),get_integer(CH_TYPE_RGBA,0));

	set_env(env,l_string(std_cm,"mxPgFDIT_INT"),get_integer(FDIT_INT,0));
	set_env(env,l_string(std_cm,"mxPgFDIT_FLOAT"),get_integer(FDIT_FLOAT,0));
	set_env(env,l_string(std_cm,"mxPgFDIT_DD"),get_integer(FDIT_DD,0));
	set_env(env,l_string(std_cm,"mxPgFDIT_DDMMSS"),get_integer(FDIT_DDMMSS,0));


	set_env(env,l_string(std_cm,"mxPgPlotDiff"),
		get_func_prim(xl_mxPgPlotDiff,FO_APPLICATIVE,0,2,2));
	set_env(env,l_string(std_cm,"mxPgPlotSort"),
		get_func_prim(xl_mxPgPlotSort,FO_APPLICATIVE,0,2,2));
	set_env(env,l_string(std_cm,"mxPgPlotAdd"),
		get_func_prim(xl_mxPgPlotAdd,FO_APPLICATIVE,0,3,3));
	set_env(env,l_string(std_cm,"mxPgPlotInitialize"),
		get_func_prim(xl_mxPgPlotInitialize,FO_APPLICATIVE,0,1,1));
}


