/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include "bezier2points.h"
#include "utils.h"

void bezier2points(SVG_POINT *dest, int dest_point_count, SVG_POINT *src, int n)
{
	int i;
	double u;
	if(n==2){ /* 2D spline */
		for(i=0; i<dest_point_count-1; ++i){
			u = ((double)i)/(dest_point_count-1);
			dest[i].x = (src[0].x * (1-u)*(1-u)) +
						(src[1].x * 2*u*(1-u)) +
						(src[2].x * u*u);
			
			dest[i].y = (src[0].y * (1-u)*(1-u)) +
						(src[1].y * 2*u*(1-u)) +
						(src[2].y * u*u);
		}
	}
	else if(n==3){ /* 3D spline */
		for(i=0; i<dest_point_count-1; ++i){
			u = ((double)i)/(dest_point_count-1);
			dest[i].x = (src[0].x * (1-u)*(1-u)*(1-u)) +
						(src[1].x * 3*u*(1-u)*(1-u)) +
						(src[2].x * 3*u*u*(1-u)) +
						(src[3].x * u*u*u);
			
			dest[i].y = (src[0].y * (1-u)*(1-u)*(1-u)) +
						(src[1].y * 3*u*(1-u)*(1-u)) +
						(src[2].y * 3*u*u*(1-u)) +
						(src[3].y * u*u*u);
			
		}
	}
	else{
		er_panic("unsupported bezier type. only 2d or 3d spline supported.");
	}
	dest[dest_point_count-1] = src[n];
}
