/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	<stdlib.h>
#include	"memory_debug.h"
#include	"ex_matrix.h"


EX_MATRIX *
new_ex_matrix(int v,int h)
{
EX_MATRIX * ret;
EX_MATRIX m;
int size,i;
	m.h_size = h;
	m.v_size = v;
	ret = d_alloc(size=((int)(&XD(&m,v,0)))-((int)&m));
	for ( i = 0 ; i < h*v ; i ++ )
		ret->d[i] = 0;
	ret->h_size = h;
	ret->v_size = v;

	return ret;
}

EX_MATRIX *
new_ex_matrix_E(int v)
{
EX_MATRIX * ret;
int i;
	ret = new_ex_matrix(v,v);
	for ( i = 0 ; i < v ; i ++ )
		XD(ret,i,i) = 1;
	return ret;
}

void
free_ex_matrix(EX_MATRIX * m)
{
	d_f_ree(m);
}

EX_MATRIX *
add_ex(EX_MATRIX * m1,EX_MATRIX * m2)
{
int i;
EX_MATRIX * ret;
int h,v;
	if ( m1->h_size != m2->h_size )
		return 0;
	if ( m1->v_size != m2->v_size )
		return 0;
	h = m1->h_size;
	v = m1->v_size;
	ret = new_ex_matrix(v,h);
	for ( i = 0 ; i < m1->h_size * m1->v_size ; i ++ )
		ret->d[i] = m1->d[i] + m2->d[i];
	return ret;
}

EX_MATRIX *
sub_ex(EX_MATRIX * m1,EX_MATRIX * m2)
{
int i;
EX_MATRIX * ret;
int h,v;

	if ( m2 ) {
		if ( m1->h_size != m2->h_size )
			return 0;
		if ( m1->v_size != m2->v_size )
			return 0;
		h = m1->h_size;
		v = m1->v_size;
		ret = new_ex_matrix(v,h);
		for ( i = 0 ; i < m1->h_size * m1->v_size ; i ++ )
			ret->d[i] = m1->d[i] - m2->d[i];
		return ret;
	}
	else {
		h = m1->h_size;
		v = m1->v_size;
		ret = new_ex_matrix(v,h);
		for ( i = 0 ; i < m1->h_size * m1->v_size ; i ++ )
			ret->d[i] =  - m1->d[i];
		return ret;
	}
}

EX_MATRIX * 
mul_ex(EX_MATRIX * m1,EX_MATRIX * m2)
{
EX_MATRIX * ret;
int x,y,i,len;
int h,v;
double acc;
	if ( m1->h_size != m2->v_size )
		return 0;
	len = m1->h_size;
	ret = new_ex_matrix(v = m1->v_size,h = m2->h_size);
	for ( x = 0 ; x < h ; x ++ )
		for ( y = 0 ; y < v ; y ++ ) {
			acc = 0;
			for ( i= 0 ; i < len ; i ++ )
				acc += XD(m1,y,i)*XD(m2,i,x);
			XD(ret,y,x) = acc;
		}
	return ret;
}

double
inner_ex(int * er,EX_MATRIX * m1,EX_MATRIX * m2)
{
double ret;
int i,size;
	*er = -1;

	if ( m1->h_size != m2->h_size )
		return 0;
	if ( m1->v_size != m2->v_size )
		return 0;
	if ( m1->h_size != 1 && m1->v_size != 1 )
		return 0;
	size = m1->h_size* m1->v_size;
	ret = 0;
	for ( i = 0 ; i < size ; i ++ )
		ret += m1->d[i] * m2->d[i];
	*er = 0;
	return ret;
}


EX_MATRIX *
get_ex_from_sexp(XL_SEXP * s)
{
XL_SEXP * sym;
L_CHAR * h, * v;
int _h,_v;
EX_MATRIX * ret;
int i;
XL_SEXP * d;

	if ( get_type(s) != XLT_PAIR )
		return 0;
	sym = car(s);
	if ( get_type(sym) != XLT_SYMBOL )
		return 0;
	h = get_sf_attribute(sym->symbol.field,l_string(std_cm,"h"));
	v = get_sf_attribute(sym->symbol.field,l_string(std_cm,"v"));
	if ( h )
		_h = atoi(n_string(std_cm,h));
	else	_h = 1;
	if ( _h == 0 )
		_h = 1;
	if ( v )
		_v = atoi(n_string(std_cm,v));
	else	_v = 1;
	if ( _v == 0 )
		_v = 1;
	ret = new_ex_matrix(_v,_h);
	s = cdr(s);
	for ( i = 0 ; i < _v*_h ; i ++ , s = cdr(s) ) {
		if ( get_type(s) != XLT_PAIR )
			goto err;
		d = car(s);
		switch ( get_type(d) ) {
		case XLT_INTEGER:
			ret->d[i] = d->integer.data;
			break;
		case XLT_FLOAT:
			ret->d[i] = d->floating.data;
			break;
		default:
			goto err;
		}
	}
	return ret;
err:
	free_ex_matrix(ret);
	return 0;
}

XL_SEXP *
get_sexp_from_ex(EX_MATRIX * m)
{
XL_SEXP * ret;
XL_SEXP * sym;
char buf[10];
int total,i;

	sym = n_get_symbol("matrix");
	sprintf(buf,"%i",m->v_size);
	set_attribute(sym,
		l_string(std_cm,"v"),
		l_string(std_cm,buf));
	sprintf(buf,"%i",m->h_size);
	set_attribute(sym,
		l_string(std_cm,"h"),
		l_string(std_cm,buf));
	ret = cons(sym,0);
	total = m->v_size*m->h_size;
	for ( i = 0 ; i < total ; i ++ )
		ret = cons(get_floating(m->d[i],0),ret);
	return reverse(ret);
}

EX_MATRIX *
copy_ex(EX_MATRIX * org)
{
EX_MATRIX * ret;
int vh;
int i;
	ret = new_ex_matrix(org->v_size,org->h_size);
	vh = org->v_size * org->h_size;
	for ( i = 0 ; i < vh ; i ++ )
		ret->d[i] = org->d[i];
	return ret;
}


int
ex_uppertriangle(EX_MATRIX * m1,EX_MATRIX * m2,int * index)
{
int i,j,k;
int v,m2_h;
double max_abs,max,d,a;
int max_target;
	if ( m1->v_size != m1->h_size )
		return -1;
	if ( m1->v_size != m2->v_size )
		return -2;
	v = m1->v_size;
	m2_h = m2->h_size;
	if ( index ) {
		for ( i = 0 ; i < v ; i ++ )
			index[i] = i;
	}
	for ( i = 0 ; i < v ; i ++ ) {
		max_abs = 0;
		max = 0;
		for ( j = i ; j < v ; j ++ ) {
			d = XD(m1,j,j);
			if ( d < 0 )
				a = -d;
			else	a = d;
			if ( a > max_abs ) {
				max_abs = a;
				max = d;
				max_target = j;
			}
		}
		if ( max_abs == 0 )
			return -3;
		j = max_target;
		if ( j != i ) {
			for ( k = i ; k < v ; k ++ ) {
				a = XD(m1,i,k);
				XD(m1,i,k) = XD(m1,j,k);
				XD(m1,j,k) = a;
			}
			for ( k = 0 ; k < m2_h ; k ++ ) {
				a = XD(m2,i,k);
				XD(m2,i,k) = XD(m2,j,k);
				XD(m2,j,k) = a;
			}
			if ( index ) {
				k = index[i];
				index[i] = index[j];
				index[j] = k;
			}
		}
		for ( j = i + 1 ; j < v ; j ++ ) {
			a = XD(m1,j,i)/XD(m1,i,i);
			XD(m1,j,i) = 0;
			for ( k = i+1 ; k < v ; k ++ )
				XD(m1,j,k) = XD(m1,j,k) - XD(m1,i,k)*a;
			for ( k = 0 ; k < m2_h ; k ++ )
				XD(m2,j,k) = XD(m2,j,k) - XD(m2,i,k)*a;
		}
	}
	return 0;
}

EX_MATRIX *
ex_equation(int * erp,EX_MATRIX * m1,EX_MATRIX * m2,int copy_flag)
{
int * index;
int er;
EX_MATRIX * _ret,*ret;
EX_MATRIX * m1_c,*m2_c;
int i,j,k;
int h,v;
double acc;
	ret = 0;
	if ( copy_flag ) {
		m1_c = copy_ex(m1);
		m2_c = copy_ex(m2);
	}
	else {
		m1_c = m1;
		m2_c = m2;
	}
	index = d_alloc(sizeof(int)*m2->v_size);
	er = ex_uppertriangle(m1_c,m2_c,index);
	if ( er< 0 ) {
		if ( erp )
			*erp = er;
		goto err1;
	}
	_ret = new_ex_matrix(m2->v_size,m2->h_size);
	h = m2->h_size;
	v = m2->v_size;
	for ( i = 0 ; i < h ; i ++ ) {
		for ( j = v-1 ; j >= 0 ; j -- ) {
			acc = 0;
			for ( k = v-1 ; k > j ; k -- )
				acc += XD(_ret,k,i)*XD(m1,j,k);
			XD(_ret,j,i) = (XD(m2,j,i) - acc)/XD(m1,j,j);
		}
	}
	ret = new_ex_matrix(m2->v_size,m2->h_size);
	for ( i = 0 ; i < v ; i ++ ) {
		k = index[i];
		for ( j = 0 ; j < h ; j ++ )
			XD(ret,k,j) = XD(_ret,i,j);
	}
	d_f_ree(_ret);
	if ( erp )
		*erp = 0;
err1:
	d_f_ree(index);
	if ( copy_flag ) {
		d_f_ree(m1_c);
		d_f_ree(m2_c);
	}
	return ret;
}


EX_LSM_WORK*
new_ex_lsm(int from,int to)
{
EX_LSM_WORK * ret;
	ret = d_alloc(sizeof(*ret));
	ret->from = from;
	ret->to = to;
	ret->m =  new_ex_matrix(from+1,from+1);
	ret->q =  new_ex_matrix(from+1,to);
	return ret;
}

int
ex_lsm_insert(EX_LSM_WORK * w,EX_MATRIX * p,EX_MATRIX * q)
{
int i,j;
int from,to;
double a;
	from = w->from;
	to = w->to;
	if ( p->h_size == from && p->v_size == 1 )
		goto ok;
	if ( p->h_size == 1 && p->v_size == from )
		goto ok;
	if ( q->h_size == to && q->v_size == 1 )
		goto ok;
	if ( q->h_size == 1 && q->v_size == to )
		goto ok;
	return -1;
ok:
	for ( i = 0 ; i < from ; i ++ ) {
		XD(w->m,i,i) += p->d[i]*p->d[i];
		for ( j = i+1 ; j < from ; j ++ ) {
			a = p->d[i]*p->d[j];
			XD(w->m,i,j) += a;
			XD(w->m,i,j) += a;
		}
		XD(w->m,i,from) = a = p->d[i];
		XD(w->m,from,i) += a;
		XD(w->m,from,from) += 1;
	}
	
	for ( i = 0 ; i < to ; i ++ ) {
		for ( j = 0 ; j < from ; j ++ ) {
			XD(w->q,j,i) += p->d[j]*q->d[i];
		}
	}
	return 0;
}

EX_MATRIX *
ex_get_lsm(int * erp,EX_LSM_WORK * w)
{
EX_MATRIX * ret;
EX_MATRIX * ans;
int i,j;
int er;
int from,to;
	ret = 0;
	from = w->from;
	to = w->to;
	ret = new_ex_matrix(to+1,from+1);
	ans = ex_equation(&er,w->m,w->q,0);
	if ( er < 0 ) {
		if ( erp )
			*erp = er;
		goto err1;
	}
	ret = new_ex_matrix(to+1,from+1);
	for ( i = 0 ; i < from+1 ; i ++ ) {
		for ( j = 0 ; j < to ; j ++ )
			XD(ret,j,i) = XD(ans,i,j);
	}
	for ( i = 0 ; i < from ; i ++ )
		XD(ret,to,i) = 0;
	XD(ret,to,from) = 1;
	d_f_ree(ans);
	if ( erp )
		*erp = 0;
err1:
	return ret;
}


void
free_lsm(EX_LSM_WORK * w)
{
	d_f_ree(w->m);
	d_f_ree(w->q);
	d_f_ree(w);
}


int
ex_insert_hrect(EX_MATRIX * hrect,EX_MATRIX * p)
{
int i;
double a;
	if ( hrect->v_size == p->v_size ) {
		if ( p->h_size != 1 )
			return -2;
	}
	else if ( hrect->v_size == p->h_size ) {
		if ( p->v_size != 1 )
			return -3;
	}
	else	return -1;
	if ( XD(hrect,0,0) > XD(hrect,0,1) ) {
		for ( i = 0 ; i < hrect->v_size ; i ++ )
			XD(hrect,i,0) = XD(hrect,i,1) = p->d[i];
	}
	else {
		for ( i = 0 ; i < hrect->v_size ; i ++ ) {
			a = p->d[i];
			if ( XD(hrect,i,0) > a )
				XD(hrect,i,0) = a;
			if ( XD(hrect,i,1) < a )
				XD(hrect,i,1) = a;
		}
	}
	return 0;
}



