/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"memory_debug.h"
#include	"utils.h"

void
clean_empty_dir(L_CHAR * dir,int base_len)
{
DIR * dd;
struct dirent * d;
L_CHAR * dir_path;
int i;

	if ( l_strlen(dir) <= base_len )
		return; 
	dd = u_opendir(n_string(std_cm,dir));
	if ( dd == 0 )
		return;
	for ( ; ; ) {
		d = u_readdir(dd);
		if ( d == 0 )
			break;
		if ( d->d_name[0] == '.' )
			continue;
		secure_closedir(dd);
		return;
	}
	secure_closedir(dd);
	u_unlink(n_string(std_cm,dir));
	dir_path = ll_copy_str(dir);
	for ( i = l_strlen(dir)-1 ; i >= 0 && dir_path[i] != '/' ; i -- );
	if (  i > 0 ) {
		dir_path[i] = 0;
		clean_empty_dir(dir_path,base_len);
	}
	d_f_ree(dir_path);
	return;
}

