/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"xl.h"


XL_SEXP * xl_ErrHandler();
XL_SEXP * xl_Error();

void
init_ErrHandler(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"ErrHandler"),
		get_func_prim(xl_ErrHandler,FO_NORMAL,0,2,2));
	set_env(env,l_string(std_cm,"Error"),
		get_func_prim(xl_Error,FO_APPLICATIVE,0,3,3));
}

XL_SEXP *
err_handler(XL_SEXP * e,XL_FILE * f,int line,L_CHAR * err_stream)
{
XL_SEXP * ret;
	if ( get_type(e) != XLT_ERROR ) {
		ret = 0;
		ret = cons(e,ret);
		ret = cons(get_integer(0,0),ret);
		ret = cons(n_get_string("ErrHandler"),ret);

		if ( f ) {
			ret = cons(get_string(f->name),ret);
			ret = cons(get_string(f->site),ret);
		}
		else {
			ret = cons(n_get_string("undefined"),ret);
			ret = cons(n_get_string("unknown"),ret);
		}
		ret = cons(get_integer(line,0),ret);
		ret = cons(n_get_symbol("Error"),ret);
		return ret;
	}
	if ( err_stream ) {
		fprintf(stderr,"ERROR\n");
		u_exit(1);
	}
	ret = 0;
	ret = cons(e->err.data,ret);
	ret = cons(get_integer(e->err.code,0),ret);
	ret = cons(get_string(e->err.func),ret);
	ret = cons(get_string(e->err.filename),ret);
	ret = cons(get_string(e->err.site),ret);
	ret = cons(get_integer(e->err.line,0),ret);
	ret = cons(n_get_symbol("Error"),ret);
	return ret;
}

XL_SEXP *
xl_Error(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * t;
XL_FILE * f;
int ln;
	t = get_el(s,1);
	if ( t == 0 ) {
		f = s->h.file;
		ln = s->h.line;
	}
	else {
		f = t->h.file;
		ln = t->h.line;
	}
	return get_error(
		f,
		ln,
		XLE_PROTO_USER_ERROR,
		l_string(std_cm,"Error"),get_el(s,2));
}

XL_SEXP *
xl_ErrHandler(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
XL_SEXP * e;
XL_SEXP * ee;
L_CHAR * err_stream;
	ee = get_el(s,1);
	e = eval(env,ee);
	err_stream = get_sf_attribute(sf,l_string(std_cm,"stderr"));
	return err_handler(e,s->h.file,s->h.line,err_stream);
}
