/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xl.h"
#include	"xlerror.h"
#include	"utils.h"
#include	"memory_debug.h"

XL_SEXP * xl_SetDatabasePath();

void
init_SetDatabasePath(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"SetDatabasePath"),
		get_func_prim(xl_SetDatabasePath,FO_APPLICATIVE,0,2,3));
}

XL_SEXP *
xl_SetDatabasePath(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * docs,* sys;
L_CHAR * str;
L_CHAR url[2];
int p;
XL_SEXP * ret;
	docs = get_el(s,1);
	if ( get_type(docs) != XLT_STRING )
		goto type_missmatch;
	if ( list_length(s) == 2 )
		return List(docs,-1);
	sys = get_el(s,2);
	if ( get_type(sys) != XLT_STRING )
		goto type_missmatch;

	url[0] = '/';
	url[1] = 0;
	str = ll_copy_str(sys->string.data);
	for ( p = l_strlen(str)-1 ; p >= 0 ; p -- )
		if ( str[p] == '/' )
			break;
	str[p+1] = 0;
	if ( str[0] == 0 ) {
		d_f_ree(str);
		str = nl_copy_str(std_cm,"/");
	}

	if((Reg_List_pathpair((str),url))==-1) {
		ret = get_error(
			s->h.file,
			s->h.line,
			XLE_PROTO_INV_PARAM,
			l_string(std_cm,"SetDatabasePath"),
			n_get_string("Failed registory path_pair"));
		goto end;
	}
	ret = 0;
	goto end;
type_missmatch:
	ret = get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"SetDatabasePath"),
		n_get_string("type missmatch"));
end:
	d_f_ree(str);
	return ret;
}
