/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"memory_debug.h"
#include	"xlerror.h"
#include	"xl.h"

char ** argv;
int argc,v_offset;
XL_SEXP * xl_ThreadControl();


void
init_ThreadControl(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"ThreadControl"),
		get_func_prim(xl_ThreadControl,FO_APPLICATIVE,0,1,1));
}



XL_SEXP *
xl_ThreadControl(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
L_CHAR* arg;
int active;
int last_invoke_interval;
int th;
int interval;
XL_SEXP * ret;
char buffer[100];
	get_create_wait(&active,&last_invoke_interval,&th,&interval);
	arg = get_sf_attribute(sf,l_string(std_cm,"cw.Active"));
	if ( arg == 0 )
		goto next1;
	active = atoi(n_string(std_cm,arg));
next1:
	arg = get_sf_attribute(sf,l_string(std_cm,"cw.LastInvokeInterval"));
	if ( arg == 0 )
		goto next2;
	last_invoke_interval = atoi(n_string(std_cm,arg));
next2:
	arg = get_sf_attribute(sf,l_string(std_cm,"cw.Th"));
	if ( arg == 0 )
		goto next3;
	th = atoi(n_string(std_cm,arg));
next3:
	arg = get_sf_attribute(sf,l_string(std_cm,"cw.Interval"));
	if ( arg == 0 )
		goto next4;
	interval = atoi(n_string(std_cm,arg));
next4:
	set_create_wait(active,last_invoke_interval,th,interval);
	ret = n_get_symbol("ThreadControl");
	sprintf(buffer,"%i",active);
	set_attribute(ret,l_string(std_cm,"cw.Active"),l_string(std_cm,buffer));
	sprintf(buffer,"%i",last_invoke_interval);
	set_attribute(ret,l_string(std_cm,"cw.LastInvokeInterval"),l_string(std_cm,buffer));
	sprintf(buffer,"%i",th);
	set_attribute(ret,l_string(std_cm,"cw.Th"),l_string(std_cm,buffer));
	sprintf(buffer,"%i",interval);
	set_attribute(ret,l_string(std_cm,"cw.Interval"),l_string(std_cm,buffer));
	return ret;
}

