/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"xl.h"

int table_search(CU_TABLE ** t,char * name);
int standard_unit(CU_TABLE * t);


CU_TABLE tbl[] = {
	{"length",{
		{"inch",100/2.54},
		{"mm",1000},
		{"cm",100},
		{"m",1},
		{"km",-1000},
		{""}
	}},
	{"resolution",{
		{"dpi",0.01*2.54},
		{"dot/cm",-100},
		{"dot/m",1},
		{"dot/km",1000},
		{""}
	}},
	{""}
};

int
table_search(CU_TABLE ** t,char * name)
{
CU_TABLE * tt;
int i;
	for ( tt = tbl; tt->system[0] ; tt ++ ) {
		for ( i = 0 ; tt->unit[i].name[0] ; i ++ )
			if ( strcmp(tt->unit[i].name,name) == 0 ) {
				*t = tt;
				return i;
			}
	}
	return -1;
}

int
standard_unit(CU_TABLE * t)
{
int i;
	for ( i = 0 ; t->unit[i].name[0] ; i ++ )
		if ( t->unit[i].rate == 1 )
			return i;
	return -1;
}

/*
double
conv_unit(int * er,double inp,L_CHAR * from,L_CHAR * to)
{
int f,t;
CU_TABLE * t1,* t2;
double r1,r2;
	*er = 0;
	if ( from && to ) {
		f = table_search(&t1,n_string(std_cm,from));
		if ( f < 0 )
			goto err;
		t = table_search(&t2,n_string(std_cm,to));
		if ( t < 0 ) 
			goto err;
	}
	else if ( from ) {
		f = table_search(&t1,n_string(std_cm,from));
		if ( f < 0 )
			goto err;
		t = standard_unit(t1);
		t2 = t1;
	}
	else if ( to ) {
		t = table_search(&t2,n_string(std_cm,to));
		if ( t < 0 )
			goto err;
		f = standard_unit(t2);
		t1 = t2;
	}
	else {
		goto err;
	}
	if ( t1->unit[f].rate < 0 )
		r1 = -t1->unit[f].rate;
	else	r1 = 1/t1->unit[f].rate;
	if ( t2->unit[t].rate < 0 )
		r2 = 1/(-t2->unit[t].rate);
	else	r2 = t2->unit[t].rate;
	return inp*r1*r2;
err:
	*er = -1;
	return 0;
}

*/
