/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/




#include	"win_flame.h"

extern GBVIEW_ENV env;


int
nwf_assert()
{

	assert_ls(LSF_ASSERT);
	return 0;
}

int
new_win_flame(
	WF_ID *		ret_wfid,
	REAL1		v_reso,
	RESOURCE * 	draw,
	MAP_HISTORY * 	mh,
	GB_POINT	center,
	REAL1		rotate,
	REAL1		resolution)
{
WIN_FLAME_TABLE * tbl;
int ret;
void _wf_redraw_pri();

	lr_extend(draw,nwf_assert);

	if ( env.flame_base == 0 ) {
		tbl = wf_geo_type_list[
			draw->c.geometory_type>>GT_T_SHIFT]
			[WFT_STD];
	}
	else {
		tbl =
		wf_geo_type_list[
			env.flame_base->draw->c.geometory_type>>GT_T_SHIFT]
			[WFT_STD];
	}
	ret = (*tbl->f_new)(
			tbl,
			ret_wfid,
			v_reso,
			draw,
			mh,
			center,
			rotate,
			resolution);
	wakeup_task((int)&env.flame);
	wakeup_task((int)_wf_redraw_pri);
	return ret;
}


int
exit_win_flame(WIN_FLAME * wf)
{
int ret;
	ret = (*wf->tbl->f_exit)(wf);
	return ret;
}

int
win_flame_move(WIN_FLAME * wf,VPOINT from,VPOINT to,void * ix)
{
	if ( wf->flags & WFF_FREE )
		return -1;
	return (*wf->tbl->f_move)(wf,from,to,ix);
}


int
change_win_flame(WIN_FLAME * wf,int geo_type,int wf_type)
{
WIN_FLAME_TABLE * tbl;
int ret;
	if ( wf->flags & WFF_FREE )
		return -1;
	if ( geo_type && geo_type != wf->tbl->geo_type )
		goto next;
	if ( wf_type && wf_type != wf->tbl->wf_type )
		goto next;
	return -1;
next:
	if ( geo_type && wf_type )
		tbl = wf_geo_type_list[geo_type][wf_type];
	else if ( geo_type )
		tbl = wf_geo_type_list[geo_type][wf->tbl->wf_type];
	else	tbl = wf_geo_type_list[wf->tbl->geo_type][wf_type];
	ret = (tbl->f_change)(tbl,wf);
	return ret;
}

int
win_flame_redraw(WIN_FLAME * wf)
{
int ret;

	if ( wf->flags & WFF_FREE )
		return -1;
	if ( wf->tbl == 0 )
		return -1;
	if ( wf->tbl->f_flame_redraw == 0 )
		return 0;
	ret = (*wf->tbl->f_flame_redraw)(wf);
	return ret;
}

int
_win_flame_dirty(WIN_FLAME * wf,GB_RECT * r,int flags,int mode)
{
	if ( wf->flags & WFF_FREE )
		return -1;
	if ( wf->tbl == 0 )
		return -1;
	if ( wf->tbl->f_dirty == 0 )
		return 0;
	return (*wf->tbl->f_dirty)(wf,r,flags,mode);
}

int
win_flame_dirty(WF_ID wfid,GB_RECT * r,int flags,int mode)
{
int ret;
WIN_FLAME * wf;
	lock_task(env.wf_lock);
set_t_msg(70);
	wf = _get_wf_ptr(wfid);
	if ( wf )
		ret = _win_flame_dirty(wf,r,flags,mode);
	else	ret = -1;
	unlock_task(env.wf_lock,"win_flame_dirty");
	return ret;
}

int
win_flame_overlay(WIN_FLAME * wf,OV_ARG * a)
{
	if ( wf->flags & WFF_FREE )
		return -1;
	if ( wf->tbl->f_overlay == 0 )
		return 0;
	return (*wf->tbl->f_overlay)(wf,a);
}

int
win_flame_zoom(WIN_FLAME * wf,int w,int h,int * ix_x,int * ix_y)
{
	if ( wf->flags & WFF_FREE )
		return -1;
	if ( wf->tbl->f_zoom == 0 )
		return 0;
	return (*wf->tbl->f_zoom)(wf,w,h,ix_x,ix_y);
}

int
win_flame_resize(WIN_FLAME * wf)
{
	if ( wf->flags & WFF_FREE )
		return -1;
	if ( wf->tbl->f_resize == 0 )
		return 0;
	return (*wf->tbl->f_resize)(wf);
}


int
win_flame_rotate(WIN_FLAME * wf,VPOINT * ix)
{
	if ( wf->flags & WFF_FREE )
		return -1;
	if ( wf->tbl->f_rotate == 0 )
		return 0;
	return (*wf->tbl->f_rotate)(wf,ix);
}
