/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
		Atsushi MURAMATSU <muramatsu@s-cradle.com>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<unistd.h>
#include	<sys/types.h>
#include	<sys/time.h>
#include	<sys/resource.h>
#include	<sys/param.h>
#include	<sys/sysctl.h>
#include	"utils.h"
#include	"limits.h"

void
_print_rlim(int type)
{
int er;
struct rlimit r;
	er = getrlimit(type,&r);
	if ( er < 0 ) {
		fprintf(stderr,"%i\t",type);
		perror("");
	}
	else {
		fprintf(stderr,"%i :\t%i - %i\n",
			type,
			r.rlim_cur,
			r.rlim_max);
	}
}

unsigned int
_get_mem_size()
{
static unsigned int mem_size;
struct rlimit rr;
unsigned int ret;
size_t len;
int mib[2];
	if ( mem_size )
		return mem_size;
	mib[0] = CTL_HW;
	mib[1] = HW_USERMEM;
	len = sizeof(ret);
	sysctl(mib,2,&ret,&len,NULL,0);
	getrlimit(RLIMIT_DATA,&rr);
	if ( ret > (unsigned int)rr.rlim_max )
		ret = rr.rlim_max;
	mem_size = ret;
	return ret;
}

