/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<stdlib.h>
#include	<string.h>
#include	"utils.h"
#include	"memory_debug.h"

static char * preference_path;
static char * peripheral_path;
char xlpconf[] = ".pxlconf/";
char gvperipheral[] = "peripheral/";

char * command_arg;

char *
get_preference_path()
{
char * h, *buf;
int len,len2;
	if ( preference_path )
		return preference_path;
	h = getenv("HOME");
	len = strlen(h);
	len2 = strlen(xlpconf);
	buf = d_alloc(len+len2+2,363);
	strcpy(buf,h);
	if ( buf[len-1] != '/' ) {
		buf[len] = '/';
		buf[len+1] = 0;
	}
	h = &buf[strlen(buf)];
	strcpy(h,xlpconf);
	
	preference_path = normalize_delim_str(buf);
	if ( buf != preference_path )
		d_f_ree(buf);
	return preference_path;
}




char *
get_peripheral_path()
{
char * h;
int len,len2;
char * per;
	if ( peripheral_path )
		return peripheral_path;
	h = getenv("GV_PERIPHERAL");
	if ( h ) {
		peripheral_path = copy_str(h);
		goto ok;
	}
	per = which(command_arg);
	if ( per == 0 ) {
		peripheral_path = copy_str("./");
		goto ok;
	}
	else {
		peripheral_path = per;
		goto ok;
	}
ok:
	peripheral_path = d_re_alloc(peripheral_path,
		strlen(peripheral_path)+strlen(gvperipheral)+10);
	len = strlen(peripheral_path);
	if ( peripheral_path[len-1] != '/' ) {
		peripheral_path[len] = '/';
		peripheral_path[len+1] = 0;
	}
	if ( strcmp(&peripheral_path[len-4],"bin/") == 0 )
		peripheral_path[len-4] = 0;
	h = &peripheral_path[strlen(peripheral_path)];
	strcpy(h,gvperipheral);
	return peripheral_path;
}



