/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___V_TYPES_H___
#define ___V_TYPES_H___

//#define CB_MACHINE_ORDER	CB_MSBFirst

#define NeedFunctionPrototypes 1
#include <windows.h>

//ANG07   //ANG09	
typedef struct {
	HINSTANCE hinst;
} Display;

//ANG09
typedef HWND Window;

typedef struct {
	int id;
} Visual;
typedef struct {
	int id;
} Colormap;

typedef HDC GC;

typedef struct vobj_header {
	int			type;
	union vobject *		next;
	struct vwindow *	win;
	int			(*handler)(/* obj, cmd, ...*/);
	/* cmd */
#define VE_REDRAW	1
#define VE_BUTTON	2
#define VE_MAX		3

#define VES_BUTTON_PRESS	1
#define VES_BUTTON_RELEASE	2
#define VES_BUTTON_MOTION	3
} VOBJ_HEADER;

/*
typedef struct vimage {
	VOBJ_HEADER		_h;
	long *			buf;
	int			x;
	int			y;
	int			w;
	int			h;
	HBITMAP		ximage;
	char *dib_buffer;
} VIMAGE;
*/

typedef struct vimage {
	VOBJ_HEADER		_h;
/*	long *			buf; */

	char *			buf_8;
	short *			buf_16;
	long *			buf_32;
	int			x;
	int			y;
	int			w;
	int			h;
	int			w_border;

	int			select_flag;
		/* 1 --> select */
		/* 0 --> not select */
	VPOINT			select[2];

	HBITMAP 		ximage;
	char *dib_buffer;
} VIMAGE;

typedef struct vtext {
	VOBJ_HEADER		_h;
	int			mode;
#define VT_TRANS		1
#define VT_BACKGROUND	2
	int				size;
	int				dir;
	char *			font_name;
	HFONT			id;
	int			st_x;
	int			st_y;
	L_CHAR*		data;
	int			length;
	unsigned long		color;
	unsigned long		background;
	VRECT				minrect;
} VTEXT;

typedef union vobject {
	VOBJ_HEADER	header;
#define VT_IMAGE	1
#define VT_TEXT		2
	VIMAGE		vimage;
	VTEXT		vtext;
} VOBJECT;

typedef struct v_map_tbl {
	unsigned int *		map[3];
#define GB2M_R	0
#define GB2M_G	1
#define GB2M_B	2
	int			pixel_bits;
	char			red_shift;
	char			green_shift;
	char			blue_shift;
	unsigned long		red_mask;
	unsigned long		green_mask;
	unsigned long		blue_mask;
	unsigned long		red_mul;
	unsigned long		green_mul;
	unsigned long		blue_mul;
} V_MAP_TBL;

typedef struct vfont {
/*
	char *		fontname;
	unsigned char	charset;
	HFONT	fs;
*/
	LOGFONT lf;
} VFONT;

typedef struct vdisplay {
	int			(*err_handler)();
	struct vwindow *	win_list;
	void			(*handler[VE_MAX])();
	WCT *			wct;

	struct vdisplay *	next;
	Display *		d;
	Window			r; /* root window */
	Visual *		visual;
	Colormap		cmap;
	V_MAP_TBL		gb2m_map;
/*
	VFONT font_ansi;
	VFONT font_easteurope;
	VFONT font_default;
	VFONT font_russian;
	VFONT font_arabic;
	VFONT font_greek;
	VFONT font_hebrew;
	VFONT font_turkish;
	VFONT font_baltic;
	VFONT font_chinesebig5;
	VFONT font_gb2312;
	VFONT font_hangul;
	VFONT font_mac;
	VFONT font_oem;
	VFONT font_shiftjis;
*/
	VFONT                   jisx0201;
    VFONT                   jisx0208_1978;
    VFONT                   jisx0208_1983;
    VFONT                   jisx0208_1990;
    VFONT                   jisx0212_1990;
	VFONT                   iso8859_1;
	VFONT                   iso8859_2;
	VFONT                   iso8859_3;
	VFONT                   iso8859_4;
	VFONT                   iso8859_5;
	VFONT                   iso8859_6;
	VFONT                   iso8859_7;
	VFONT                   iso8859_8;
	VFONT                   iso8859_9;
	VFONT                   iso8859_10;
	VFONT                   iso8859_11;
	VFONT                   iso8859_12;
	VFONT                   iso8859_13;
	VFONT                   iso8859_14;
	VFONT                   iso8859_15;
/*	
	ANSI_CHARSET@iiso-8859-1j
	EASTEUROPE_CHARSET ([bp = iso-8859-2j
	DEFAULT_CHARSET@(iso8859-3, iso-8859-4 Ȃǂ܂Ƃ߂)
	RUSSIAN_CHARSET iVA = iso8859-5j
	ARABIC_CHARSET (ArA = iso8859-6 WIN95,98,MEł͔T|[g )
	GREEK_CHARSET@(MV = iso-8859-7)
	HEBREW_CHARSET@iwuC = iso-8859-8 WIN95,98,MEł͔T|[g )
	TURKISH_CHARSET (gR = iso-8859-9)
	BALTIC_CHARSET@iogj
	CHINESEBIG5_CHARSET@ij
	GB2312_CHARSET@(CMXp)
	HANGUL_CHARSET (؍)
	MAC_CHARSET (MAC)
	OEM_CHARSET (܂sł)
	SHIFTJIS_CHARSET ({Sfhit_JIS)
	SYMBOL_CHARSET (L)
*/

//	VFONT			jis_font;
//	VFONT			ascii_font;
    WCT *                   font_work;
    int                     font_flag;
    int                     depth;
} VDISPLAY;

#define GET_RGB_MAP(tbl,d)	\
	{				\
	(tbl).map[0] = (d)->gb2m_map[0];	\
	(tbl).map[1] = (d)->gb2m_map[1];	\
	(tbl).map[2] = (d)->gb2m_map[2];	\
	}

#define GB2MCOLOR(tbl,f)	\
	((tbl).map[0][(f)&COL_MASK]|			\
		(tbl).map[1][((f)>>COL_BIT)&COL_MASK]|	\
		(tbl).map[2][((f)>>(COL_BIT*2))&COL_MASK])

#define MCOLOR2GB(r,g,b,tbl,f)	\
	{							\
		(r) = ((((unsigned long)(f))&(tbl).red_mask)	\
				>>(tbl).red_shift)		\
				*(tbl).red_mul;			\
		(g) = ((((unsigned long)(f))&(tbl).green_mask)	\
				>>(tbl).green_shift)		\
				*(tbl).green_mul;		\
		(b) = ((((unsigned long)(f))&(tbl).blue_mask)	\
				>>(tbl).blue_shift)		\
				*(tbl).blue_mul;		\
	}

#define GB2MCOLOR_D(d,f)	GB2MCOLOR(d->gb2m_map,f)

typedef struct vwindow {
	struct vwindow *	next;
	VOBJECT *		obj_list;

	VDISPLAY *		d;
	Window 			w;
	GC				gc;
} VWINDOW;

typedef struct vwindow_attributes {
	int			x;
	int			y;
	int			w;
	int			h;
} VWINDOW_ATTRIBUTES;

VWINDOW * _get_vwin(VDISPLAY *,Window);

HWND ghWnd;
HDC ghBufferDC;
HBITMAP ghBufferImage,ghBufferImageOld;

DWORD gdwThreadID;

#define	MYMSG_INVRECT	(WM_USER + 1)

#define CB_MACHINE_ORDER	CB_MSB_FIRST

#endif
