/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	<stdio.h>
#include	<stdlib.h>

char * attr[100];
char * data[100];


char * q_url,*q_type,* tx,*ty,*bx,*by,* z_url, *rotate;

void
divide(char * q)
{
int i;
char * p;
	p = q;
	for ( i = 0 ; ; i ++ ) {
		attr[i] = p;
		for ( ; *p &&
			*p != '&' &&
			*p != '=' ; p ++ );
		switch ( *p ) {
		case 0:
			return;
		case '&':
			data[i] = "";
			*p ++ = 0;
			break;
		case '=':
			*p ++ = 0;
			data[i] = p;
			for ( ; *p &&
				*p != '&';
				p ++ );
			switch ( *p ) {
			case '&':
				*p ++ = 0;
				break;
			default:
				return;
			}
			break;
		}
	}
}

void
print_divide()
{
int i;
	printf("Content-type: text/plain\n\n");
	for ( i = 0 ; ; i ++ ) {
		if ( attr[i] == 0 )
			break;
		printf("(%s) = (%s)\n",attr[i],data[i]);
	}
}

char *
search_query(char * type,char * def)
{
int i;
	for ( i = 0 ; attr[i] ; i ++ )
		if ( strcmp(attr[i],type) == 0 )
			return data[i];
	return def;
}


void
output()
{
	printf("Content-type: text/gb\n\n");
	printf("([?xl version=\"0.1\" encoding=\"EUC-JP\"])\n");
	printf("([gv-resource rid=\"6\"] \n");
	if ( q_url ) {
		printf(" (%s \n",q_type);
		printf("  (URL \"%s\")) \n",q_url);
	}
	if ( z_url ) {
		printf(" (gv-zoom \"%s\" \n",z_url);
		if ( tx && ty && bx && by ) {
			printf("  (List \n");
			printf("   (List %s %s ) \n",tx,ty);
			printf("   (List %s %s )))\n",bx,by);
		}
		else {
			printf("  )\n");
		}
	}
	printf(")\n");
	return;
}

void
gbtypes()
{
	q_type = search_query("q-type","gv-insert-query");
	q_url = search_query("q-url",0);
	z_url = search_query("z-url",0);
	tx = search_query("tx",0);
	ty = search_query("ty",0);
	bx = search_query("bx",0);
	by = search_query("by",0);
	rotate = search_query("rotate","0");
}

int
main()
{
char * q;
	q = getenv("QUERY_STRING");
	divide(q);
	gbtypes();
	output();
	exit(0);
	return 0;
}